/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.fields.CustomFieldDTO;
import org.cyclos.model.system.fields.CustomFieldData;
import org.cyclos.security.system.BaseCustomFieldServiceSecurity;

public abstract class BaseSimpleCustomFieldServiceSecurity<DTO extends CustomFieldDTO, CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, D extends CustomFieldData<DTO>, DP>
extends BaseCustomFieldServiceSecurity<DTO, CF, C, PV, D, DP> {
    protected final Permission viewPermission;
    protected final Permission managePermission;

    public BaseSimpleCustomFieldServiceSecurity(Class<CF> clazz, Permission permission, Permission permission2) {
        super(clazz);
        this.viewPermission = permission;
        this.managePermission = permission2;
    }

    @Override
    public final boolean doHasManageAccess(CF CF) {
        return this.hasManagePermission();
    }

    @Override
    public final boolean doHasViewAccess(CF CF) {
        return this.hasViewPermission();
    }

    @Override
    protected final void checkCreateNew(DP DP) {
        this.checkManagePermission();
    }

    protected final void checkManagePermission() throws PermissionDeniedException {
        if (!this.hasManagePermission()) {
            throw new PermissionDeniedException();
        }
    }

    protected final void checkViewPermission() throws PermissionDeniedException {
        if (!this.hasViewPermission()) {
            throw new PermissionDeniedException();
        }
    }

    protected final boolean hasManagePermission() {
        return this.managePermission == null ? true : this.hasPermission(this.managePermission);
    }

    protected final boolean hasViewPermission() {
        return this.viewPermission == null ? true : this.hasPermission(this.viewPermission);
    }
}

