/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.messaging;

import org.cyclos.entities.messaging.BaseSms;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.messaging.SmsServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.messaging.messages.InboundSmsMessageVO;
import org.cyclos.model.messaging.messages.InboundSmsQuery;
import org.cyclos.model.messaging.messages.OutboundSmsMessageVO;
import org.cyclos.model.messaging.messages.OutboundSmsQuery;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.messaging.SmsService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class SmsServiceSecurity
extends BaseServiceSecurity
implements SmsService {
    @Autowired
    private SmsServiceLocal smsService;

    public InboundSmsMessageVO getInboundMessageData(Long l) throws FrameworkException {
        return this.smsService.getInboundMessageData(l);
    }

    public OutboundSmsMessageVO getOutboundMessageData(Long l) throws FrameworkException {
        return this.smsService.getOutboundMessageData(l);
    }

    public Page<InboundSmsMessageVO> searchInboundMessages(InboundSmsQuery inboundSmsQuery) {
        this.checkView();
        return this.smsService.searchInboundMessages(inboundSmsQuery);
    }

    public Page<OutboundSmsMessageVO> searchOutboundMessages(OutboundSmsQuery outboundSmsQuery) {
        this.checkView();
        return this.smsService.searchOutboundMessages(outboundSmsQuery);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<BaseSms>(BaseSms.class){

            public boolean isVisible(SessionData sessionData, BaseSms baseSms) {
                boolean bl = baseSms.getUser() == null;
                boolean bl2 = !bl && sessionData.manages(baseSms.getUser());
                return SmsServiceSecurity.this.canView() && (bl || bl2);
            }
        };
    }

    private boolean canView() {
        return this.hasPermission(Permission.SMS_MESSAGES_VIEW);
    }

    private void checkView() {
        if (!this.canView()) {
            throw new PermissionDeniedException();
        }
    }
}

