/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.messaging;

import com.querydsl.core.types.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.messaging.NotificationSettings;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.QUserProductNotification;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.messaging.NotificationSettingsServiceLocal;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.SetProperty;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.notifications.AdminNotificationType;
import org.cyclos.model.messaging.notificationsettings.AdminNotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.AdminNotificationSettingsData;
import org.cyclos.model.messaging.notificationsettings.EmailUnsubscribeData;
import org.cyclos.model.messaging.notificationsettings.NotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.NotificationSettingsData;
import org.cyclos.model.messaging.notificationsettings.NotificationTypeSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.UserNotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.UserNotificationSettingsData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.messaging.NotificationSettingsService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class NotificationSettingsServiceSecurity
extends BaseServiceSecurity
implements NotificationSettingsService {
    @Autowired
    private NotificationSettingsServiceLocal notificationSettingsService;

    public void emailUnsubscribe(String string) throws FrameworkException {
        this.notificationSettingsService.emailUnsubscribe(string);
    }

    public NotificationSettingsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        this.checkViewSettingsOf(basicUser);
        NotificationSettingsData notificationSettingsData = this.notificationSettingsService.getData(userLocatorVO);
        notificationSettingsData.setCanManage(this.canManageNotificationsOf(basicUser));
        return notificationSettingsData;
    }

    public EmailUnsubscribeData getEmailUnsubscribeData(String string) throws FrameworkException {
        return this.notificationSettingsService.getEmailUnsubscribeData(string);
    }

    public void save(@NotNull NotificationSettingsDTO notificationSettingsDTO) throws FrameworkException {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)notificationSettingsDTO.getUser());
        this.checkManageNotificationsOf(basicUser);
        this.checkNotificationSettings(notificationSettingsDTO, basicUser);
        this.notificationSettingsService.save(notificationSettingsDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<NotificationSettings>(NotificationSettings.class){

            public boolean isVisible(SessionData sessionData, NotificationSettings notificationSettings) {
                return NotificationSettingsServiceSecurity.this.canViewSettingsOf(notificationSettings.getUser());
            }
        };
    }

    private boolean canHaveSettings(Operator operator) {
        boolean bl = this.productsHandler.getAccessor((BasicUser)operator).memberOrBroker().getNotifications().isAnyKeySet((Path)QUserProductNotification.userProductNotification.enabled);
        if (!bl) {
            return false;
        }
        if (operator.isAliasOperator()) {
            return true;
        }
        return operator.getGroup().isNotifications();
    }

    private boolean canManageNotificationsOf(BasicUser basicUser) {
        if (basicUser.isOperator()) {
            return this.permission(basicUser).my(new Permission[]{Permission.MY_NOTIFICATION_SETTINGS_ENABLE}).user(new Permission[]{Permission.USER_OPERATORS_MANAGE}).granted();
        }
        return this.permission(basicUser).my(new Permission[]{Permission.MY_NOTIFICATION_SETTINGS_ENABLE}).user(new Permission[]{Permission.USER_NOTIFICATION_SETTINGS_MANAGE}).granted();
    }

    private boolean canViewSettingsOf(BasicUser basicUser) {
        SessionData sessionData = this.getSessionData();
        if (basicUser.isOperator()) {
            if (!this.canHaveSettings((Operator)basicUser)) {
                return false;
            }
            if (basicUser.equals((Object)sessionData.getLoggedBasicUser())) {
                return true;
            }
            return this.permission(basicUser).my(new Permission[]{Permission.MY_OPERATORS_MANAGE_OPERATORS}).user(new Permission[]{Permission.USER_OPERATORS_MANAGE}).granted();
        }
        return this.permission(basicUser).my(new Permission[]{Permission.MY_NOTIFICATION_SETTINGS_ENABLE}).user(new Permission[]{Permission.USER_NOTIFICATION_SETTINGS_VIEW}).granted();
    }

    private void checkManageNotificationsOf(BasicUser basicUser) {
        if (!this.canManageNotificationsOf(basicUser)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkNotificationSettings(NotificationSettingsDTO notificationSettingsDTO, BasicUser basicUser) {
        Object object;
        NotificationSettingsData notificationSettingsData = this.notificationSettingsService.getData(new UserLocatorVO(basicUser.getId()));
        UserNotificationSettingsDTO userNotificationSettingsDTO = null;
        if (notificationSettingsData instanceof UserNotificationSettingsData) {
            userNotificationSettingsDTO = ((UserNotificationSettingsData)notificationSettingsData).getNotificationSettings();
        } else if (notificationSettingsData instanceof AdminNotificationSettingsData) {
            object = (AdminNotificationSettingsData)notificationSettingsData;
            userNotificationSettingsDTO = object.getNotificationSettings();
            Validator validator = new Validator();
            EnumSet.allOf(AdminNotificationType.class).forEach(arg_0 -> NotificationSettingsServiceSecurity.lambda$checkNotificationSettings$0(validator, (AdminNotificationSettingsData)object, arg_0));
            validator.property((Property)AdminNotificationSettingsDTO.FWD_MESSAGE_CATEGORIES_TO_EMAIL, MessagingKeys.NotificationSettings.FWD_MESSAGE_TO_EMAIL).anyOf((Collection)object.getMessageCategories());
            this.validate(validator, notificationSettingsDTO);
        }
        if (userNotificationSettingsDTO == null) {
            throw new ValidationException();
        }
        object = CollectionHelper.orEmpty((List)userNotificationSettingsDTO.getNotificationTypeSettings()).stream().collect(Collectors.toMap(NotificationTypeSettingsDTO::getType, notificationTypeSettingsDTO -> notificationTypeSettingsDTO));
        for (NotificationTypeSettingsDTO notificationTypeSettingsDTO2 : notificationSettingsDTO.getNotificationTypeSettings()) {
            NotificationTypeSettingsDTO notificationTypeSettingsDTO3 = (NotificationTypeSettingsDTO)object.get(notificationTypeSettingsDTO2.getType());
            if (notificationTypeSettingsDTO3 == null) {
                notificationTypeSettingsDTO2.setNotifyByInternal(Boolean.valueOf(false));
                notificationTypeSettingsDTO2.setNotifyByEmail(Boolean.valueOf(false));
                notificationTypeSettingsDTO2.setNotifyBySms(Boolean.valueOf(false));
                continue;
            }
            if (notificationTypeSettingsDTO3.getNotifyByEmail() == null) {
                notificationTypeSettingsDTO2.setNotifyByEmail(Boolean.valueOf(false));
            }
            if (notificationTypeSettingsDTO3.getNotifyBySms() != null) continue;
            notificationTypeSettingsDTO2.setNotifyBySms(Boolean.valueOf(false));
        }
    }

    private void checkViewSettingsOf(BasicUser basicUser) {
        if (!this.canViewSettingsOf(basicUser)) {
            throw new PermissionDeniedException();
        }
    }

    private static /* synthetic */ void lambda$checkNotificationSettings$0(Validator validator, AdminNotificationSettingsData adminNotificationSettingsData, AdminNotificationType adminNotificationType) {
        MessageKey messageKey = AdminNotificationType.resolverForSettings().resolveKey((Enum)adminNotificationType);
        switch (adminNotificationType) {
            case EXTERNAL_PAYMENT_EXPIRED: 
            case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                SetProperty setProperty = adminNotificationType == AdminNotificationType.EXTERNAL_PAYMENT_EXPIRED ? AdminNotificationSettingsDTO.EXTERNAL_PAYMENTS_EXPIRED : AdminNotificationSettingsDTO.EXTERNAL_PAYMENTS_FAILED;
                validator.property((Property)setProperty, messageKey).anyOf((Collection)adminNotificationSettingsData.getExternalPayments());
                break;
            }
            case GENERATED_VOUCHERS_EXPIRED: {
                validator.property((Property)AdminNotificationSettingsDTO.VOUCHER_CONFIGURATIONS, messageKey).anyOf((Collection)adminNotificationSettingsData.getVoucherConfigurations());
                break;
            }
            case PAYMENT_AWAITING_AUTHORIZATION: {
                validator.property((Property)AdminNotificationSettingsDTO.AUTHORIZABLE_PAYMENTS, messageKey).anyOf((Collection)adminNotificationSettingsData.getNewPendingPayments());
                break;
            }
            case PAYMENT_PERFORMED: {
                validator.property((Property)AdminNotificationSettingsDTO.PAYMENTS, messageKey).anyOf((Collection)adminNotificationSettingsData.getPayments());
                break;
            }
            case SYSTEM_ALERT: {
                validator.property((Property)AdminNotificationSettingsDTO.SYSTEM_ALERTS, messageKey).anyOf((Collection)adminNotificationSettingsData.getSystemAlerts());
                break;
            }
            case USER_ALERT: {
                validator.property((Property)AdminNotificationSettingsDTO.USER_ALERTS, messageKey).anyOf((Collection)adminNotificationSettingsData.getUserAlerts());
                break;
            }
            case USER_REGISTRATION: {
                validator.property((Property)AdminNotificationSettingsDTO.USER_GROUPS, messageKey).anyOf((Collection)adminNotificationSettingsData.getNewUsers());
                break;
            }
            case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                validator.property((Property)AdminNotificationSettingsDTO.VOUCHER_CONFIGURATIONS_BUYING, messageKey).anyOf((Collection)adminNotificationSettingsData.getVoucherConfigurations());
                break;
            }
        }
    }
}

