/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.messaging;

import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.messaging.InviteServiceLocal;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.messaging.invite.SendInviteMessageDTO;
import org.cyclos.model.messaging.invite.SendInviteMessageData;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.messaging.InviteService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class InviteServiceSecurity
extends BaseServiceSecurity
implements InviteService {
    @Autowired
    private InviteServiceLocal inviteService;

    public boolean canSend() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.USER_INVITE);
    }

    public SendInviteMessageData getSendData() {
        if (!this.canSend()) {
            throw new PermissionDeniedException();
        }
        return this.inviteService.getSendData();
    }

    public void send(SendInviteMessageDTO sendInviteMessageDTO) {
        if (!this.canSend()) {
            throw new PermissionDeniedException();
        }
        this.inviteService.send(sendInviteMessageDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

