/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.messaging;

import java.util.Collection;
import java.util.List;
import org.cyclos.entities.messaging.Alert;
import org.cyclos.entities.messaging.SystemAlert;
import org.cyclos.entities.messaging.UserAlert;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.messaging.alerts.SystemAlertQuery;
import org.cyclos.model.messaging.alerts.SystemAlertSearchData;
import org.cyclos.model.messaging.alerts.SystemAlertVO;
import org.cyclos.model.messaging.alerts.UserAlertQuery;
import org.cyclos.model.messaging.alerts.UserAlertSearchData;
import org.cyclos.model.messaging.alerts.UserAlertVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.messaging.AlertService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AlertServiceSecurity
extends BaseServiceSecurity
implements AlertService {
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private NetworkServiceLocal networkService;

    public SystemAlertSearchData getSystemSearchData() throws FrameworkException {
        this.checkPermission(Permission.SYSTEM_ALERTS_VIEW);
        return this.alertService.getSystemSearchData();
    }

    public UserAlertSearchData getUserSearchData() throws FrameworkException {
        this.checkPermission(Permission.USER_ALERTS_VIEW);
        return this.alertService.getUserSearchData();
    }

    public Page<SystemAlertVO> searchSystem(SystemAlertQuery systemAlertQuery) {
        this.checkPermission(Permission.SYSTEM_ALERTS_VIEW);
        this.checkNetwork(systemAlertQuery);
        return this.alertService.searchSystem(systemAlertQuery);
    }

    public Page<UserAlertVO> searchUser(UserAlertQuery userAlertQuery) {
        this.checkPermission(Permission.USER_ALERTS_VIEW);
        this.groupsHandler.visibles().accessibles().basic().check((Collection)userAlertQuery.getGroups());
        return this.alertService.searchUser(userAlertQuery);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<Alert>(Alert.class){

            public boolean isVisible(SessionData sessionData, Alert alert) {
                return AlertServiceSecurity.this.hasViewAccess(alert);
            }
        };
    }

    private void checkNetwork(SystemAlertQuery systemAlertQuery) {
        List list;
        if (systemAlertQuery.getNetwork() != null && (CollectionHelper.isEmpty((Iterable)(list = this.networkService.getManagedNetworks())) || !list.contains(systemAlertQuery.getNetwork()))) {
            throw new PermissionDeniedException();
        }
    }

    private boolean hasViewAccess(Alert alert) {
        if (alert instanceof SystemAlert) {
            return this.permission(Permission.SYSTEM_ALERTS_VIEW).granted();
        }
        UserAlert userAlert = (UserAlert)alert;
        return this.permission((BasicUser)userAlert.getUser()).user(new Permission[]{Permission.USER_ALERTS_VIEW}).granted();
    }
}

