/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.marketplace;

import org.cyclos.entities.marketplace.AdWebShopSetting;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.marketplace.AdWebShopSettingServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.marketplace.webshopsettings.AdWebShopSettingDTO;
import org.cyclos.model.marketplace.webshopsettings.AdWebShopSettingData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.marketplace.AdWebShopSettingService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AdWebShopSettingServiceSecurity
extends BaseServiceSecurity
implements AdWebShopSettingService {
    @Autowired
    private AdWebShopSettingServiceLocal adWebShopSettingService;

    public AdWebShopSettingData getData(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        this.permissionOptionalValue(user).my(new Permission[]{Permission.MY_WEB_SHOP_ENABLE}).user(new Permission[]{Permission.USER_WEB_SHOP_SETTINGS_VIEW}).check();
        AdWebShopSettingData adWebShopSettingData = this.adWebShopSettingService.getData(userLocatorVO);
        this.productsHandler.getAccessor((BasicUser)user).product().hasPermission(Permission.MY_WEB_SHOP_ENABLE);
        boolean bl = user.equals((Object)this.getLoggedUser()) ? this.permissionOptionalValue(user).my(new Permission[]{Permission.MY_WEB_SHOP_MANAGE}).granted() : this.permissionOptionalValue(user).user(new Permission[]{Permission.USER_WEB_SHOP_SETTINGS_MANAGE}).granted() && this.productsHandler.getAccessor((BasicUser)user).product().hasPermission(Permission.MY_WEB_SHOP_ENABLE);
        adWebShopSettingData.setCanEdit(adWebShopSettingData.isCanEdit() && bl);
        return adWebShopSettingData;
    }

    public void save(AdWebShopSettingDTO adWebShopSettingDTO) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)adWebShopSettingDTO.getOwner());
        this.permissionOptionalValue(user).my(new Permission[]{Permission.MY_WEB_SHOP_MANAGE}).user(new Permission[]{Permission.USER_WEB_SHOP_SETTINGS_MANAGE}).check();
        this.adWebShopSettingService.save(adWebShopSettingDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<AdWebShopSetting>(AdWebShopSetting.class){

            public boolean isVisible(SessionData sessionData, AdWebShopSetting adWebShopSetting) {
                return AdWebShopSettingServiceSecurity.this.permissionOptionalValue(adWebShopSetting.getOwner()).my(new Permission[]{Permission.MY_WEB_SHOP_ENABLE}).user(new Permission[]{Permission.USER_WEB_SHOP_SETTINGS_VIEW}).granted();
            }
        };
    }
}

