/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.marketplace;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.Advertisement;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.UserPermissionCheck;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.marketplace.AdQuestionServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.advertisements.AdDataParams;
import org.cyclos.model.marketplace.advertisements.AdDetailsData;
import org.cyclos.model.marketplace.advertisements.AdSearchData;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.AdViewData;
import org.cyclos.model.marketplace.advertisements.AdvertisementDTO;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.model.marketplace.advertisements.BasicAdQuery;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.advertisements.UserAdsSearchData;
import org.cyclos.model.marketplace.advertisements.UserFavoriteAdsListData;
import org.cyclos.model.marketplace.categories.AdCategoryDetailedVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.marketplace.AdQuestionServiceSecurity;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.services.marketplace.AdService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AdServiceSecurity
extends CRUDServiceSecurity<BasicAdDTO, BasicAd, AdDetailsData, AdDataParams>
implements AdService {
    @Autowired
    private AdServiceLocal adService;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private AdQuestionServiceLocal adQuestionService;
    @Autowired
    private CurrencyServiceLocal currencyServiceLocal;
    @Autowired
    private AdCategoryServiceLocal adCategoryServiceLocal;
    @Autowired
    private AdQuestionServiceSecurity adQuestionServiceSecurity;

    public AdServiceSecurity() {
        super(BasicAd.class);
    }

    public void approve(@NotNull BasicAdVO basicAdVO) throws FrameworkException {
        this.checkApproveOrReject(basicAdVO);
        this.adService.approve(basicAdVO);
    }

    public boolean canActivateMyAd(boolean bl, boolean bl2, AdStatus adStatus) {
        return !bl2 || ObjectHelper.isOneOf((Object)adStatus, (Object[])new Object[]{AdStatus.HIDDEN, AdStatus.ACTIVE});
    }

    public boolean canActivateUserAd(boolean bl, boolean bl2, AdStatus adStatus, boolean bl3) {
        return bl && (!bl2 || bl3) || ObjectHelper.isOneOf((Object)adStatus, (Object[])new Object[]{AdStatus.ACTIVE, AdStatus.HIDDEN}) || adStatus == AdStatus.PENDING && bl3;
    }

    public boolean canHideOrUnhideAd(boolean bl, AdStatus adStatus, AdStatus adStatus2, User user) {
        return (user.equals((Object)this.getLoggedUser()) || this.isManagerOf((BasicUser)user)) && adStatus != AdStatus.DISABLED && (!bl && ObjectHelper.isNotOneOf((Object)adStatus2, (Object[])new Object[]{AdStatus.DRAFT, AdStatus.PENDING}) || ObjectHelper.isOneOf((Object)adStatus2, (Object[])new Object[]{AdStatus.HIDDEN, AdStatus.ACTIVE}));
    }

    public boolean canHideOrUnhideAd(boolean bl, BasicAd basicAd) {
        return this.hasManageAccess(basicAd.getAdType(), basicAd.getOwner()) && this.canHideOrUnhideAd(bl, basicAd.getStatus(), basicAd.getPersistedStatus(), basicAd.getOwner());
    }

    public boolean canManagePendingAds(User user, AdType adType) {
        if (!this.isManagerOf((BasicUser)user)) {
            return false;
        }
        return adType == AdType.ADVERTISEMENT ? this.hasPermission(Permission.USER_PENDING_ADS_MANAGE) : this.hasPermission(Permission.USER_PENDING_WEB_SHOP_MANAGE);
    }

    @Override
    public boolean canPerformOperation(BasicAd basicAd, CRUDOperation cRUDOperation) {
        SessionData sessionData = this.getSessionData();
        if (cRUDOperation == CRUDOperation.DELETE && basicAd.getOwner().equals((Object)sessionData.getLoggedUser()) && (basicAd.getType() == AdType.ADVERTISEMENT && sessionData.hasPermission(Permission.MY_ADS_MANAGE) || basicAd.getType() == AdType.WEB_SHOP && sessionData.hasPermission(Permission.MY_WEB_SHOP_MANAGE))) {
            return true;
        }
        return super.canPerformOperation(basicAd, cRUDOperation);
    }

    public boolean canSaveAsDraft(boolean bl, BasicAd basicAd) {
        boolean bl2 = this.getLoggedUser() != null && this.getLoggedUser().equals((Object)basicAd.getOwner());
        return bl && bl2 && (basicAd.isTransient() || basicAd.getStatus() == AdStatus.DRAFT);
    }

    public boolean canSetAsDraft(boolean bl, BasicAd basicAd) {
        return ObjectHelper.isOneOf((Object)basicAd.getPersistedStatus(), (Object[])new Object[]{AdStatus.ACTIVE, AdStatus.HIDDEN}) && basicAd.getStatus() != AdStatus.DISABLED && bl && (this.canManagePendingAds(basicAd.getOwner(), basicAd.getType()) || basicAd.getOwner().equals((Object)this.getLoggedUser()) && this.hasManageAccess(basicAd.getType(), basicAd.getOwner()));
    }

    public boolean canSubmitForAuthorization(BasicAd basicAd) {
        boolean bl = basicAd.getOwner().equals((Object)this.getLoggedUser());
        AdStatus adStatus = basicAd.isPersistent() ? basicAd.getPersistedStatus() : null;
        boolean bl2 = false;
        if (bl && this.adService.adRequiresAuthorization(basicAd) && (basicAd.isTransient() || adStatus == AdStatus.DRAFT)) {
            bl2 = true;
        } else if (basicAd.isTransient() && this.adService.adRequiresAuthorization(basicAd) && !this.canManagePendingAds(basicAd.getOwner(), basicAd.getType())) {
            bl2 = true;
        }
        return bl2 && this.hasManageAccess(basicAd.getAdType(), basicAd.getOwner());
    }

    public boolean canViewAddresses(User user) {
        return this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.VIEW);
    }

    public boolean canViewAuthorizationNotes(BasicAd basicAd) {
        if (basicAd.getOwner() == null || !this.adService.adRequiresAuthorization(basicAd) || !ObjectHelper.isOneOf((Object)basicAd.getPersistedStatus(), (Object[])new Object[]{AdStatus.DRAFT, AdStatus.PENDING})) {
            return false;
        }
        return basicAd.getOwner().equals((Object)this.getLoggedUser()) || this.canManagePendingAds(basicAd.getOwner(), basicAd.getType());
    }

    public boolean canViewPendings(AdType adType, User user, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !bl && this.isMember();
        if (bl2) {
            return true;
        }
        if (user != null && !this.isManagerOf((BasicUser)user)) {
            return false;
        }
        return adType == AdType.ADVERTISEMENT ? this.hasPermission(Permission.USER_PENDING_ADS_VIEW) : this.hasPermission(Permission.USER_PENDING_WEB_SHOP_VIEW);
    }

    @Override
    public boolean doHasManageAccess(BasicAd basicAd) {
        AdStatus adStatus = basicAd.isTransient() ? null : basicAd.getPersistedStatus();
        return this.hasManageAccess(basicAd.getDeletedDate(), basicAd.getStatus(), adStatus, basicAd.getType(), basicAd.getOwner());
    }

    @Override
    public boolean doHasViewAccess(BasicAd basicAd) {
        if (basicAd.getDeletedDate() != null) {
            return false;
        }
        SessionData sessionData = this.getSessionData();
        User user = basicAd.getOwner();
        boolean bl = basicAd.getAdType() == AdType.ADVERTISEMENT;
        Permission permission = bl ? Permission.MY_ADS_ENABLE : Permission.MY_WEB_SHOP_ENABLE;
        Permission permission2 = bl ? Permission.USER_ADS_VIEW : Permission.USER_WEB_SHOP_VIEW;
        boolean bl2 = this.productsHandler.getAccessor((BasicUser)user).member().hasPermission(permission);
        if (!bl2) {
            return false;
        }
        if (basicAd.getStatus() == AdStatus.PENDING) {
            return this.permission((BasicUser)user).my(new Permission[]{permission}).user(new Permission[]{bl ? Permission.USER_PENDING_ADS_VIEW : Permission.USER_PENDING_WEB_SHOP_VIEW}).granted();
        }
        if (sessionData.isLoggedIn()) {
            if (basicAd.getOwner().equals((Object)sessionData.getLoggedUser())) {
                if (basicAd.getStatus() == AdStatus.DISABLED) {
                    return false;
                }
                boolean bl3 = sessionData.isOperator() && sessionData.hasPermission(permission2);
                return bl3 || this.permission((BasicUser)user).my(new Permission[]{permission}).granted();
            }
            UserPermissionCheck userPermissionCheck = this.permission((BasicUser)user).user(new Permission[]{permission2});
            if (this.isManagerOf((BasicUser)user)) {
                return basicAd.getStatus() != AdStatus.DRAFT && userPermissionCheck.granted();
            }
            boolean bl4 = basicAd.getCurrency() == null || this.currencyServiceLocal.listForAds(null).contains(basicAd.getCurrency());
            return bl4 && basicAd.getStatus() == AdStatus.ACTIVE && userPermissionCheck.granted();
        }
        if (basicAd.getStatus() != AdStatus.ACTIVE) {
            return false;
        }
        AdType adType = basicAd.getType();
        Group group = basicAd.getOwner().getGroup();
        GroupSet groupSet = group instanceof UserGroup ? ((UserGroup)group).getGroupSet() : null;
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        Set set = configurationAccessor.getVisibleAdGroups();
        return (adType == AdType.ADVERTISEMENT ? configurationAccessor.isAllowViewUserAd() : configurationAccessor.isAllowViewUserWebShop()) && (set.contains(group) || set.contains(groupSet));
    }

    public FileInfo exportAd(ExportFormatVO exportFormatVO, BasicAdVO basicAdVO) throws FrameworkException {
        return this.adService.exportAd(exportFormatVO, basicAdVO);
    }

    public AdSearchData getAdSearchData(AdType adType, boolean bl) {
        this.checkView(adType, false);
        return this.adService.getAdSearchData(adType, bl);
    }

    public UserFavoriteAdsListData getFavoritesListData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = userLocatorVO == null ? null : this.userLocatorHandler.locate(userLocatorVO).getUser();
        this.checkFavoriteAds(user);
        UserFavoriteAdsListData userFavoriteAdsListData = this.adService.getFavoritesListData(userLocatorVO);
        userFavoriteAdsListData.setManage(this.permission((BasicUser)user).my(new Permission[]{Permission.MY_FAVORITE_ADS_ENABLE}).granted());
        return userFavoriteAdsListData;
    }

    public UserAdsSearchData getUserAdsSearchData(UserLocatorVO userLocatorVO, AdType adType) {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        this.checkView(adType, user.equals((Object)this.getLoggedUser()));
        UserAdsSearchData userAdsSearchData = this.adService.getUserAdsSearchData(userLocatorVO, adType);
        boolean bl = adType == null || adType == AdType.ADVERTISEMENT;
        userAdsSearchData.setCanCreateNew(userAdsSearchData.isCanCreateNew() && this.canCreateNew(bl, user));
        return userAdsSearchData;
    }

    public AdViewData getViewData(BasicAdVO basicAdVO) throws EntityNotFoundException {
        SessionData sessionData = this.getSessionData();
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        this.checkViewAccess(basicAd);
        AdViewData adViewData = this.adService.getViewData(basicAdVO);
        boolean bl = this.adQuestionService.isQuestionsEnabled(basicAd.getType(), basicAd.getOwner());
        boolean bl2 = sessionData.hasPermission(Permission.USER_WEB_SHOP_PURCHASE);
        boolean bl3 = bl && this.adQuestionServiceSecurity.canManageQuestionsAsBuyer(basicAd.getType()) && basicAd.getStatus() != AdStatus.DISABLED;
        adViewData.setQuestionsEnabled(adViewData.isQuestionsEnabled() && bl);
        adViewData.setCanAskQuestion(adViewData.isCanAskQuestion() && bl3);
        adViewData.setCanBuy(adViewData.isCanBuy() && bl2);
        adViewData.setEditable(adViewData.isEditable() && this.canPerformOperation(basicAd, CRUDOperation.UPDATE));
        adViewData.setRemovable(adViewData.isRemovable() && this.canPerformOperation(basicAd, CRUDOperation.DELETE));
        adViewData.setCanSetAsFavorite(adViewData.isCanSetAsFavorite() && sessionData.hasPermission(Permission.MY_FAVORITE_ADS_ENABLE));
        boolean bl4 = basicAd.getOwner().equals((Object)sessionData.getLoggedUser()) || sessionData.isManagerOf((BasicUser)basicAd.getOwner());
        BasicAdDTO basicAdDTO = (BasicAdDTO)adViewData.getDto();
        if (!bl4) {
            basicAdDTO.setStatus(null);
            MemberProductAccessor memberProductAccessor = sessionData.getProducts().member();
            if (!memberProductAccessor.isShowAdPublicationDate()) {
                basicAdDTO.getPublicationPeriod().setBegin(null);
            }
            if (!memberProductAccessor.isShowAdExpirationDate()) {
                basicAdDTO.getPublicationPeriod().setEnd(null);
            }
        }
        return adViewData;
    }

    public boolean hasManageAccess(AdType adType, User user) {
        return this.permission((BasicUser)user).my(new Permission[]{adType == AdType.ADVERTISEMENT ? Permission.MY_ADS_MANAGE : Permission.MY_WEB_SHOP_MANAGE}).user(new Permission[]{adType == AdType.ADVERTISEMENT ? Permission.USER_ADS_MANAGE : Permission.USER_WEB_SHOP_MANAGE}).granted();
    }

    public boolean hasManageAccess(Date date, AdStatus adStatus, AdStatus adStatus2, AdType adType, User user) {
        if (date != null || this.isGuest() || adStatus == AdStatus.DISABLED && !this.getSessionData().isManagerOf((BasicUser)user)) {
            return false;
        }
        if (this.adService.adRequiresAuthorization(adType, user)) {
            if (user.equals((Object)this.getLoggedUser())) {
                if (ObjectHelper.isOneOf((Object)adStatus2, (Object[])new Object[]{AdStatus.PENDING, AdStatus.ACTIVE, AdStatus.HIDDEN})) {
                    return false;
                }
            } else {
                if (adStatus2 == AdStatus.DRAFT) {
                    return false;
                }
                if (adStatus2 == AdStatus.PENDING) {
                    return this.canManagePendingAds(user, adType);
                }
            }
        }
        return this.hasManageAccess(adType, user);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, BasicAd basicAd) {
        return false;
    }

    public BasicAdVO loadVO(BasicAdVO basicAdVO) throws FrameworkException {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        this.checkViewAccess(basicAd);
        return this.adService.loadVO(basicAdVO);
    }

    public void markAsFavorite(@NotNull BasicAdVO basicAdVO, boolean bl) {
        SessionData sessionData = this.getSessionData();
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        this.checkViewAccess(basicAd);
        if (!sessionData.hasPermission(Permission.MY_FAVORITE_ADS_ENABLE)) {
            throw new PermissionDeniedException();
        }
        this.adService.markAsFavorite(basicAdVO, bl);
    }

    public void reject(@NotNull BasicAdVO basicAdVO, String string) throws FrameworkException {
        this.checkApproveOrReject(basicAdVO);
        this.adService.reject(basicAdVO, string);
    }

    public Page<BasicAdVO> search(BasicAdQuery basicAdQuery) {
        if (!this.checkQuery(basicAdQuery)) {
            return PageImpl.empty();
        }
        return this.adService.search(basicAdQuery);
    }

    public void setAsDraft(BasicAdVO basicAdVO, String string) {
        boolean bl;
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        boolean bl2 = this.adService.adRequiresAuthorization(basicAd);
        boolean bl3 = bl = basicAd.getOwner().equals((Object)this.getLoggedUser()) && bl2 && ObjectHelper.isOneOf((Object)basicAd.getPersistedStatus(), (Object[])new Object[]{AdStatus.ACTIVE, AdStatus.HIDDEN});
        if (!bl) {
            this.permission((BasicUser)basicAd.getOwner()).user(new Permission[]{basicAd instanceof Advertisement ? Permission.USER_PENDING_ADS_MANAGE : Permission.USER_PENDING_WEB_SHOP_MANAGE}).check();
        } else if (!this.hasManageAccess(basicAd.getType(), basicAd.getOwner())) {
            throw new PermissionDeniedException();
        }
        this.adService.setAsDraft(basicAdVO, string);
    }

    public void setHidden(BasicAdVO basicAdVO, boolean bl) {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        if (!this.hasManageAccess(basicAd.getAdType(), basicAd.getOwner())) {
            throw new PermissionDeniedException();
        }
        this.adService.setHidden(basicAdVO, bl);
    }

    public void submitForAuthorization(@NotNull BasicAdVO basicAdVO) {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        if (!this.hasManageAccess(basicAd)) {
            throw new PermissionDeniedException();
        }
        this.adService.submitForAuthorization(basicAdVO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canCreateNew(boolean bl, User user) {
        if (!this.isLoggedIn()) return false;
        if (!this.permission((BasicUser)user).my(new Permission[]{bl ? Permission.MY_ADS_MANAGE : Permission.MY_WEB_SHOP_MANAGE}).user(new Permission[]{bl ? Permission.USER_ADS_MANAGE : Permission.USER_WEB_SHOP_MANAGE}).granted()) return false;
        return true;
    }

    protected void checkApproveOrReject(BasicAdVO basicAdVO) {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        Permission permission = basicAd instanceof Advertisement ? Permission.USER_PENDING_ADS_MANAGE : Permission.USER_PENDING_WEB_SHOP_MANAGE;
        this.permission((BasicUser)basicAd.getOwner()).user(new Permission[]{permission}).check();
    }

    @Override
    protected void checkCreateNew(AdDataParams adDataParams) {
        User user;
        boolean bl = adDataParams.getType() == AdType.ADVERTISEMENT;
        if (!this.canCreateNew(bl, user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)adDataParams.getUser()))) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected void customizeData(AdDetailsData adDetailsData) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)((BasicAdDTO)adDetailsData.getDto()).getOwner());
        if (user == null || !this.canViewAddresses(user)) {
            adDetailsData.setCanSetAddress(false);
            adDetailsData.setAddresses(null);
        }
        adDetailsData.setQuestionsEnabled(user != null && this.adQuestionService.isQuestionsEnabled(adDetailsData.getDto() instanceof AdvertisementDTO ? AdType.ADVERTISEMENT : AdType.WEB_SHOP, user));
    }

    protected AdServiceLocal getImplementation() {
        return this.adService;
    }

    private Pair<Boolean, Boolean> canView(boolean bl) {
        SessionData sessionData = this.getSessionData();
        boolean bl2 = false;
        boolean bl3 = false;
        if (sessionData.isGuest()) {
            ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
            bl2 = configurationAccessor.isAllowViewUserAd();
            bl3 = configurationAccessor.isAllowViewUserWebShop();
        } else {
            bl2 = bl ? sessionData.hasPermission(Permission.MY_ADS_ENABLE) : sessionData.hasPermission(Permission.USER_ADS_VIEW);
            bl3 = bl ? sessionData.hasPermission(Permission.MY_WEB_SHOP_ENABLE) : sessionData.hasPermission(Permission.USER_WEB_SHOP_VIEW);
        }
        return Pair.create((Object)bl2, (Object)bl3);
    }

    private void checkFavoriteAds(User user) {
        SessionData sessionData = this.getSessionData();
        if (user == null || this.getLoggedUser().equals((Object)user)) {
            if (!sessionData.hasPermission(Permission.MY_FAVORITE_ADS_ENABLE)) {
                throw new PermissionDeniedException();
            }
        } else {
            this.checkManagesUser((BasicUser)user);
            this.permission((BasicUser)user).my(new Permission[]{Permission.MY_FAVORITE_ADS_ENABLE}).user(new Permission[]{Permission.USER_FAVORITE_ADS_VIEW}).check();
        }
    }

    private boolean checkQuery(BasicAdQuery basicAdQuery) {
        User user;
        Object object;
        Calendar calendar;
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        boolean bl = sessionData.isGuest();
        TimeIntervalDTO timeIntervalDTO = basicAdQuery.getPublishedSince();
        if (timeIntervalDTO != null) {
            calendar = Calendar.getInstance();
            calendar.set(1, 1900);
            if (DateHelper.subtract((Date)new Date(), (ITimeInterval)timeIntervalDTO).before(calendar.getTime())) {
                throw new ValidationException(BasicAdQuery.PUBLISHED_SINCE.getName(), this.message(GeneralKeys.Errors.INVALID, this.message(MarketplaceKeys.Advertisements.PUBLISHED_SINCE, new Object[0])));
            }
        }
        if (bl) {
            basicAdQuery.setGroups(null);
            if (configurationAccessor.isHideAdOwnerToGuests()) {
                basicAdQuery.setOwner(null);
            }
            if (configurationAccessor.isHideAdPriceToGuests()) {
                basicAdQuery.setPriceRange(null);
                basicAdQuery.setCurrency(null);
            }
        }
        calendar = (User)this.conversionHandler.convert(User.class, (Object)basicAdQuery.getOwner());
        boolean bl2 = !bl && sessionData.getLoggedUser().equals((Object)calendar);
        Pair<Boolean, Boolean> pair = this.canView(bl2);
        boolean bl3 = (Boolean)pair.getFirst();
        boolean bl4 = (Boolean)pair.getSecond();
        if (!bl3 && !bl4) {
            throw new PermissionDeniedException();
        }
        if (bl3 ^ bl4) {
            Object object2 = object = bl3 ? AdType.ADVERTISEMENT : AdType.WEB_SHOP;
            if (basicAdQuery.getType() == null) {
                basicAdQuery.setType((AdType)object);
            } else if (basicAdQuery.getType() != object) {
                return false;
            }
        }
        object = this.conversionHandler.convertSet(User.class, (Iterable)basicAdQuery.getBrokers());
        boolean bl5 = false;
        if (sessionData.isBroker()) {
            if (calendar != null && sessionData.isBrokerOf((BasicUser)calendar)) {
                bl5 = true;
            } else if (!object.isEmpty()) {
                if (object.size() > 1 || !sessionData.getLoggedUser().equals(CollectionHelper.first((Iterable)object))) {
                    throw new PermissionDeniedException();
                }
                bl5 = true;
            }
        } else if (!object.isEmpty()) {
            if (sessionData.isAdmin()) {
                object.forEach(basicUser -> this.checkManagesUser((BasicUser)basicUser));
            } else {
                throw new PermissionDeniedException();
            }
        }
        this.adService.checkStatus(bl, bl2, basicAdQuery, (User)calendar);
        List list = this.adCustomFieldService.listVisible((User)calendar, sessionData.isAdmin() || bl5);
        Set set = basicAdQuery.getAdCustomValues();
        if (CollectionHelper.isNotEmpty((Iterable)set)) {
            for (CustomFieldValueForSearchDTO customFieldValueForSearchDTO : set) {
                AdCustomField adCustomField = (AdCustomField)this.conversionHandler.convert(AdCustomField.class, (Object)customFieldValueForSearchDTO.getField());
                if (list.contains(adCustomField)) continue;
                throw new PermissionDeniedException();
            }
        }
        this.groupsHandler.visibles().ads().basicUsers().check((Collection)basicAdQuery.getGroups());
        if (!configurationAccessor.isUseMap()) {
            basicAdQuery.setDistance(null);
        }
        if (basicAdQuery.getFavoritesFor() != null) {
            user = (User)this.conversionHandler.convert(User.class, (Object)basicAdQuery.getFavoritesFor());
            this.checkFavoriteAds(user);
        }
        if (basicAdQuery.getCategory() != null) {
            user = (AdCategory)this.conversionHandler.convert(AdCategory.class, (Object)basicAdQuery.getCategory());
            if (!this.adCategoryServiceLocal.listVisible(sessionData.getLoggedUser()).stream().anyMatch(arg_0 -> AdServiceSecurity.lambda$checkQuery$1((AdCategory)user, arg_0))) {
                return false;
            }
        }
        return true;
    }

    private void checkView(AdType adType, boolean bl) {
        Pair<Boolean, Boolean> pair = this.canView(bl);
        boolean bl2 = false;
        if (adType == null) {
            bl2 = (Boolean)pair.getFirst() != false || (Boolean)pair.getSecond() != false;
        } else if (adType == AdType.ADVERTISEMENT) {
            bl2 = (Boolean)pair.getFirst();
        } else if (adType == AdType.WEB_SHOP) {
            bl2 = (Boolean)pair.getSecond();
        }
        if (!bl2) {
            throw new PermissionDeniedException();
        }
    }

    private static /* synthetic */ boolean lambda$checkQuery$1(AdCategory adCategory, AdCategoryDetailedVO adCategoryDetailedVO) {
        return adCategory.getId().equals(adCategoryDetailedVO.getId());
    }
}

