/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.marketplace;

import org.cyclos.entities.marketplace.AdInterest;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.marketplace.AdInterestServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.marketplace.interests.AdInterestDTO;
import org.cyclos.model.marketplace.interests.AdInterestData;
import org.cyclos.model.marketplace.interests.UserAdInterestsListData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.marketplace.AdInterestService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AdInterestServiceSecurity
extends CRUDServiceSecurity<AdInterestDTO, AdInterest, AdInterestData, UserLocatorVO>
implements AdInterestService {
    @Autowired
    private AdInterestServiceLocal adInterestService;

    public AdInterestServiceSecurity() {
        super(AdInterest.class);
    }

    @Override
    public boolean doHasManageAccess(AdInterest adInterest) {
        return this.permission((BasicUser)adInterest.getOwner()).my(new Permission[]{Permission.MY_AD_INTERESTS_ENABLE}).user(new Permission[]{Permission.USER_AD_INTERESTS_MANAGE}).granted();
    }

    @Override
    public boolean doHasViewAccess(AdInterest adInterest) {
        return this.permission((BasicUser)adInterest.getOwner()).my(new Permission[]{Permission.MY_AD_INTERESTS_ENABLE}).user(new Permission[]{Permission.USER_AD_INTERESTS_VIEW}).granted();
    }

    public UserAdInterestsListData getListData(UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkLoggedIn();
        SessionData sessionData = this.getSessionData();
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_AD_INTERESTS_ENABLE}).user(new Permission[]{Permission.USER_AD_INTERESTS_VIEW}).check();
        UserAdInterestsListData userAdInterestsListData = this.adInterestService.getListData(userLocatorVO);
        userAdInterestsListData.setManage(user.equals((Object)sessionData.getLoggedUser()) || sessionData.hasPermission(Permission.USER_AD_INTERESTS_MANAGE));
        return userAdInterestsListData;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, AdInterest adInterest) {
        return false;
    }

    @Override
    protected void checkCreateNew(UserLocatorVO userLocatorVO) {
        this.checkLoggedIn();
        this.permission((BasicUser)this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO)).my(new Permission[]{Permission.MY_AD_INTERESTS_ENABLE}).user(new Permission[]{Permission.USER_AD_INTERESTS_MANAGE}).check();
    }

    protected AdInterestServiceLocal getImplementation() {
        return this.adInterestService;
    }
}

