/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.marketplace;

import org.cyclos.entities.marketplace.AdAddress;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.marketplace.AdAddressServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.marketplace.addresses.AdAddressDTO;
import org.cyclos.model.marketplace.addresses.AdAddressData;
import org.cyclos.model.marketplace.addresses.AdAddressDataParams;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.users.addresses.AddressListData;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.marketplace.AdServiceSecurity;
import org.cyclos.services.marketplace.AdAddressService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AdAddressServiceSecurity
extends CRUDServiceSecurity<AdAddressDTO, AdAddress, AdAddressData, AdAddressDataParams>
implements AdAddressService {
    @Autowired
    private AdAddressServiceLocal addressService;
    @Autowired
    private AdServiceSecurity adServiceSecurity;

    public AdAddressServiceSecurity() {
        super(AdAddress.class);
    }

    @Override
    public boolean doHasViewAccess(AdAddress adAddress) {
        BasicAd basicAd = adAddress.getAd();
        if (!this.adServiceSecurity.hasViewAccess(basicAd)) {
            return false;
        }
        return this.getSessionData().relatesTo((BasicUser)basicAd.getOwner());
    }

    public AddressListData getAddressListData(BasicAdVO basicAdVO) throws FrameworkException {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        this.adServiceSecurity.checkViewAccess(basicAd);
        return this.addressService.getAddressListData(basicAdVO);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, AdAddress adAddress) {
        return false;
    }

    @Override
    protected void checkCreateNew(AdAddressDataParams adAddressDataParams) {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)adAddressDataParams.getAd());
        this.adServiceSecurity.checkManageAccess(basicAd);
    }

    @Override
    protected boolean doHasManageAccess(AdAddress adAddress) {
        return this.adServiceSecurity.hasManageAccess(adAddress.getAd());
    }

    @Override
    protected CRUDServiceLocal<AdAddress, AdAddressDTO, AdAddressData, AdAddressDataParams> getImplementation() {
        return this.addressService;
    }
}

