/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import java.util.List;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.system.Configuration;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.ThemeServiceLocal;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FileParsingException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.contentmanagement.themes.ApplyThemesDTO;
import org.cyclos.model.contentmanagement.themes.ThemeDTO;
import org.cyclos.model.contentmanagement.themes.ThemeData;
import org.cyclos.model.contentmanagement.themes.ThemeDataParams;
import org.cyclos.model.contentmanagement.themes.ThemeType;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.model.contentmanagement.themes.ThemesListData;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.ConfigurationServiceSecurity;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.contentmanagement.ThemeService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ThemeServiceSecurity
extends CRUDServiceSecurity<ThemeDTO, Theme, ThemeData, ThemeDataParams>
implements ThemeService {
    @Autowired
    private ThemeServiceLocal themeService;
    @Autowired
    private ConfigurationServiceSecurity configurationServiceSecurity;

    public ThemeServiceSecurity() {
        super(Theme.class);
    }

    public void applyThemes(ApplyThemesDTO applyThemesDTO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)applyThemesDTO.getConfiguration());
        this.configurationServiceSecurity.checkManageContent(configuration);
        this.themeService.applyThemes(applyThemesDTO);
    }

    @Override
    public boolean doHasManageAccess(Theme theme) {
        if (this.themeService.isBuiltin(theme)) {
            return false;
        }
        return this.configurationServiceSecurity.hasManageContent(theme.getConfiguration());
    }

    @Override
    public boolean doHasViewAccess(Theme theme) {
        return this.configurationServiceSecurity.isVisibleForManageContent(theme.getConfiguration());
    }

    public FileInfo export(Long l) {
        this.checkViewAccess((Theme)this.find(l));
        return this.themeService.export(l);
    }

    public String getCSS(Long l) {
        return this.themeService.getCSS(l);
    }

    public String getFallbackCSS(ThemeType themeType) {
        return this.themeService.getFallbackCSS(themeType);
    }

    public ThemesListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        ThemesListData themesListData = this.themeService.getListData(configurationVO);
        themesListData.setEditable(this.configurationServiceSecurity.hasManageContent(configuration));
        return themesListData;
    }

    public ThemeVO getTheme(ThemeType themeType) throws FrameworkException {
        return this.themeService.getTheme(themeType);
    }

    public ThemeVO getVO(Long l) throws EntityNotFoundException {
        return this.themeService.getVO(l);
    }

    public Long importNew(ConfigurationVO configurationVO, String string, SerializableInputStream serializableInputStream) throws FileParsingException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkManageContent(configuration);
        return this.themeService.importNew(configurationVO, string, serializableInputStream);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, Theme theme) {
        return true;
    }

    public List<ThemeVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        return this.themeService.list(configurationVO);
    }

    @Override
    protected void checkCreateNew(ThemeDataParams themeDataParams) {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)themeDataParams.getConfiguration());
        this.configurationServiceSecurity.checkManageContent(configuration);
        Long l = themeDataParams.getBasedOnId();
        if (l != null) {
            this.checkViewAccess((Theme)this.find(l));
        }
    }

    protected ThemeServiceLocal getImplementation() {
        return this.themeService;
    }
}

