/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import java.util.List;
import java.util.Set;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.contentmanagement.ThemeImage;
import org.cyclos.impl.contentmanagement.ThemeImageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.contentmanagement.themes.NewThemeImageParams;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.contentmanagement.themes.ThemeImageVO;
import org.cyclos.security.Security;
import org.cyclos.security.contentmanagement.ThemeServiceSecurity;
import org.cyclos.security.system.BaseImageServiceSecurity;
import org.cyclos.services.contentmanagement.ThemeImageService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ThemeImageServiceSecurity
extends BaseImageServiceSecurity<ThemeImage, NewThemeImageParams>
implements ThemeImageService {
    @Autowired
    private ThemeImageServiceLocal themeImageService;
    @Autowired
    private ThemeServiceSecurity themeServiceSecurity;

    public ThemeImageServiceSecurity() {
        super(ThemeImage.class);
    }

    public ThemeImageVO getImageVO(Long l, ThemeImageType themeImageType, String string) throws FrameworkException {
        return this.themeImageService.getImageVO(l, themeImageType, string);
    }

    public ThemeImageServiceLocal getImplementation() {
        return this.themeImageService;
    }

    @Override
    public boolean hasManageAccess(ThemeImage themeImage) {
        return this.themeServiceSecurity.doHasManageAccess(themeImage.getTheme());
    }

    public List<ThemeImageVO> list(Long l, Set<ThemeImageType> set) throws FrameworkException {
        return this.themeImageService.list(l, set);
    }

    @Override
    protected void checkCreateNew(NewThemeImageParams newThemeImageParams) {
        Theme theme = this.find(Theme.class, newThemeImageParams.getThemeId());
        this.themeServiceSecurity.checkManageAccess(theme);
    }
}

