/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import java.util.List;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.contentmanagement.DataTranslationServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.contentmanagement.translations.DataTranslationDTO;
import org.cyclos.model.contentmanagement.translations.DataTranslationData;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.contentmanagement.translations.DataTranslationTypeData;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.contentmanagement.TranslationMessageServiceSecurity;
import org.cyclos.services.contentmanagement.DataTranslationService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class DataTranslationServiceSecurity
extends BaseServiceSecurity
implements DataTranslationService {
    @Autowired
    private TranslationMessageServiceSecurity translationMessageServiceSecurity;
    @Autowired
    private DataTranslationServiceLocal dataTranslationService;

    public DataTranslationData getData(LanguageVO languageVO, DataTranslationType dataTranslationType) throws FrameworkException {
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageVO);
        this.translationMessageServiceSecurity.checkView(language);
        return this.dataTranslationService.getData(languageVO, dataTranslationType);
    }

    public DataTranslationTypeData getTypeData(LanguageVO languageVO) throws FrameworkException {
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageVO);
        this.translationMessageServiceSecurity.checkView(language);
        return this.dataTranslationService.getTypeData(languageVO);
    }

    public void translate(LanguageVO languageVO, List<DataTranslationDTO> list) throws FrameworkException {
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageVO);
        this.translationMessageServiceSecurity.checkManage(language);
        this.dataTranslationService.translate(languageVO, list);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

