/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import java.util.List;
import org.cyclos.entities.contentmanagement.Banner;
import org.cyclos.entities.system.Configuration;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.BannerServiceLocal;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.contentmanagement.contentitems.BannerDTO;
import org.cyclos.model.contentmanagement.contentitems.BannerData;
import org.cyclos.model.contentmanagement.contentitems.BannerDataParams;
import org.cyclos.model.contentmanagement.contentitems.BannerVO;
import org.cyclos.model.contentmanagement.contentitems.BannersListData;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.ConfigurationServiceSecurity;
import org.cyclos.services.contentmanagement.BannerService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class BannerServiceSecurity
extends CRUDServiceSecurity<BannerDTO, Banner, BannerData, BannerDataParams>
implements BannerService {
    @Autowired
    private BannerServiceLocal bannerService;
    @Autowired
    private ConfigurationServiceSecurity configurationServiceSecurity;

    public BannerServiceSecurity() {
        super(Banner.class);
    }

    @Override
    public boolean doHasManageAccess(Banner banner) {
        return this.configurationServiceSecurity.hasManageContent(banner.getConfiguration());
    }

    @Override
    public boolean doHasViewAccess(Banner banner) {
        return this.configurationServiceSecurity.isVisibleForManageContent(banner.getConfiguration());
    }

    public BannersListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        BannersListData bannersListData = this.bannerService.getListData(configurationVO);
        bannersListData.setEditable(this.configurationServiceSecurity.hasManageContent(configuration));
        return bannersListData;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, Banner banner) {
        if (this.getConfiguration().getConfiguration().equals((Object)banner.getConfiguration())) {
            return banner.getVisibility().isVisible(this.isLoggedIn());
        }
        return false;
    }

    public List<BannerVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        return this.bannerService.list(configurationVO);
    }

    public void move(Long l, boolean bl) throws EntityNotFoundException {
        Banner banner = (Banner)this.find(l);
        this.checkManageAccess(banner);
        this.bannerService.move(l, bl);
    }

    @Override
    protected void checkCreateNew(BannerDataParams bannerDataParams) {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)bannerDataParams.getConfiguration());
        this.configurationServiceSecurity.checkManageContent(configuration);
    }

    protected BannerServiceLocal getImplementation() {
        return this.bannerService;
    }
}

