/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanPath;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.banking.VoucherTransaction;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.QProductAdminVoucher;
import org.cyclos.entities.users.QProductBrokerVoucher;
import org.cyclos.entities.users.QProductVoucher;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.banking.VoucherTransactionsVisibility;
import org.cyclos.impl.system.ImportServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.CaptchaResponseDTO;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationStatus;
import org.cyclos.model.banking.vouchers.ActivateGiftVoucherDTO;
import org.cyclos.model.banking.vouchers.AssignVoucherDTO;
import org.cyclos.model.banking.vouchers.BasicVoucherQuery;
import org.cyclos.model.banking.vouchers.BuyVoucherData;
import org.cyclos.model.banking.vouchers.BuyVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.BuyVouchersDTO;
import org.cyclos.model.banking.vouchers.CancelVoucherDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherExpirationDateDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.CreateVoucherDataParams;
import org.cyclos.model.banking.vouchers.GeneralVoucherQuery;
import org.cyclos.model.banking.vouchers.GeneralVouchersSearchData;
import org.cyclos.model.banking.vouchers.GenerateVouchersDTO;
import org.cyclos.model.banking.vouchers.GenerateVouchersData;
import org.cyclos.model.banking.vouchers.InitialVoucherUserData;
import org.cyclos.model.banking.vouchers.MaxTotalOpenAmountException;
import org.cyclos.model.banking.vouchers.RedeemVoucherDTO;
import org.cyclos.model.banking.vouchers.RedeemVoucherData;
import org.cyclos.model.banking.vouchers.RedeemVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.SendVoucherDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.TopUpVoucherDTO;
import org.cyclos.model.banking.vouchers.TopUpVoucherData;
import org.cyclos.model.banking.vouchers.TopUpVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.UnblockVoucherParams;
import org.cyclos.model.banking.vouchers.UserVoucherQuery;
import org.cyclos.model.banking.vouchers.UserVouchersSearchData;
import org.cyclos.model.banking.vouchers.VoucherBarcodeParams;
import org.cyclos.model.banking.vouchers.VoucherBuyingException;
import org.cyclos.model.banking.vouchers.VoucherData;
import org.cyclos.model.banking.vouchers.VoucherInfoData;
import org.cyclos.model.banking.vouchers.VoucherInfoTransactionsQuery;
import org.cyclos.model.banking.vouchers.VoucherInfoVO;
import org.cyclos.model.banking.vouchers.VoucherPackWithIdsVO;
import org.cyclos.model.banking.vouchers.VoucherRedeemingException;
import org.cyclos.model.banking.vouchers.VoucherStatus;
import org.cyclos.model.banking.vouchers.VoucherTopUpException;
import org.cyclos.model.banking.vouchers.VoucherTransactionData;
import org.cyclos.model.banking.vouchers.VoucherTransactionDataParams;
import org.cyclos.model.banking.vouchers.VoucherTransactionResultVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionsQuery;
import org.cyclos.model.banking.vouchers.VoucherTransactionsSearchData;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.banking.vouchers.VouchersSummaryVO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.security.banking.VoucherConfigurationServiceSecurity;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.banking.VoucherService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class VoucherServiceSecurity
extends BaseServiceSecurity
implements VoucherService {
    @Autowired
    private VoucherServiceLocal voucherService;
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;
    @Autowired
    private VoucherConfigurationServiceSecurity voucherConfigurationServiceSecurity;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private ImportServiceLocal importService;

    public VoucherInfoVO activateGiftVoucher(@NotNull String string, ActivateGiftVoucherDTO activateGiftVoucherDTO) throws FrameworkException {
        return this.voucherService.activateGiftVoucher(string, activateGiftVoucherDTO);
    }

    public void assign(@NotNull AssignVoucherDTO assignVoucherDTO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)assignVoucherDTO.getVoucher());
        this.checkGenerate(voucher.getType());
        this.voucherService.assign(assignVoucherDTO);
    }

    public SerializableInputStream barcode(VoucherBarcodeParams voucherBarcodeParams) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)voucherBarcodeParams.getVoucher());
        if (!voucher.getConfiguration().isShowQrCode() || this.shouldMaskToken(voucher)) {
            throw new PermissionDeniedException();
        }
        return this.voucherService.barcode(voucherBarcodeParams);
    }

    public VoucherPackWithIdsVO buy(BuyVouchersDTO buyVouchersDTO) throws FrameworkException {
        User user = this.checkBuy(buyVouchersDTO.getUser(), buyVouchersDTO.getType());
        buyVouchersDTO.setUser(new UserLocatorVO(user.getId()));
        return this.voucherService.buy(buyVouchersDTO);
    }

    public void cancel(CancelVoucherDTO cancelVoucherDTO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)cancelVoucherDTO.getVoucher());
        Set<VoucherConfiguration> set = this.configurationsAllowingCancel(voucher.getPack().getBuy());
        PermissionHelper.checkContains(set, (Object)voucher.getConfiguration());
        this.voucherService.cancel(cancelVoucherDTO);
    }

    public void changeExpirationDate(ChangeVoucherExpirationDateDTO changeVoucherExpirationDateDTO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)changeVoucherExpirationDateDTO.getVoucher());
        if (!this.hasPermissionToChangeExpirationDate(voucher)) {
            throw new PermissionDeniedException();
        }
        this.voucherService.changeExpirationDate(changeVoucherExpirationDateDTO);
    }

    public void changeInfoNotificationSettings(String string, String string2, SimpleChangeVoucherNotificationSettingsDTO simpleChangeVoucherNotificationSettingsDTO) throws FrameworkException {
        this.voucherService.changeInfoNotificationSettings(string, string2, simpleChangeVoucherNotificationSettingsDTO);
    }

    public void changeInfoPin(@NotNull String string, SimpleChangeVoucherPinDTO simpleChangeVoucherPinDTO) throws FrameworkException {
        this.voucherService.changeInfoPin(string, simpleChangeVoucherPinDTO);
    }

    public void changeNotificationSettings(@NotNull ChangeVoucherNotificationSettingsDTO changeVoucherNotificationSettingsDTO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)changeVoucherNotificationSettingsDTO.getVoucher());
        if (!this.hasPermissionForNotificationSettings(voucher)) {
            throw new PermissionDeniedException();
        }
        this.voucherService.changeNotificationSettings(changeVoucherNotificationSettingsDTO);
    }

    public void changePin(ChangeVoucherPinDTO changeVoucherPinDTO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)changeVoucherPinDTO.getVoucher());
        if (!this.hasPermissionForChangePin(voucher)) {
            throw new PermissionDeniedException();
        }
        this.voucherService.changePin(changeVoucherPinDTO);
    }

    public FileInfo exportTransaction(@NotNull ExportFormatVO exportFormatVO, @NotNull VoucherTransactionVO voucherTransactionVO) throws FrameworkException {
        this.checkVO(VoucherTransaction.class, (EntityVO)voucherTransactionVO);
        return this.voucherService.exportTransaction(exportFormatVO, voucherTransactionVO);
    }

    public FileInfo exportVoucher(@NotNull ExportFormatVO exportFormatVO, @NotNull VoucherVO voucherVO, boolean bl) throws FrameworkException {
        return this.voucherService.exportVoucher(exportFormatVO, voucherVO, bl);
    }

    public FileInfo exportVouchers(@NotNull ExportFormatVO exportFormatVO, @NotNull BasicVoucherQuery basicVoucherQuery, boolean bl) throws FrameworkException {
        this.checkQuery(basicVoucherQuery);
        return this.voucherService.exportVouchers(exportFormatVO, basicVoucherQuery, this.getSessionData().isAdmin() ? bl : false);
    }

    public List<VouchersSummaryVO> generalSearchSummary(GeneralVoucherQuery generalVoucherQuery) throws FrameworkException {
        this.checkQuery((BasicVoucherQuery)generalVoucherQuery);
        return this.voucherService.generalSearchSummary(generalVoucherQuery);
    }

    public VoucherPackWithIdsVO generate(GenerateVouchersDTO generateVouchersDTO) throws FrameworkException {
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)generateVouchersDTO.getType());
        this.checkGenerate(voucherType);
        return this.voucherService.generate(generateVouchersDTO);
    }

    public BuyVoucherData getBuyData(CreateVoucherDataParams createVoucherDataParams) throws FrameworkException {
        User user = this.checkBuy(createVoucherDataParams.getUser(), createVoucherDataParams.getType());
        createVoucherDataParams.setUser(new UserLocatorVO(user.getId()));
        return this.voucherService.getBuyData(createVoucherDataParams);
    }

    public VoucherData getData(Long l) throws FrameworkException {
        Object object;
        Voucher voucher = this.find(Voucher.class, l);
        if (!this.isVisible(voucher)) {
            throw new EntityNotFoundException(Voucher.class, l);
        }
        VoucherData voucherData = this.voucherService.getData(l);
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return voucherData;
        }
        VoucherPack voucherPack = voucher.getPack();
        if (voucherData.getBuy() != null && !this.transactionServiceSecurity.isAccessible((Transaction)voucherPack.getBuy())) {
            voucherData.setBuy(null);
        }
        if (voucherData.getSingleRedeem() != null && !this.transactionServiceSecurity.isAccessible((Transaction)(object = (Payment)this.invokerHandler.runAs(SessionDataFactory.system(), () -> (Payment)this.conversionHandler.convert(Payment.class, (Object)voucherData.getSingleRedeem().getTransaction()))))) {
            voucherData.getSingleRedeem().setTransaction(null);
        }
        if (voucherData.getRefund() != null && !this.transactionServiceSecurity.isAccessible((Transaction)voucher.getRefund())) {
            voucherData.setRefund(null);
        }
        if (voucherData.getCancelAction() != null && !(object = this.configurationsAllowingCancel(voucherPack.getBuy())).contains(voucher.getConfiguration())) {
            voucherData.setCancelAction(null);
        }
        voucherData.setCanAssign(voucherData.isCanAssign() && this.voucherConfigurationServiceSecurity.canGenerateVouchers(voucher.getConfiguration()));
        voucherData.setCanChangeExpirationDate(voucherData.isCanChangeExpirationDate() && this.hasPermissionToChangeExpirationDate(voucher));
        if (voucherData.isCanResendEmail()) {
            object = voucher.getPack().getBuyer();
            voucherData.setCanResendEmail(voucher.isOpen() && this.permission((BasicUser)object).my(new Permission[0]).user(new Permission[]{Permission.USER_VOUCHERS_VIEW_VOUCHERS}).granted());
        }
        voucherData.setCanUnblockPin(voucherData.isCanUnblockPin() && this.canUnblockPin(voucher));
        voucherData.setCanChangeNotificationSettings(voucherData.isCanChangeNotificationSettings() && this.hasPermissionForNotificationSettings(voucher));
        if (!voucherData.isCanChangeNotificationSettings()) {
            voucherData.setPhoneConfiguration(null);
        }
        voucherData.setCanChangePin(voucherData.isCanChangePin() && this.hasPermissionForChangePin(voucher));
        return voucherData;
    }

    public GeneralVouchersSearchData getGeneralSearchData() throws FrameworkException {
        this.checkPermission(Permission.VOUCHERS_VIEW);
        GeneralVouchersSearchData generalVouchersSearchData = this.voucherService.getGeneralSearchData();
        generalVouchersSearchData.setCanGenerate(this.hasPermission(Permission.VOUCHERS_GENERATE));
        return generalVouchersSearchData;
    }

    public GenerateVouchersData getGenerateData(CreateVoucherDataParams createVoucherDataParams) throws FrameworkException {
        if (createVoucherDataParams.getType() != null) {
            VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)createVoucherDataParams.getType());
            this.checkGenerate(voucherType);
        } else {
            this.checkPermission(Permission.VOUCHERS_GENERATE);
        }
        return this.voucherService.getGenerateData(createVoucherDataParams);
    }

    public VoucherInfoVO getInfo(@NotNull String string, String string2) throws FrameworkException {
        return this.voucherService.getInfo(string, string2);
    }

    public VoucherInfoData getInfoData() throws FrameworkException {
        return this.voucherService.getInfoData();
    }

    public RedeemVoucherData getRedeemData(VoucherTransactionDataParams voucherTransactionDataParams) throws FrameworkException {
        this.checkRedeem(voucherTransactionDataParams);
        return this.voucherService.getRedeemData(voucherTransactionDataParams);
    }

    public InitialVoucherUserData getRedeemInitialData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.checkRedeem(userLocatorVO);
        return this.voucherService.getRedeemInitialData(new UserLocatorVO(user.getId()));
    }

    public BuyVoucherData getSendData(CreateVoucherDataParams createVoucherDataParams) throws FrameworkException {
        User user = this.checkSend(createVoucherDataParams.getUser(), createVoucherDataParams.getType());
        createVoucherDataParams.setUser(new UserLocatorVO(user.getId()));
        return this.voucherService.getSendData(createVoucherDataParams);
    }

    public TopUpVoucherData getTopUpData(@NotNull VoucherTransactionDataParams voucherTransactionDataParams) throws FrameworkException, VoucherTopUpException {
        this.checkTopUp(voucherTransactionDataParams);
        return this.voucherService.getTopUpData(voucherTransactionDataParams);
    }

    public InitialVoucherUserData getTopUpInitialData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.checkTopUp(userLocatorVO);
        return this.voucherService.getTopUpInitialData(new UserLocatorVO(user.getId()));
    }

    public VoucherTransactionData getTransactionData(Long l) throws FrameworkException {
        VoucherTransaction voucherTransaction;
        VoucherTransactionData voucherTransactionData = this.voucherService.getTransactionData(l);
        VoucherTransaction voucherTransaction2 = (VoucherTransaction)this.conversionHandler.convert(VoucherTransaction.class, (Object)voucherTransactionData.getChargebackOf());
        if (voucherTransaction2 != null && !this.isVisible(voucherTransaction2)) {
            voucherTransactionData.setChargebackOf(null);
        }
        if ((voucherTransaction = (VoucherTransaction)this.conversionHandler.convert(VoucherTransaction.class, (Object)voucherTransactionData.getChargedBackBy())) != null && !this.isVisible(voucherTransaction)) {
            voucherTransactionData.setChargedBackBy(null);
        }
        return voucherTransactionData;
    }

    public VoucherTransactionsVisibility getTransactionVisibility(Voucher voucher) {
        SessionData sessionData;
        block8: {
            block7: {
                sessionData = this.getSessionData();
                if (sessionData.isSystem() || sessionData.isAdmin()) break block7;
                if (!sessionData.isBroker()) break block8;
                if (!this.usersFor(voucher).stream().anyMatch(arg_0 -> ((SessionData)sessionData).isBrokerOf(arg_0))) break block8;
            }
            return VoucherTransactionsVisibility.FULL;
        }
        VoucherPack voucherPack = voucher.getPack();
        if (sessionData.isLoggedIn()) {
            if (sessionData.getLoggedUser().equals((Object)voucherPack.getBuyer())) {
                if (voucherPack.isSent()) {
                    return VoucherTransactionsVisibility.NONE;
                }
                if (Boolean.TRUE.equals(voucherPack.getGift())) {
                    return this.voucherService.usePin(voucher) ? VoucherTransactionsVisibility.NONE : VoucherTransactionsVisibility.PARTIAL;
                }
            }
            return VoucherTransactionsVisibility.FULL;
        }
        return Boolean.TRUE.equals(voucherPack.getGift()) && !this.voucherService.usePin(voucher) ? VoucherTransactionsVisibility.PARTIAL : VoucherTransactionsVisibility.FULL;
    }

    public VoucherTransactionsSearchData getUserTransactionsSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_VOUCHERS_VIEW_TRANSACTIONS}).user(new Permission[]{Permission.USER_VOUCHERS_VIEW_TRANSACTIONS}).check();
        VoucherTransactionsSearchData voucherTransactionsSearchData = this.voucherService.getUserTransactionsSearchData(userLocatorVO);
        voucherTransactionsSearchData.setCanRedeem(this.canRedeem(user));
        voucherTransactionsSearchData.setCanTopUp(this.canTopUp(user));
        return voucherTransactionsSearchData;
    }

    public UserVouchersSearchData getUserVouchersSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_VOUCHERS_VIEW_VOUCHERS}).user(new Permission[]{Permission.USER_VOUCHERS_VIEW_VOUCHERS}).check();
        UserVouchersSearchData userVouchersSearchData = this.voucherService.getUserVouchersSearchData(userLocatorVO);
        userVouchersSearchData.setCanBuy(this.canBuy(user));
        boolean bl = this.canSend(user);
        userVouchersSearchData.setCanSend(bl);
        userVouchersSearchData.setCanSendImport(bl && this.importService.importsWithPermission(user).contains(ImportType.USER_SEND_VOUCHERS_IMPORT));
        return userVouchersSearchData;
    }

    public boolean isOnlyOwnTransactions() {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isRestrictedOperator()) {
            Operator operator = sessionData.getLoggedOperator();
            OperatorGroup operatorGroup = operator.getGroup();
            return operatorGroup.isVoucherTransactions();
        }
        return false;
    }

    public boolean isVisible(Voucher voucher) {
        if (this.hasPermission(Permission.VOUCHERS_VIEW) || voucher.getOwner() != null && this.permission((BasicUser)voucher.getOwner()).my(new Permission[]{Permission.MY_VOUCHERS_VIEW_VOUCHERS}).user(new Permission[]{Permission.USER_VOUCHERS_VIEW_VOUCHERS}).granted()) {
            return true;
        }
        VoucherPack voucherPack = voucher.getPack();
        if (voucherPack.getBuyer() != null && this.permission((BasicUser)voucherPack.getBuyer()).my(new Permission[]{Permission.MY_VOUCHERS_VIEW_VOUCHERS}).user(new Permission[]{Permission.USER_VOUCHERS_VIEW_VOUCHERS}).granted()) {
            return true;
        }
        if (this.isLegacyRedeemedVoucherVisibleToRedeemer(voucher)) {
            VoucherTransaction voucherTransaction = (VoucherTransaction)CollectionHelper.first((Iterable)voucher.getTransactions());
            return this.permission((BasicUser)voucherTransaction.getUser()).my(new Permission[]{Permission.MY_VOUCHERS_VIEW_TRANSACTIONS}).user(new Permission[]{Permission.USER_VOUCHERS_VIEW_TRANSACTIONS}).granted();
        }
        return false;
    }

    public boolean isVisible(VoucherPack voucherPack) {
        if (this.hasPermission(Permission.VOUCHERS_VIEW)) {
            return true;
        }
        return CollectionHelper.asStream((Iterator)this.voucherService.iterateVouchers(voucherPack)).anyMatch(this::isVisible);
    }

    public boolean isVisible(VoucherVO voucherVO) {
        try {
            Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)voucherVO);
            return this.isVisible(voucher);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return false;
        }
    }

    public VoucherVO loadByToken(String string) throws FrameworkException {
        VoucherVO voucherVO = this.voucherService.loadByToken(string);
        if (!this.isVisible(voucherVO)) {
            throw new EntityNotFoundException();
        }
        return voucherVO;
    }

    public BuyVoucherPreviewVO previewBuy(@NotNull BuyVouchersDTO buyVouchersDTO) throws FrameworkException, VoucherBuyingException, MaxTotalOpenAmountException, TransferException {
        User user = this.checkBuy(buyVouchersDTO.getUser(), buyVouchersDTO.getType());
        buyVouchersDTO.setUser(new UserLocatorVO(user.getId()));
        return this.voucherService.previewBuy(buyVouchersDTO);
    }

    public RedeemVoucherPreviewVO previewRedeem(@NotNull RedeemVoucherDTO redeemVoucherDTO) throws FrameworkException, VoucherRedeemingException {
        this.checkRedeem((VoucherTransactionDataParams)redeemVoucherDTO);
        return this.voucherService.previewRedeem(redeemVoucherDTO);
    }

    public BuyVoucherPreviewVO previewSend(@NotNull SendVoucherDTO sendVoucherDTO) throws FrameworkException, VoucherBuyingException, MaxTotalOpenAmountException, TransferException {
        User user = this.checkSend(sendVoucherDTO.getUser(), sendVoucherDTO.getType());
        sendVoucherDTO.setUser(new UserLocatorVO(user.getId()));
        return this.voucherService.previewSend(sendVoucherDTO);
    }

    public TopUpVoucherPreviewVO previewTopUp(@NotNull TopUpVoucherDTO topUpVoucherDTO) throws FrameworkException, VoucherTopUpException {
        this.checkTopUp((VoucherTransactionDataParams)topUpVoucherDTO);
        return this.voucherService.previewTopUp(topUpVoucherDTO);
    }

    public VoucherTransactionResultVO redeem(RedeemVoucherDTO redeemVoucherDTO) throws FrameworkException {
        this.checkRedeem((VoucherTransactionDataParams)redeemVoucherDTO);
        return this.voucherService.redeem(redeemVoucherDTO);
    }

    public void resendEmail(@NotNull VoucherVO voucherVO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)voucherVO);
        if (!voucher.getPack().isSent() || !voucher.isOpen()) {
            throw new PermissionDeniedException();
        }
        User user = voucher.getPack().getBuyer();
        this.permission((BasicUser)user).my(new Permission[0]).user(new Permission[]{Permission.USER_VOUCHERS_VIEW_VOUCHERS}).check();
        this.voucherService.resendEmail(voucherVO);
    }

    public List<String> resendPin(@NotNull String string, CaptchaResponseDTO captchaResponseDTO) throws FrameworkException {
        return this.voucherService.resendPin(string, captchaResponseDTO);
    }

    public List<String> resendPinForRedeem(@NotNull String string, UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.checkRedeem(userLocatorVO);
        userLocatorVO = new UserLocatorVO(user.getId());
        VoucherTransactionDataParams voucherTransactionDataParams = new VoucherTransactionDataParams();
        voucherTransactionDataParams.setUser(userLocatorVO);
        voucherTransactionDataParams.setToken(string);
        this.checkRedeem(voucherTransactionDataParams);
        return this.voucherService.resendPinForRedeem(string, userLocatorVO);
    }

    public Page<VoucherVO> searchGeneral(GeneralVoucherQuery generalVoucherQuery) throws FrameworkException {
        this.checkQuery((BasicVoucherQuery)generalVoucherQuery);
        return this.voucherService.searchGeneral(generalVoucherQuery);
    }

    public Page<VoucherTransactionVO> searchInfoTransactions(@NotNull VoucherInfoTransactionsQuery voucherInfoTransactionsQuery, String string) throws FrameworkException {
        PermissionHelper.checkNotNull((Object)voucherInfoTransactionsQuery.getToken());
        return this.voucherService.searchInfoTransactions(voucherInfoTransactionsQuery, string);
    }

    public Page<VoucherTransactionResultVO> searchTransactions(@NotNull VoucherTransactionsQuery voucherTransactionsQuery) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)voucherTransactionsQuery.getUser());
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)voucherTransactionsQuery.getVoucher());
        SessionData sessionData = this.getSessionData();
        if (voucher == null) {
            this.permission((BasicUser)user).my(new Permission[]{Permission.MY_VOUCHERS_VIEW_TRANSACTIONS}).user(new Permission[]{Permission.USER_VOUCHERS_VIEW_TRANSACTIONS}).check();
            if (this.isOnlyOwnTransactions()) {
                voucherTransactionsQuery.setBy((BasicUserVO)new UserLocatorVO(sessionData.getLoggedBasicUser().getId()));
            }
        } else if (!this.isVisible(voucher) || this.getTransactionVisibility(voucher) == VoucherTransactionsVisibility.NONE) {
            throw new PermissionDeniedException();
        }
        return this.voucherService.searchTransactions(voucherTransactionsQuery);
    }

    public Page<VoucherVO> searchUser(@NotNull UserVoucherQuery userVoucherQuery) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userVoucherQuery.getUser());
        this.permission((BasicUser)user).my(new Permission[]{Permission.MY_VOUCHERS_VIEW_VOUCHERS}).user(new Permission[]{Permission.USER_VOUCHERS_VIEW_VOUCHERS}).check();
        return this.voucherService.searchUser(userVoucherQuery);
    }

    public VoucherPackWithIdsVO send(@NotNull SendVoucherDTO sendVoucherDTO) throws FrameworkException, VoucherBuyingException, MaxTotalOpenAmountException, TransferException {
        User user = this.checkSend(sendVoucherDTO.getUser(), sendVoucherDTO.getType());
        sendVoucherDTO.setUser(new UserLocatorVO(user.getId()));
        return this.voucherService.send(sendVoucherDTO);
    }

    public boolean shouldMaskToken(Voucher voucher) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem() || voucher.getStatus().isFinal()) {
            return false;
        }
        if (!this.isVisible(voucher)) {
            return true;
        }
        VoucherPack voucherPack = voucher.getPack();
        if (voucherPack.isSent()) {
            return !sessionData.isManagerOf((BasicUser)voucherPack.getBuyer()) && !sessionData.manages((BasicUser)voucher.getOwner());
        }
        return !sessionData.manages((BasicUser)voucher.getOwner()) && !sessionData.manages((BasicUser)voucherPack.getBuyer()) && (!sessionData.isAdmin() || !voucherPack.isGenerated());
    }

    public VoucherTransactionResultVO topUp(@NotNull TopUpVoucherDTO topUpVoucherDTO) throws FrameworkException, TransferException {
        this.checkTopUp((VoucherTransactionDataParams)topUpVoucherDTO);
        return this.voucherService.topUp(topUpVoucherDTO);
    }

    public void unblock(@NotNull UnblockVoucherParams unblockVoucherParams) throws FrameworkException, VoucherTopUpException {
        this.voucherService.unblock(unblockVoucherParams);
    }

    public void unblockPin(@NotNull VoucherVO voucherVO) throws FrameworkException {
        Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)voucherVO);
        if (!this.canUnblockPin(voucher)) {
            throw new PermissionDeniedException();
        }
        this.voucherService.unblockPin(voucherVO);
    }

    @Override
    protected void doInitialize() {
        this.getEntityCheckRegistry().register((EntityCheck)new BaseEntityCheck<Voucher>(Voucher.class){

            public boolean isVisible(SessionData sessionData, Voucher voucher) {
                return VoucherServiceSecurity.this.isAccessible(voucher);
            }
        });
        this.getEntityCheckRegistry().register((EntityCheck)new BaseEntityCheck<VoucherTransaction>(VoucherTransaction.class){

            public boolean isVisible(SessionData sessionData, VoucherTransaction voucherTransaction) {
                return VoucherServiceSecurity.this.isVisible(voucherTransaction);
            }
        });
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private boolean canBuy(User user) {
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_VOUCHERS_BUY}).user(new Permission[]{Permission.USER_VOUCHERS_BUY}).granted();
    }

    private boolean canRedeem(User user) {
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_VOUCHERS_REDEEM}).user(new Permission[]{Permission.USER_VOUCHERS_REDEEM}).granted();
    }

    private boolean canSend(User user) {
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_VOUCHERS_SEND}).user(new Permission[]{Permission.USER_VOUCHERS_SEND}).granted();
    }

    private boolean canTopUp(User user) {
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_VOUCHERS_TOP_UP}).user(new Permission[]{Permission.USER_VOUCHERS_TOP_UP}).granted();
    }

    private boolean canUnblockPin(Voucher voucher) {
        if (!voucher.isPinBlocked()) {
            return false;
        }
        SessionData sessionData = this.getSessionData();
        if (voucher.getPack().isGenerated()) {
            BooleanProperties booleanProperties = sessionData.getProducts().admin().getVouchers().get((Object)voucher.getConfiguration());
            return booleanProperties.isSet((Path)QProductAdminVoucher.productAdminVoucher.generate);
        }
        return sessionData.manages((BasicUser)voucher.getPack().getBuyer()) || sessionData.manages((BasicUser)voucher.getOwner());
    }

    private User checkBuy(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        if (!this.canBuy(user)) {
            throw new PermissionDeniedException();
        }
        return user;
    }

    private User checkBuy(UserLocatorVO userLocatorVO, VoucherTypeVO voucherTypeVO) {
        User user = this.checkBuy(userLocatorVO);
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)voucherTypeVO);
        if (voucherType != null) {
            Set<VoucherConfiguration> set = this.configurationsAllowing(user, QProductVoucher.productVoucher.buy);
            PermissionHelper.checkContains(set, (Object)voucherType.getConfiguration());
        }
        return user;
    }

    private void checkGenerate(VoucherType voucherType) {
        if (!this.voucherConfigurationServiceSecurity.canGenerateVouchers(voucherType.getConfiguration())) {
            throw new PermissionDeniedException();
        }
    }

    private void checkQuery(BasicVoucherQuery basicVoucherQuery) {
        Set set;
        Object object;
        SessionData sessionData = this.getSessionData();
        if (sessionData.isAdmin() ? !sessionData.hasPermission(Permission.VOUCHERS_VIEW) : (sessionData.isMemberOnly() ? !sessionData.hasPermission(Permission.MY_VOUCHERS_VIEW_VOUCHERS) : (sessionData.isBroker() ? basicVoucherQuery instanceof GeneralVoucherQuery || (((User)this.conversionHandler.convert(User.class, (Object)((UserVoucherQuery)basicVoucherQuery).getUser())).equals((Object)this.getLoggedUser()) ? !sessionData.hasPermission(Permission.MY_VOUCHERS_VIEW_VOUCHERS) : !sessionData.hasPermission(Permission.USER_VOUCHERS_VIEW_VOUCHERS)) : sessionData.isOperator()))) {
            throw new PermissionDeniedException();
        }
        if (basicVoucherQuery instanceof GeneralVoucherQuery) {
            User user;
            object = (GeneralVoucherQuery)basicVoucherQuery;
            User user2 = (User)this.conversionHandler.convert(User.class, (Object)object.getBuyer());
            if (user2 != null) {
                this.checkManagesUser((BasicUser)user2);
            }
            if ((user = (User)this.conversionHandler.convert(User.class, (Object)object.getTransactionUser())) != null) {
                this.checkManagesUser((BasicUser)user);
            }
            User user3 = (User)ObjectHelper.coalesce((Object[])new User[]{user2, user});
            boolean bl = user != null;
            boolean bl2 = user2 != null;
            HashSet hashSet = new HashSet(this.voucherConfigurationService.listVisible(user3, bl, bl2));
            set = PermissionHelper.applyAllowed((Collection)this.conversionHandler.convertSet(VoucherConfiguration.class, (Iterable)object.getConfigurations()), hashSet);
            object.setConfigurations(this.conversionHandler.convertSet(VoucherConfigurationVO.class, set));
            Set set2 = this.groupsHandler.visibles().accessibles().users().items();
            PermissionHelper.applyAllowed((Collection)this.groupsHandler.flattenVOs((Collection)object.getBuyerGroups()), (Collection)set2);
            PermissionHelper.applyAllowed((Collection)this.groupsHandler.flattenVOs((Collection)object.getTransactionUserGroups()), (Collection)set2);
        } else {
            set = new HashSet(this.voucherConfigurationService.listVisible(this.getLoggedUser(), false, true));
        }
        object = this.conversionHandler.convertSet(VoucherType.class, (Iterable)basicVoucherQuery.getTypes());
        object.removeIf(voucherType -> !set.contains(voucherType.getConfiguration()));
        basicVoucherQuery.setTypes(this.conversionHandler.convertSet(VoucherTypeVO.class, (Iterable)object));
    }

    private User checkRedeem(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        if (!this.canRedeem(user)) {
            throw new PermissionDeniedException();
        }
        return user;
    }

    private void checkRedeem(VoucherTransactionDataParams voucherTransactionDataParams) {
        User user = this.checkRedeem(voucherTransactionDataParams.getUser());
        voucherTransactionDataParams.setUser(new UserLocatorVO(user.getId()));
        this.checkTransaction(voucherTransactionDataParams, user, QProductVoucher.productVoucher.redeem);
    }

    private User checkSend(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        if (!this.canSend(user)) {
            throw new PermissionDeniedException();
        }
        return user;
    }

    private User checkSend(UserLocatorVO userLocatorVO, VoucherTypeVO voucherTypeVO) {
        User user = this.checkSend(userLocatorVO);
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)voucherTypeVO);
        if (voucherType != null) {
            Set<VoucherConfiguration> set = this.configurationsAllowing(user, QProductVoucher.productVoucher.send);
            PermissionHelper.checkContains(set, (Object)voucherType.getConfiguration());
        }
        return user;
    }

    private User checkTopUp(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        if (!this.canTopUp(user)) {
            throw new PermissionDeniedException();
        }
        return user;
    }

    private void checkTopUp(VoucherTransactionDataParams voucherTransactionDataParams) {
        User user = this.checkTopUp(voucherTransactionDataParams.getUser());
        voucherTransactionDataParams.setUser(new UserLocatorVO(user.getId()));
        this.checkTransaction(voucherTransactionDataParams, user, QProductVoucher.productVoucher.topUp);
    }

    private void checkTransaction(VoucherTransactionDataParams voucherTransactionDataParams, User user, BooleanPath booleanPath) {
        if (StringHelper.isNotBlank((Object)voucherTransactionDataParams.getToken())) {
            try {
                Voucher voucher = this.voucherService.findByToken(voucherTransactionDataParams.getToken(), (Collection)this.voucherConfigurationService.listVisible(user, true, false));
                Set<VoucherConfiguration> set = this.configurationsAllowing(user, booleanPath);
                PermissionHelper.checkContains(set, (Object)voucher.getConfiguration());
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
    }

    private Set<VoucherConfiguration> configurationsAllowing(User user, BooleanPath booleanPath) {
        return this.voucherConfigurationService.resolveVoucherConfigurationPermissions(user).keysSet((Path)booleanPath);
    }

    private Set<VoucherConfiguration> configurationsAllowingCancel(Payment payment) {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (payment != null) {
            User user = payment.getFromUser();
            if (!sessionData.manages((BasicUser)user)) {
                return Collections.emptySet();
            }
            if (payment.isPendingAuthorization()) {
                return productsAccessor.admin().getVouchers().keysSet((Path)QProductAdminVoucher.productAdminVoucher.cancel);
            }
            if (user.equals((Object)sessionData.getLoggedUser())) {
                return productsAccessor.member().getVouchers().keysSet((Path)QProductVoucher.productVoucher.refund);
            }
            if (sessionData.isAdmin()) {
                return productsAccessor.admin().getVouchers().keysSet((Path)QProductAdminVoucher.productAdminVoucher.refund);
            }
            return productsAccessor.broker().getUserVouchers().keysSet((Path)QProductBrokerVoucher.productBrokerVoucher.refund);
        }
        return productsAccessor.admin().getVouchers().keysSet((Path)QProductAdminVoucher.productAdminVoucher.cancel);
    }

    private boolean hasPermissionForChangePin(Voucher voucher) {
        return this.hasPermissionOrIsOwner(voucher, QProductVoucher.productVoucher.changePin);
    }

    private boolean hasPermissionForNotificationSettings(Voucher voucher) {
        return this.hasPermissionOrIsOwner(voucher, QProductVoucher.productVoucher.notificationSettings);
    }

    private boolean hasPermissionOrIsOwner(Voucher voucher, BooleanPath booleanPath) {
        if (voucher == null) {
            throw new EntityNotFoundException(Voucher.class);
        }
        SessionData sessionData = this.getSessionData();
        User user = voucher.getOwner();
        if (user != null && !sessionData.manages((BasicUser)user)) {
            return false;
        }
        Set<VoucherConfiguration> set = sessionData.isAdmin() ? sessionData.getProducts().admin().getVouchers().keysSet((Path)booleanPath) : (sessionData.isBroker() ? sessionData.getProducts().broker().getUserVouchers().keysSet((Path)booleanPath) : (user != null && sessionData.isMember() && sessionData.getLoggedBasicUser().equals((Object)user) ? Collections.singleton(voucher.getConfiguration()) : Collections.emptySet()));
        return set.contains(voucher.getConfiguration());
    }

    private boolean hasPermissionToChangeExpirationDate(Voucher voucher) {
        Set set = this.getProducts().admin().getVouchers().keysSet((Path)QProductAdminVoucher.productAdminVoucher.changeExpirationDate);
        return set.contains(voucher.getConfiguration());
    }

    private boolean isAccessible(Voucher voucher) {
        ProductsAccessor productsAccessor;
        if (this.isVisible(voucher)) {
            return true;
        }
        Payment payment = voucher.getPack().getBuy();
        if (payment != null && this.transactionServiceSecurity.isAccessible((Transaction)payment)) {
            return true;
        }
        BooleanPath booleanPath = QProductVoucher.productVoucher.redeem;
        BooleanPath booleanPath2 = QProductVoucher.productVoucher.topUp;
        VoucherConfiguration voucherConfiguration = voucher.getConfiguration();
        Predicate<BooleanPropertiesHolder> predicate = booleanPropertiesHolder -> booleanPropertiesHolder.isSet((Object)voucherConfiguration, (Path)booleanPath) || booleanPropertiesHolder.isSet((Object)voucherConfiguration, (Path)booleanPath2);
        return predicate.test((productsAccessor = this.getSessionData().getProducts()).admin().getVouchers()) || predicate.test(productsAccessor.broker().getUserVouchers()) || predicate.test(productsAccessor.member().getVouchers());
    }

    private boolean isLegacyRedeemedVoucherVisibleToRedeemer(Voucher voucher) {
        return StringHelper.isBlank((Object)voucher.getPin()) && voucher.getConfiguration().getGenerationStatus() == VoucherGenerationStatus.ACTIVE && !voucher.getType().isAllowPartialRedeems() && voucher.getStatus() == VoucherStatus.REDEEMED;
    }

    private boolean isVisible(VoucherTransaction voucherTransaction) {
        if (this.isVisible(voucherTransaction.getVoucher())) {
            return true;
        }
        if (this.permission((BasicUser)voucherTransaction.getUser()).my(new Permission[]{Permission.MY_VOUCHERS_VIEW_TRANSACTIONS}).user(new Permission[]{Permission.USER_VOUCHERS_VIEW_TRANSACTIONS}).granted()) {
            if (this.isOnlyOwnTransactions()) {
                return this.getSessionData().getLoggedBasicUser().equals((Object)voucherTransaction.getBy());
            }
            return true;
        }
        return false;
    }

    private Set<User> usersFor(Voucher voucher) {
        HashSet<User> hashSet = new HashSet<User>();
        if (voucher.getOwner() != null) {
            hashSet.add(voucher.getOwner());
        } else if (voucher.getPack().isBought()) {
            hashSet.add(voucher.getPack().getBuyer());
        } else if (voucher.getActivation() != null && voucher.getActivation().getUser() != null) {
            hashSet.add(voucher.getActivation().getUser());
        }
        return hashSet;
    }
}

