/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import com.querydsl.core.types.Path;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.users.QProductAdminVoucher;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationDTO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationData;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationDetailedVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationListData;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleConfigurationEntityCRUDServiceSecurity;
import org.cyclos.services.banking.VoucherConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class VoucherConfigurationServiceSecurity
extends SimpleConfigurationEntityCRUDServiceSecurity<VoucherConfigurationDTO, VoucherConfiguration, VoucherConfigurationData, CurrencyVO>
implements VoucherConfigurationService {
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;

    public VoucherConfigurationServiceSecurity() {
        super(VoucherConfiguration.class, Permission.ACCOUNT_CONFIGURATION_VIEW, Permission.ACCOUNT_CONFIGURATION_MANAGE);
    }

    public boolean canGenerateVouchers(VoucherConfiguration voucherConfiguration) {
        BooleanPropertiesHolder booleanPropertiesHolder = this.getSessionData().getProducts().admin().getVouchers();
        Set set = booleanPropertiesHolder.keysSet((Path)QProductAdminVoucher.productAdminVoucher.generate);
        return set.contains(voucherConfiguration);
    }

    public VoucherConfigurationListData getListData() throws FrameworkException {
        this.checkViewPermission();
        return this.voucherConfigurationService.getListData();
    }

    public List<VoucherConfigurationDetailedVO> list() throws FrameworkException {
        this.checkViewPermission();
        return this.voucherConfigurationService.list();
    }

    @Override
    protected CRUDServiceLocal<VoucherConfiguration, VoucherConfigurationDTO, VoucherConfigurationData, CurrencyVO> getImplementation() {
        return this.voucherConfigurationService;
    }
}

