/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.List;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.TransferStatusServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.transferstatus.ChangeTransferStatusDTO;
import org.cyclos.model.banking.transferstatus.TransferStatusDTO;
import org.cyclos.model.banking.transferstatus.TransferStatusData;
import org.cyclos.model.banking.transferstatus.TransferStatusDetailedVO;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowVO;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleConfigurationEntityCRUDServiceSecurity;
import org.cyclos.services.banking.TransferStatusService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TransferStatusServiceSecurity
extends SimpleConfigurationEntityCRUDServiceSecurity<TransferStatusDTO, TransferStatus, TransferStatusData, TransferStatusFlowVO>
implements TransferStatusService {
    @Autowired
    private TransferStatusServiceLocal transferStatusService;
    @Autowired
    private AccountServiceLocal accountService;

    public TransferStatusServiceSecurity() {
        super(TransferStatus.class, Permission.ACCOUNT_CONFIGURATION_VIEW, Permission.ACCOUNT_CONFIGURATION_MANAGE);
    }

    public void changeStatus(ChangeTransferStatusDTO changeTransferStatusDTO) throws FrameworkException {
        TransferStatusFlow transferStatusFlow;
        Transfer transfer = (Transfer)this.conversionHandler.convert(Transfer.class, (Object)changeTransferStatusDTO.getTransfer());
        TransferStatus transferStatus = (TransferStatus)this.conversionHandler.convert(TransferStatus.class, (Object)changeTransferStatusDTO.getNewStatus());
        TransferStatusFlow transferStatusFlow2 = transferStatusFlow = transferStatus == null ? null : transferStatus.getFlow();
        if (transferStatusFlow != null && !this.accountService.getManagedFlows(transfer.getFrom()).contains(transferStatusFlow) && !this.accountService.getManagedFlows(transfer.getTo()).contains(transferStatusFlow)) {
            throw new PermissionDeniedException();
        }
        this.transferStatusService.changeStatus(changeTransferStatusDTO);
    }

    public List<TransferStatusDetailedVO> list(TransferStatusFlowVO transferStatusFlowVO) throws FrameworkException {
        this.checkViewPermission();
        return this.transferStatusService.list(transferStatusFlowVO);
    }

    @Override
    protected CRUDServiceLocal<TransferStatus, TransferStatusDTO, TransferStatusData, TransferStatusFlowVO> getImplementation() {
        return this.transferStatusService;
    }
}

