/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.Collection;
import java.util.List;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentRequestServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestDTO;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestPreviewVO;
import org.cyclos.model.banking.transactions.ChangePaymentRequestExpirationDateDTO;
import org.cyclos.model.banking.transactions.PaymentRequestActionDTO;
import org.cyclos.model.banking.transactions.PaymentRequestData;
import org.cyclos.model.banking.transactions.PaymentRequestVO;
import org.cyclos.model.banking.transactions.RequestPaymentData;
import org.cyclos.model.banking.transactions.RequestPaymentPayerData;
import org.cyclos.model.banking.transactions.RequestPaymentTypeData;
import org.cyclos.model.banking.transactions.SendPaymentRequestDTO;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.services.banking.PaymentRequestService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class PaymentRequestServiceSecurity
extends BaseServiceSecurity
implements PaymentRequestService {
    @Autowired
    private PaymentRequestServiceLocal paymentRequestService;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;

    public PaymentRequestVO accept(AcceptPaymentRequestDTO acceptPaymentRequestDTO) throws FrameworkException {
        this.checkAcceptOrDeny((PaymentRequestActionDTO)acceptPaymentRequestDTO);
        return this.paymentRequestService.accept(acceptPaymentRequestDTO);
    }

    public void cancel(PaymentRequestActionDTO paymentRequestActionDTO) throws FrameworkException {
        PaymentRequest paymentRequest = (PaymentRequest)this.conversionHandler.convert(PaymentRequest.class, (Object)paymentRequestActionDTO.getPaymentRequest());
        if (!this.canCancel(paymentRequest)) {
            throw new PermissionDeniedException();
        }
        this.paymentRequestService.cancel(paymentRequestActionDTO);
    }

    public void changeExpirationDate(ChangePaymentRequestExpirationDateDTO changePaymentRequestExpirationDateDTO) throws FrameworkException {
        PaymentRequest paymentRequest = (PaymentRequest)this.conversionHandler.convert(PaymentRequest.class, (Object)changePaymentRequestExpirationDateDTO.getPaymentRequest());
        if (!this.canChangeExpirationDate(paymentRequest)) {
            throw new PermissionDeniedException();
        }
        this.paymentRequestService.changeExpirationDate(changePaymentRequestExpirationDateDTO);
    }

    public void deny(PaymentRequestActionDTO paymentRequestActionDTO) throws FrameworkException {
        this.checkAcceptOrDeny(paymentRequestActionDTO);
        this.paymentRequestService.deny(paymentRequestActionDTO);
    }

    public PaymentRequestData getData(Long l) throws FrameworkException {
        PaymentRequest paymentRequest = this.find(PaymentRequest.class, l);
        PaymentRequestData paymentRequestData = this.paymentRequestService.getData(l);
        return this.postProcess(paymentRequest, paymentRequestData);
    }

    public RequestPaymentData getRequestData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, TransferTypeVO transferTypeVO) throws FrameworkException {
        this.check(internalAccountOwner, internalAccountOwner2, (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO));
        return this.paymentRequestService.getRequestData(internalAccountOwner, internalAccountOwner2, transferTypeVO);
    }

    public RequestPaymentPayerData getRequestPaymentPayerData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2) throws FrameworkException {
        this.check(internalAccountOwner, internalAccountOwner2, null);
        return this.paymentRequestService.getRequestPaymentPayerData(internalAccountOwner, internalAccountOwner2);
    }

    public RequestPaymentTypeData getRequestPaymentTypeData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, TransferTypeVO transferTypeVO) throws FrameworkException {
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        this.check(internalAccountOwner, internalAccountOwner2, paymentTransferType);
        return this.paymentRequestService.getRequestPaymentTypeData(internalAccountOwner, internalAccountOwner2, transferTypeVO);
    }

    public boolean isAccessible(PaymentRequest paymentRequest) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isLoggedIn() && sessionData.getLoggedBasicUser().equals((Object)paymentRequest.getBy())) {
            return true;
        }
        boolean bl = this.transactionServiceSecurity.isAccessible(paymentRequest.getFromOwner(), TransactionNature.PAYMENT_REQUEST) || this.transactionServiceSecurity.isAccessible(paymentRequest.getToOwner(), TransactionNature.PAYMENT_REQUEST);
        return bl && (this.accountServiceSecurity.hasAccess(paymentRequest.getFrom()) || this.accountServiceSecurity.hasAccess(paymentRequest.getTo()));
    }

    public PaymentRequestData postProcess(PaymentRequest paymentRequest, PaymentRequestData paymentRequestData) {
        boolean bl = this.canAcceptOrDeny(paymentRequest);
        paymentRequestData.setCanAccept(paymentRequestData.isCanAccept() && bl);
        paymentRequestData.setCanDeny(paymentRequestData.isCanDeny() && bl);
        paymentRequestData.setCanReschedule(paymentRequestData.isCanReschedule() && bl);
        paymentRequestData.setCanCancel(paymentRequestData.isCanCancel() && this.canCancel(paymentRequest));
        paymentRequestData.setCanChangeExpirationDate(paymentRequestData.isCanChangeExpirationDate() && this.canChangeExpirationDate(paymentRequest));
        return this.transactionServiceSecurity.postProcessTransactionData((Transaction)paymentRequest, paymentRequestData);
    }

    public AcceptPaymentRequestPreviewVO previewAccept(PaymentRequestVO paymentRequestVO) throws FrameworkException {
        PaymentRequest paymentRequest = (PaymentRequest)this.conversionHandler.convert(PaymentRequest.class, (Object)paymentRequestVO);
        if (!this.canAcceptOrDeny(paymentRequest)) {
            throw new PermissionDeniedException();
        }
        return this.paymentRequestService.previewAccept(paymentRequestVO);
    }

    public PaymentRequestVO reschedule(AcceptPaymentRequestDTO acceptPaymentRequestDTO) throws FrameworkException {
        this.checkAcceptOrDeny((PaymentRequestActionDTO)acceptPaymentRequestDTO);
        return this.paymentRequestService.reschedule(acceptPaymentRequestDTO);
    }

    public PaymentRequestVO send(SendPaymentRequestDTO sendPaymentRequestDTO) throws FrameworkException {
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)sendPaymentRequestDTO.getType());
        InternalAccountOwner internalAccountOwner = sendPaymentRequestDTO.getOwner();
        internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner).getInternalAccountOwner();
        sendPaymentRequestDTO.setOwner(internalAccountOwner);
        this.check(internalAccountOwner, sendPaymentRequestDTO.getSubject(), paymentTransferType);
        return this.paymentRequestService.send(sendPaymentRequestDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private boolean canAcceptOrDeny(PaymentRequest paymentRequest) {
        if (paymentRequest.isFromSystem()) {
            if (!this.getProducts().admin().getSystemAccounts().contains(paymentRequest.getType().getFrom())) {
                return false;
            }
            return this.hasPermission(Permission.SYSTEM_PAYMENT_REQUESTS_ACCEPT);
        }
        User user = paymentRequest.getFromUser();
        boolean bl = user.equals((Object)this.getLoggedUser());
        if (!bl && !this.getProducts().userManagement().getUserAccountsAccess().contains(paymentRequest.getType().getFrom())) {
            return false;
        }
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_PAYMENT_REQUESTS_ACCEPT}).user(new Permission[]{Permission.USER_PAYMENT_REQUESTS_ACCEPT}).granted();
    }

    private boolean canCancel(PaymentRequest paymentRequest) {
        return this.isGrantedAsPayee(Permission.MY_PAYMENT_REQUESTS_CANCEL, Permission.USER_PAYMENT_REQUESTS_CANCEL, Permission.SYSTEM_PAYMENT_REQUESTS_CANCEL, paymentRequest);
    }

    private boolean canChangeExpirationDate(PaymentRequest paymentRequest) {
        return this.isGrantedAsPayee(Permission.MY_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE, Permission.USER_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE, Permission.SYSTEM_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE, paymentRequest);
    }

    private void check(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, PaymentTransferType paymentTransferType) {
        LocateAccountOwnerResult locateAccountOwnerResult;
        if (paymentTransferType != null && !(paymentTransferType instanceof PaymentTransferType)) {
            throw new ValidationException();
        }
        PaymentTransferType paymentTransferType2 = paymentTransferType;
        if (internalAccountOwner == null) {
            internalAccountOwner = this.accountHandler.getAccountOwner();
        }
        if (internalAccountOwner2 != null && internalAccountOwner != null && internalAccountOwner2.equals((Object)internalAccountOwner)) {
            throw new PermissionDeniedException();
        }
        if (internalAccountOwner instanceof SystemAccountOwner) {
            this.permissionOptionalValue(Permission.SYSTEM_PAYMENT_REQUESTS_SEND_TO_USER).value((Object)paymentTransferType2).check();
        } else if (internalAccountOwner != null) {
            locateAccountOwnerResult = (User)this.conversionHandler.convert(User.class, (Object)internalAccountOwner);
            this.permissionOptionalValue((User)locateAccountOwnerResult).my(new Permission[]{internalAccountOwner2 instanceof SystemAccountOwner ? Permission.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM : Permission.MY_PAYMENT_REQUESTS_SEND_TO_USER}).user(new Permission[]{internalAccountOwner2 instanceof SystemAccountOwner ? Permission.USER_PAYMENT_REQUESTS_SEND_TO_SYSTEM : Permission.USER_PAYMENT_REQUESTS_SEND_TO_USER}).value((Object)paymentTransferType2).check();
        }
        locateAccountOwnerResult = this.transactionService.locateForPayment(internalAccountOwner2);
        if (locateAccountOwnerResult.isUser()) {
            User user = locateAccountOwnerResult.getUser();
            this.checkRelatesToUser((BasicUser)user);
            if (paymentTransferType != null) {
                List list = this.productsHandler.getAccessor((BasicUser)user).member().getReceivePaymentRequestTypes();
                PermissionHelper.checkContains((Collection)list, (Object)paymentTransferType);
            }
        }
    }

    private void checkAcceptOrDeny(PaymentRequestActionDTO paymentRequestActionDTO) {
        PaymentRequest paymentRequest = (PaymentRequest)this.conversionHandler.convert(PaymentRequest.class, (Object)paymentRequestActionDTO.getPaymentRequest());
        if (paymentRequest != null && !this.canAcceptOrDeny(paymentRequest)) {
            throw new PermissionDeniedException();
        }
    }

    private boolean isGrantedAsPayee(Permission permission, Permission permission2, Permission permission3, PaymentRequest paymentRequest) {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (paymentRequest.isToSystem()) {
            if (!productsAccessor.admin().getSystemAccounts().contains(paymentRequest.getType().getTo())) {
                return false;
            }
            return this.hasPermission(permission3);
        }
        User user = paymentRequest.getToUser();
        boolean bl = user.equals((Object)sessionData.getLoggedUser());
        if (!bl && !productsAccessor.userManagement().getUserAccountsAccess().contains(paymentRequest.getType().getTo())) {
            return false;
        }
        return this.permission((BasicUser)user).my(new Permission[]{permission}).user(new Permission[]{permission2}).granted();
    }
}

