/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.banking.ExternalPaymentServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.transactions.ExternalPaymentActionDTO;
import org.cyclos.model.banking.transactions.ExternalPaymentData;
import org.cyclos.model.banking.transactions.ExternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ExternalPaymentVO;
import org.cyclos.model.banking.transactions.PerformExternalPaymentDTO;
import org.cyclos.model.banking.transactions.PerformExternalPaymentData;
import org.cyclos.model.banking.transactions.PerformExternalPaymentTypeData;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.services.banking.ExternalPaymentService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ExternalPaymentServiceSecurity
extends BaseServiceSecurity
implements ExternalPaymentService {
    @Autowired
    private ExternalPaymentServiceLocal externalPaymentService;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;

    public void cancel(ExternalPaymentActionDTO externalPaymentActionDTO) {
        ExternalPayment externalPayment = (ExternalPayment)this.conversionHandler.convert(ExternalPayment.class, (Object)externalPaymentActionDTO.getExternalPayment());
        this.checkCancel(externalPayment);
        this.externalPaymentService.cancel(externalPaymentActionDTO);
    }

    public ExternalPaymentData getData(Long l) throws FrameworkException {
        ExternalPayment externalPayment = this.find(ExternalPayment.class, l);
        ExternalPaymentData externalPaymentData = this.externalPaymentService.getData(l);
        return this.postProcess(externalPayment, externalPaymentData);
    }

    public PerformExternalPaymentData getExternalPaymentData(InternalAccountOwner internalAccountOwner) {
        this.checkPerform(internalAccountOwner, null);
        return this.externalPaymentService.getExternalPaymentData(internalAccountOwner);
    }

    public PerformExternalPaymentTypeData getExternalPaymentTypeData(InternalAccountOwner internalAccountOwner, TransferTypeVO transferTypeVO) throws FrameworkException {
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)transferTypeVO);
        this.checkPerform(internalAccountOwner, transferType);
        return this.externalPaymentService.getExternalPaymentTypeData(internalAccountOwner, transferTypeVO);
    }

    public boolean isAccessible(ExternalPayment externalPayment) {
        boolean bl = this.transactionServiceSecurity.isAccessible(externalPayment.getFromOwner(), TransactionNature.EXTERNAL_PAYMENT);
        return bl && this.accountServiceSecurity.hasAccess(externalPayment.getFrom());
    }

    public ExternalPaymentVO perform(PerformExternalPaymentDTO performExternalPaymentDTO) throws FrameworkException {
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)performExternalPaymentDTO.getType());
        this.checkPerform(performExternalPaymentDTO.getOwner(), transferType);
        return this.externalPaymentService.perform(performExternalPaymentDTO);
    }

    public ExternalPaymentData postProcess(ExternalPayment externalPayment, ExternalPaymentData externalPaymentData) {
        InternalAccountOwner internalAccountOwner = this.accountHandler.locate((AccountOwner)externalPaymentData.getTransaction().getFrom().getOwner()).getInternalAccountOwner();
        externalPaymentData.setCanCancel(externalPaymentData.isCanCancel() && this.hasCancelPermission(internalAccountOwner));
        return this.transactionServiceSecurity.postProcessTransactionData((Transaction)externalPayment, externalPaymentData);
    }

    public ExternalPaymentPreviewVO preview(PerformExternalPaymentDTO performExternalPaymentDTO) throws FrameworkException {
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)performExternalPaymentDTO.getType());
        this.checkPerform(performExternalPaymentDTO.getOwner(), transferType);
        return this.externalPaymentService.preview(performExternalPaymentDTO);
    }

    protected void checkCancel(ExternalPayment externalPayment) {
        if (externalPayment != null && !this.hasCancelPermission(externalPayment.getFromOwner())) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void checkPerform(InternalAccountOwner internalAccountOwner, TransferType transferType) {
        if ((internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner).getInternalAccountOwner()) instanceof SystemAccountOwner) {
            this.permissionOptionalValue(Permission.SYSTEM_EXTERNAL_PAYMENTS_PAY_TO_USER).value((Object)transferType).check();
        } else if (internalAccountOwner instanceof User) {
            this.permissionOptionalValue((User)internalAccountOwner).my(new Permission[]{Permission.MY_EXTERNAL_PAYMENTS_PAY_TO_USER}).user(new Permission[]{Permission.USER_EXTERNAL_PAYMENTS_PAY_TO_USER}).value((Object)transferType).check();
        } else {
            throw new IllegalArgumentException();
        }
    }

    private boolean hasCancelPermission(InternalAccountOwner internalAccountOwner) {
        boolean bl = false;
        if (internalAccountOwner instanceof SystemAccountOwner) {
            bl = this.hasPermission(Permission.SYSTEM_EXTERNAL_PAYMENTS_CANCEL);
        } else if (internalAccountOwner instanceof User) {
            bl = this.permission((BasicUser)internalAccountOwner).my(new Permission[]{Permission.MY_EXTERNAL_PAYMENTS_CANCEL}).user(new Permission[]{Permission.USER_EXTERNAL_PAYMENTS_CANCEL}).granted();
        }
        return bl;
    }
}

