/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import javax.validation.constraints.NotNull;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.banking.EasyInvoiceServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.transactions.EasyInvoiceBarcodeParams;
import org.cyclos.model.banking.transactions.EasyInvoiceData;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentVO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceData;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceParams;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.PaymentServiceSecurity;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.banking.EasyInvoiceService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class EasyInvoiceServiceSecurity
extends BaseServiceSecurity
implements EasyInvoiceService {
    @Autowired
    private EasyInvoiceServiceLocal easyInvoiceService;
    @Autowired
    private PaymentServiceSecurity paymentServiceSecurity;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;

    public SerializableInputStream barcode(EasyInvoiceBarcodeParams easyInvoiceBarcodeParams) throws FrameworkException {
        return this.easyInvoiceService.barcode(easyInvoiceBarcodeParams);
    }

    public EasyInvoiceData getEasyInvoiceData(PerformPaymentDTO performPaymentDTO) throws FrameworkException {
        LocateAccountOwnerResult locateAccountOwnerResult = this.easyInvoiceService.locateReceiver(performPaymentDTO.getSubject());
        this.transactionServiceSecurity.check(this.accountHandler.locateOrCurrent(null), locateAccountOwnerResult);
        return this.easyInvoiceService.getEasyInvoiceData(performPaymentDTO);
    }

    public PaymentVO perform(@NotNull PerformPaymentDTO performPaymentDTO) throws TransferException, FrameworkException {
        return this.paymentServiceSecurity.perform(performPaymentDTO);
    }

    public PrepareEasyInvoiceData prepareEasyInvoice(PrepareEasyInvoiceParams prepareEasyInvoiceParams) throws FrameworkException {
        this.checkGuest();
        return this.easyInvoiceService.prepareEasyInvoice(prepareEasyInvoiceParams);
    }

    public PaymentPreviewVO preview(@NotNull PerformPaymentDTO performPaymentDTO) throws FrameworkException {
        return this.paymentServiceSecurity.preview(performPaymentDTO);
    }

    public void validate(@NotNull PerformPaymentDTO performPaymentDTO) throws FrameworkException {
        this.paymentServiceSecurity.validate(performPaymentDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

