/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountLocator;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.SystemAccount;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.impl.users.GroupListView;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.SetProperty;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.banking.accounts.AccountBalanceHistoryParams;
import org.cyclos.model.banking.accounts.AccountBalanceHistoryVO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitDTO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitVO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewData;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewStatusVO;
import org.cyclos.model.banking.accounts.AccountHistoryData;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryOverviewEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountLimitsOverviewData;
import org.cyclos.model.banking.accounts.AccountLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitDTO;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitVO;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountPermissionsData;
import org.cyclos.model.banking.accounts.AccountStatusVO;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.cyclos.model.banking.accounts.AccountWithHistoryStatusVO;
import org.cyclos.model.banking.accounts.AccountWithStatusVO;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryData;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryQuery;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryVO;
import org.cyclos.model.banking.accounts.ArchivedTransferData;
import org.cyclos.model.banking.accounts.BalanceLevel;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.UserAccountBalanceLimitData;
import org.cyclos.model.banking.accounts.UserAccountPaymentAmountLimitData;
import org.cyclos.model.banking.accounts.UserWithBalanceQuery;
import org.cyclos.model.banking.accounts.UserWithBalanceSearchData;
import org.cyclos.model.banking.accounts.UserWithBalanceVO;
import org.cyclos.model.banking.accounts.UsersWithBalancesOverview;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.rates.RateVisibility;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.users.AbstractUserQuery;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.AmountSummaryVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.users.UserServiceSecurity;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.services.banking.AccountService;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AccountServiceSecurity
extends BaseServiceSecurity
implements AccountService {
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private UserServiceSecurity userServiceSecurity;
    @Autowired
    private AccountTypeServiceLocal accountTypeService;

    public void checkAccessibleAccounts(InternalAccountOwner internalAccountOwner) {
        if (!this.accountTypeService.hasAccessible(internalAccountOwner)) {
            throw new PermissionDeniedException();
        }
    }

    public void checkTransQuery(AbstractTransQuery abstractTransQuery) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isAdmin()) {
            this.groupsHandler.visibles().accessibles().basicUsers().check((Collection)abstractTransQuery.getGroups());
        } else {
            PermissionHelper.checkEmpty((Collection)abstractTransQuery.getGroups());
            if (CollectionHelper.isNotEmpty((Iterable)abstractTransQuery.getBrokers())) {
                User user = (User)this.conversionHandler.convert(User.class, CollectionHelper.first((Iterable)abstractTransQuery.getBrokers()));
                if (!sessionData.isBroker() || abstractTransQuery.getBrokers().size() != 1 || !sessionData.getLoggedUser().equals((Object)user)) {
                    throw new PermissionDeniedException();
                }
            }
        }
    }

    public boolean doHasAccess(Account account, boolean bl) {
        return this.doHasAccess(account, bl, null);
    }

    public boolean doHasAccess(Account account, boolean bl, Collection<Long> collection) {
        if (account == null) {
            return false;
        }
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return true;
        }
        if (account instanceof SystemAccount) {
            return sessionData.getProducts().admin().getSystemAccounts().contains(account.getType());
        }
        UserAccount userAccount = (UserAccount)account;
        boolean bl2 = false;
        if (userAccount.getUser().equals((Object)sessionData.getLoggedUser())) {
            Object object;
            MemberProductAccessor memberProductAccessor = sessionData.getProducts().member(userAccount.getType());
            AccountAccessibility accountAccessibility = memberProductAccessor.getAccountAccessibility();
            switch ((AccountAccessibility)ObjectHelper.defaultValue((Object)accountAccessibility, (Object)AccountAccessibility.NEVER)) {
                case ALWAYS: {
                    bl2 = true;
                    break;
                }
                case NEVER: {
                    bl2 = false;
                    break;
                }
                case ONLY_IF_TRANSACTIONS: {
                    bl2 = collection == null ? this.accountService.hasTransfers(account) : collection.contains(account.getId());
                    break;
                }
                case CREDIT_LIMIT: {
                    object = this.accountService.getCreditLimit(account, null);
                    boolean bl3 = bl2 = !BigDecimalHelper.isZero((BigDecimal)object);
                }
            }
            if (bl2 && bl) {
                object = this.accountService.getVisibilitySettings(sessionData.getLoggedBasicUser());
                bl2 = this.accountService.isUserAccountVisibleBySettings(userAccount.getType(), memberProductAccessor, (Map)object);
            }
            if (bl2 && sessionData.isRestrictedOperator()) {
                bl2 = sessionData.getProducts().member(userAccount.getType()).getUserAccounts().contains(userAccount.getType());
            }
        } else {
            bl2 = this.permission((BasicUser)userAccount.getUser()).value((Object)account.getType()).user(new Permission[]{Permission.USER_ACCOUNTS_VIEW}).granted();
        }
        return bl2;
    }

    public FileInfo exportAccountBalanceLimitsOverview(@NotNull ExportFormatVO exportFormatVO, @NotNull AccountBalanceLimitsOverviewQuery accountBalanceLimitsOverviewQuery) throws FrameworkException {
        this.checkAccountLimitsOverviewQuery((AccountLimitsOverviewQuery)accountBalanceLimitsOverviewQuery);
        return this.accountService.exportAccountBalanceLimitsOverview(exportFormatVO, accountBalanceLimitsOverviewQuery);
    }

    public FileInfo exportAccountHistoriesOverview(@NotNull ExportFormatVO exportFormatVO, @NotNull AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) throws FrameworkException {
        this.checkAccountHistoriesOverviewQuery(accountHistoriesOverviewQuery);
        return this.accountService.exportAccountHistoriesOverview(exportFormatVO, accountHistoriesOverviewQuery);
    }

    public FileInfo exportAccountHistory(@NotNull ExportFormatVO exportFormatVO, @NotNull AccountHistoryQuery accountHistoryQuery) throws FrameworkException {
        this.checkAccountHistoryQuery(accountHistoryQuery);
        return this.accountService.exportAccountHistory(exportFormatVO, accountHistoryQuery);
    }

    public FileInfo exportAccountPaymentAmountLimitsOverview(@NotNull ExportFormatVO exportFormatVO, @NotNull AccountPaymentAmountLimitsOverviewQuery accountPaymentAmountLimitsOverviewQuery) throws FrameworkException {
        this.checkAccountLimitsOverviewQuery((AccountLimitsOverviewQuery)accountPaymentAmountLimitsOverviewQuery);
        return this.accountService.exportAccountPaymentAmountLimitsOverview(exportFormatVO, accountPaymentAmountLimitsOverviewQuery);
    }

    public FileInfo exportArchivedAccountHistory(@NotNull ExportFormatVO exportFormatVO, @NotNull ArchivedAccountHistoryQuery archivedAccountHistoryQuery) throws FrameworkException {
        this.checkViewHistory(archivedAccountHistoryQuery.getAccount());
        this.checkPermission(Permission.ARCHIVED_ACCOUNTS_VIEW);
        return this.accountService.exportArchivedAccountHistory(exportFormatVO, archivedAccountHistoryQuery);
    }

    public FileInfo exportArchivedTransfer(@NotNull ExportFormatVO exportFormatVO, @NotNull Long l) throws FrameworkException {
        this.checkPermission(Permission.ARCHIVED_ACCOUNTS_VIEW);
        return this.accountService.exportArchivedTransfer(exportFormatVO, l);
    }

    public FileInfo exportUsersWithBalances(@NotNull ExportFormatVO exportFormatVO, @NotNull UserWithBalanceQuery userWithBalanceQuery) throws FrameworkException {
        if (!this.checkUsersWithBalances(userWithBalanceQuery)) {
            return null;
        }
        return this.accountService.exportUsersWithBalances(exportFormatVO, userWithBalanceQuery);
    }

    public AccountBalanceHistoryVO getAccountBalanceHistory(@NotNull AccountBalanceHistoryParams accountBalanceHistoryParams) throws FrameworkException {
        this.checkViewHistory(accountBalanceHistoryParams.getAccount());
        return this.accountService.getAccountBalanceHistory(accountBalanceHistoryParams);
    }

    public AccountLimitsOverviewData getAccountBalanceLimitsOverviewData() throws FrameworkException {
        this.checkPermission(Permission.USER_ACCOUNT_LIMIT_VIEW);
        return this.accountService.getAccountBalanceLimitsOverviewData();
    }

    public AccountHistoriesOverviewData getAccountHistoriesOverviewData() {
        SessionData sessionData = this.getSessionData();
        if (sessionData.hasPermission(new Permission[]{Permission.USER_ACCOUNTS_VIEW, Permission.SYSTEM_ACCOUNTS_VIEW}) || sessionData.isMember() && this.accountTypeService.hasAccessible((InternalAccountOwner)sessionData.getLoggedUser())) {
            return this.accountService.getAccountHistoriesOverviewData();
        }
        throw new PermissionDeniedException();
    }

    public AccountHistoriesOverviewStatusVO getAccountHistoriesOverviewStatus(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        this.checkAccountHistoriesOverviewQuery(accountHistoriesOverviewQuery);
        return this.accountService.getAccountHistoriesOverviewStatus(accountHistoriesOverviewQuery);
    }

    public AccountHistoryData getAccountHistoryData(AccountVO accountVO, RateVisibility rateVisibility) {
        this.checkViewHistory(accountVO);
        AccountHistoryData accountHistoryData = this.accountService.getAccountHistoryData(accountVO, rateVisibility);
        accountHistoryData.setCanSearchArchive(accountHistoryData.isCanSearchArchive() && this.hasPermission(Permission.ARCHIVED_ACCOUNTS_VIEW));
        return accountHistoryData;
    }

    public AccountWithHistoryStatusVO getAccountHistoryStatus(AccountHistoryQuery accountHistoryQuery) throws FrameworkException {
        boolean bl = ModelHelper.isEmpty((DatePeriodDTO)accountHistoryQuery.getPeriod());
        Scope scope = bl ? Scope.ACCOUNT_STATUS : Scope.ACCOUNT_HISTORY;
        this.checkAccountHistoryQuery(accountHistoryQuery, scope);
        return this.accountService.getAccountHistoryStatus(accountHistoryQuery);
    }

    public AccountLimitsOverviewData getAccountPaymentAmountLimitsOverviewData() throws FrameworkException {
        this.checkPermission(Permission.USER_ACCOUNT_PAYMENT_LIMIT_VIEW);
        return this.accountService.getAccountPaymentAmountLimitsOverviewData();
    }

    public List<AccountWithStatusVO> getAccountsSummary(InternalAccountOwner internalAccountOwner, DateTime dateTime) throws FrameworkException {
        this.checkAccessibleAccounts(internalAccountOwner);
        this.checkScope(Scope.ACCOUNT_STATUS);
        return this.accountService.getAccountsSummary(internalAccountOwner, dateTime);
    }

    public AccountStatusVO getAccountStatus(AccountVO accountVO, DateTime dateTime, RateVisibility rateVisibility) {
        boolean bl;
        Date date = this.conversionHandler.toDate((IDate)dateTime);
        boolean bl2 = bl = dateTime == null || DateHelper.sameDay((TimeZone)this.getSessionData().getConfiguration().getTimeZone(), (Date)date, (Date)new Date());
        if (bl) {
            this.checkViewStatus(accountVO);
        } else {
            this.checkViewHistory(accountVO);
        }
        AccountStatusVO accountStatusVO = this.accountService.getAccountStatus(accountVO, dateTime, rateVisibility);
        if (accountStatusVO == null) {
            throw new PermissionDeniedException();
        }
        return accountStatusVO;
    }

    public AccountWithStatusVO getAccountWithStatus(AccountVO accountVO, DateTime dateTime) throws FrameworkException {
        this.checkAccountAccessibility(accountVO);
        return this.accountService.getAccountWithStatus(accountVO, dateTime);
    }

    public ArchivedAccountHistoryData getArchivedAccountHistoryData(@NotNull AccountVO accountVO) throws FrameworkException {
        this.checkViewHistory(accountVO);
        this.checkPermission(Permission.ARCHIVED_ACCOUNTS_VIEW);
        return this.accountService.getArchivedAccountHistoryData(accountVO);
    }

    public ArchivedTransferData getArchivedTransferData(@NotNull Long l) throws FrameworkException {
        this.checkPermission(Permission.ARCHIVED_ACCOUNTS_VIEW);
        return this.accountService.getArchivedTransferData(l);
    }

    public AccountPermissionsData getPermissions(@NotNull AccountVO accountVO) throws FrameworkException {
        this.checkAccountAccessibility(accountVO);
        return this.accountService.getPermissions(accountVO);
    }

    public UserAccountBalanceLimitData getUserAccountBalanceLimitData(AccountVO accountVO) {
        this.checkPermission(Permission.USER_ACCOUNT_LIMIT_VIEW);
        Account account = this.checkAccountAccessibility(accountVO);
        UserAccountBalanceLimitData userAccountBalanceLimitData = this.accountService.getUserAccountBalanceLimitData(accountVO);
        userAccountBalanceLimitData.setEditable(this.accountService.isActive((IAccount)account) && this.hasPermission(Permission.USER_ACCOUNT_LIMIT_MANAGE));
        return userAccountBalanceLimitData;
    }

    public UserAccountPaymentAmountLimitData getUserAccountPaymentAmountLimitData(AccountVO accountVO) {
        this.checkPermission(Permission.USER_ACCOUNT_PAYMENT_LIMIT_VIEW);
        Account account = this.checkAccountAccessibility(accountVO);
        UserAccountPaymentAmountLimitData userAccountPaymentAmountLimitData = this.accountService.getUserAccountPaymentAmountLimitData(accountVO);
        userAccountPaymentAmountLimitData.setEditable(this.accountService.isActive((IAccount)account) && this.hasPermission(Permission.USER_ACCOUNT_PAYMENT_LIMIT_MANAGE));
        return userAccountPaymentAmountLimitData;
    }

    public List<AccountBalanceLimitVO> getUserAccountsBalanceLimits(UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkPermission(Permission.USER_ACCOUNT_LIMIT_VIEW);
        this.checkAccessibleAccounts((InternalAccountOwner)userLocatorVO);
        return this.accountService.getUserAccountsBalanceLimits(userLocatorVO);
    }

    public List<AccountPaymentAmountLimitVO> getUserAccountsPaymentAmountLimits(UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkPermission(Permission.USER_ACCOUNT_PAYMENT_LIMIT_VIEW);
        this.checkAccessibleAccounts((InternalAccountOwner)userLocatorVO);
        return this.accountService.getUserAccountsPaymentAmountLimits(userLocatorVO);
    }

    public UsersWithBalancesOverview getUsersWithBalancesOverview(UserWithBalanceQuery userWithBalanceQuery) throws FrameworkException, QueryParseException {
        if (!this.checkUsersWithBalances(userWithBalanceQuery)) {
            UsersWithBalancesOverview usersWithBalancesOverview = new UsersWithBalancesOverview();
            IntegerRangeDTO integerRangeDTO = userWithBalanceQuery.getYellowBalanceRange();
            UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)userWithBalanceQuery.getAccountType());
            CurrencyVO currencyVO = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)userAccountType.getCurrency());
            if (integerRangeDTO != null && integerRangeDTO.getMin() != null && integerRangeDTO.getMax() != null) {
                HashMap<BalanceLevel, AmountSummaryVO> hashMap = new HashMap<BalanceLevel, AmountSummaryVO>();
                for (BalanceLevel balanceLevel : BalanceLevel.values()) {
                    hashMap.put(balanceLevel, ModelHelper.amountSummary((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (int)0, (CurrencyVO)currencyVO));
                }
                usersWithBalancesOverview.setOverviewByRange(hashMap);
            }
            usersWithBalancesOverview.setGeneralOverview(ModelHelper.amountSummary((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (int)0, (CurrencyVO)currencyVO));
            return usersWithBalancesOverview;
        }
        return this.accountService.getUsersWithBalancesOverview(userWithBalanceQuery);
    }

    public UserWithBalanceSearchData getUserWithBalanceSearchData() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isUserManager() || !sessionData.hasPermission(Permission.USER_ACCOUNTS_VIEW)) {
            throw new PermissionDeniedException();
        }
        return this.accountService.getUserWithBalanceSearchData();
    }

    public boolean hasAccess(Account account) {
        return this.doHasAccess(account, false);
    }

    public boolean hasAccess(AccountLocator accountLocator) {
        try {
            Account account = this.accountService.load(accountLocator);
            return this.hasAccess(account);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return false;
        }
    }

    public boolean hasAccess(AccountVO accountVO) {
        try {
            return this.hasAccess((Account)this.conversionHandler.convert(Account.class, (Object)accountVO));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return false;
        }
    }

    public boolean hasAccess(InternalAccountOwner internalAccountOwner, AccountType accountType) {
        try {
            return this.hasAccess(this.accountService.load(internalAccountOwner, accountType));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return false;
        }
    }

    public boolean hasVisibility(Account account) {
        return this.doHasAccess(account, true);
    }

    public AccountWithCurrencyVO load(Long l) throws EntityNotFoundException {
        return this.accountService.load(l);
    }

    public Page<AccountBalanceLimitVO> searchAccountBalanceLimitsOverview(AccountBalanceLimitsOverviewQuery accountBalanceLimitsOverviewQuery) {
        this.checkPermission(Permission.USER_ACCOUNT_LIMIT_VIEW);
        this.checkAccountLimitsOverviewQuery((AccountLimitsOverviewQuery)accountBalanceLimitsOverviewQuery);
        return this.accountService.searchAccountBalanceLimitsOverview(accountBalanceLimitsOverviewQuery);
    }

    public Page<AccountHistoryOverviewEntryVO> searchAccountHistoriesOverview(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        this.checkAccountHistoriesOverviewQuery(accountHistoriesOverviewQuery);
        return this.accountService.searchAccountHistoriesOverview(accountHistoriesOverviewQuery);
    }

    public Page<AccountHistoryEntryVO> searchAccountHistory(AccountHistoryQuery accountHistoryQuery) {
        this.checkAccountHistoryQuery(accountHistoryQuery);
        return this.accountService.searchAccountHistory(accountHistoryQuery);
    }

    public Page<AccountPaymentAmountLimitVO> searchAccountPaymentAmountLimitsOverview(AccountPaymentAmountLimitsOverviewQuery accountPaymentAmountLimitsOverviewQuery) {
        this.checkPermission(Permission.USER_ACCOUNT_PAYMENT_LIMIT_VIEW);
        this.checkAccountLimitsOverviewQuery((AccountLimitsOverviewQuery)accountPaymentAmountLimitsOverviewQuery);
        return this.accountService.searchAccountPaymentAmountLimitsOverview(accountPaymentAmountLimitsOverviewQuery);
    }

    public ArchivedAccountHistoryVO searchArchivedAccountHistory(@NotNull ArchivedAccountHistoryQuery archivedAccountHistoryQuery) throws FrameworkException {
        this.checkViewHistory(archivedAccountHistoryQuery.getAccount());
        this.checkPermission(Permission.ARCHIVED_ACCOUNTS_VIEW);
        return this.accountService.searchArchivedAccountHistory(archivedAccountHistoryQuery);
    }

    public Page<UserWithBalanceVO> searchUsersWithBalances(UserWithBalanceQuery userWithBalanceQuery) throws FrameworkException {
        if (!this.checkUsersWithBalances(userWithBalanceQuery)) {
            return PageImpl.empty();
        }
        return this.accountService.searchUsersWithBalances(userWithBalanceQuery);
    }

    public void setBalanceLimit(AccountBalanceLimitDTO accountBalanceLimitDTO) {
        this.checkAccountAccessibility(accountBalanceLimitDTO.getAccount());
        this.checkPermission(Permission.USER_ACCOUNT_LIMIT_MANAGE);
        this.accountService.setBalanceLimit(accountBalanceLimitDTO);
    }

    public void setPaymentAmountLimit(AccountPaymentAmountLimitDTO accountPaymentAmountLimitDTO) {
        this.checkAccountAccessibility(accountPaymentAmountLimitDTO.getAccount());
        this.checkPermission(Permission.USER_ACCOUNT_PAYMENT_LIMIT_MANAGE);
        this.accountService.setPaymentAmountLimit(accountPaymentAmountLimitDTO);
    }

    protected void checkAccountHistoriesOverviewQuery(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.getAccessToken() != null || sessionData.getProducts().grantedAccountTypes().isEmpty()) {
            throw new PermissionDeniedException();
        }
        this.checkTransQuery((AbstractTransQuery)accountHistoriesOverviewQuery);
        this.checkVOs(AccountType.class, accountHistoriesOverviewQuery.getFromAccounts());
        this.checkVOs(AccountType.class, accountHistoriesOverviewQuery.getToAccounts());
        this.checkVOs(Currency.class, accountHistoriesOverviewQuery.getCurrencies());
        this.checkUserBroker((QueryParameters)accountHistoriesOverviewQuery);
    }

    protected void checkAccountHistoryQuery(AccountHistoryQuery accountHistoryQuery) {
        this.checkAccountHistoryQuery(accountHistoryQuery, Scope.ACCOUNT_HISTORY);
    }

    protected void checkAccountLimitsOverviewQuery(AccountLimitsOverviewQuery accountLimitsOverviewQuery) {
        this.checkUserBroker((QueryParameters)accountLimitsOverviewQuery);
        SessionData sessionData = this.getSessionData();
        if (sessionData.isBroker()) {
            accountLimitsOverviewQuery.setBrokers(CollectionHelper.asSet((Object[])new UserVO[]{new UserVO(sessionData.getLoggedUser().getId())}));
        }
        GroupListView groupListView = this.groupsHandler.visibles().accessibles().basicUsers();
        groupListView.check((Collection)accountLimitsOverviewQuery.getGroups());
        if (groupListView.isEmpty() && !sessionData.isBroker()) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<Account>(Account.class){

            public boolean isVisible(SessionData sessionData, Account account) {
                return AccountServiceSecurity.this.hasAccess(account);
            }
        };
    }

    private Account checkAccountAccessibility(Account account) {
        if (!this.hasAccess(account)) {
            throw new PermissionDeniedException();
        }
        return account;
    }

    private Account checkAccountAccessibility(AccountVO accountVO) {
        return this.checkAccountAccessibility((Account)this.conversionHandler.convert(Account.class, (Object)accountVO));
    }

    private Account checkAccountAndScope(AccountVO accountVO, Scope scope) {
        OidcAuthorization oidcAuthorization;
        UserAccountType userAccountType;
        Account account = this.checkAccountAccessibility(accountVO);
        OidcAccessToken oidcAccessToken = this.checkScope(scope);
        if (oidcAccessToken != null && (userAccountType = (oidcAuthorization = oidcAccessToken.getAuthorization()).getGrantedAccountType()) != null && !userAccountType.equals((Object)account.getType())) {
            throw new PermissionDeniedException();
        }
        return account;
    }

    private void checkAccountHistoryQuery(AccountHistoryQuery accountHistoryQuery, Scope scope) {
        this.checkTransQuery((AbstractTransQuery)accountHistoryQuery);
        Account account = this.checkAccountAndScope(accountHistoryQuery.getAccount(), scope);
        if (CollectionHelper.isNotEmpty((Iterable)accountHistoryQuery.getStatuses())) {
            List list = this.accountService.getVisibleFlows(account);
            Set set = this.conversionHandler.convertSet(TransferStatus.class, (Iterable)accountHistoryQuery.getStatuses());
            for (TransferStatus transferStatus : set) {
                if (list.contains(transferStatus.getFlow())) continue;
                throw new EntityNotFoundException(TransferStatus.class, transferStatus.getId());
            }
        }
    }

    private void checkUserBroker(QueryParameters queryParameters) {
        SetProperty setProperty;
        if (queryParameters instanceof AccountHistoriesOverviewQuery) {
            setProperty = AccountHistoriesOverviewQuery.BROKERS;
        } else if (queryParameters instanceof AccountLimitsOverviewQuery) {
            setProperty = AccountLimitsOverviewQuery.BROKERS;
        } else {
            throw new IllegalArgumentException();
        }
        SessionData sessionData = this.getSessionData();
        if (sessionData.isBroker()) {
            Set set = (Set)queryParameters.get((Property)setProperty);
            if (CollectionHelper.isNotEmpty((Iterable)set) && (set.size() > 1 || !sessionData.getLoggedUser().equals(CollectionHelper.first((Iterable)this.conversionHandler.convertSet(User.class, (Iterable)set))))) {
                throw new PermissionDeniedException();
            }
        } else if (sessionData.isAdmin()) {
            this.checkVOs(User.class, (Collection)queryParameters.get((Property)setProperty));
        } else {
            PermissionHelper.checkEmpty((Collection)((Collection)queryParameters.get((Property)setProperty)));
        }
    }

    private boolean checkUsersWithBalances(UserWithBalanceQuery userWithBalanceQuery) {
        UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)userWithBalanceQuery.getAccountType());
        this.permissionOptionalValue(Permission.USER_ACCOUNTS_VIEW).value((Object)userAccountType).check();
        if (!this.userServiceSecurity.checkQuery((AbstractUserQuery)userWithBalanceQuery)) {
            return false;
        }
        SessionData sessionData = this.getSessionData();
        if (sessionData.isBroker()) {
            userWithBalanceQuery.setBrokers(CollectionHelper.asSet((Object[])new UserVO[]{new UserVO(sessionData.getLoggedUser().getId())}));
        }
        return true;
    }

    private Account checkViewHistory(AccountVO accountVO) {
        return this.checkAccountAndScope(accountVO, Scope.ACCOUNT_HISTORY);
    }

    private Account checkViewStatus(AccountVO accountVO) {
        return this.checkAccountAndScope(accountVO, Scope.ACCOUNT_STATUS);
    }
}

