/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import org.cyclos.entities.access.UserIdentityProvider;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.UserIdentityProviderServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.access.useridentityproviders.UserIdentityProviderListData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.access.UserIdentityProviderService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class UserIdentityProviderServiceSecurity
extends BaseServiceSecurity
implements UserIdentityProviderService {
    @Autowired
    private UserIdentityProviderServiceLocal userIdentityProviderService;

    public void disable(UserLocatorVO userLocatorVO, IdentityProviderVO identityProviderVO) throws FrameworkException {
        BasicUser basicUser;
        SessionData sessionData = this.getSessionData();
        if (!this.allowed(sessionData, basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO), true)) {
            throw new PermissionDeniedException();
        }
        this.userIdentityProviderService.disable(userLocatorVO, identityProviderVO);
    }

    public UserIdentityProviderListData getListData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser;
        SessionData sessionData = this.getSessionData();
        if (!this.allowed(sessionData, basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO), false)) {
            throw new PermissionDeniedException();
        }
        boolean bl = this.allowed(sessionData, basicUser, true);
        UserIdentityProviderListData userIdentityProviderListData = this.userIdentityProviderService.getListData(userLocatorVO);
        userIdentityProviderListData.setCanManage(bl);
        userIdentityProviderListData.setCanLink(bl && basicUser.equals((Object)sessionData.getLoggedBasicUser()));
        return userIdentityProviderListData;
    }

    public void unlink(UserLocatorVO userLocatorVO, IdentityProviderVO identityProviderVO) throws FrameworkException {
        BasicUser basicUser;
        SessionData sessionData = this.getSessionData();
        if (!this.allowed(sessionData, basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO), true)) {
            throw new PermissionDeniedException();
        }
        this.userIdentityProviderService.unlink(userLocatorVO, identityProviderVO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<UserIdentityProvider>(UserIdentityProvider.class){

            public boolean isVisible(SessionData sessionData, UserIdentityProvider userIdentityProvider) {
                return UserIdentityProviderServiceSecurity.this.allowed(sessionData, userIdentityProvider.getBasicUser(), false);
            }
        };
    }

    private boolean allowed(SessionData sessionData, BasicUser basicUser, boolean bl) {
        if (sessionData.getLoggedBasicUser().equals((Object)basicUser) || sessionData.isOwnerOf(basicUser)) {
            return sessionData.hasPermission(Permission.MY_IDENTITY_PROVIDERS_ENABLE);
        }
        return sessionData.manages(basicUser) && sessionData.hasPermission(bl ? Permission.USER_IDENTITY_PROVIDERS_MANAGE : Permission.USER_IDENTITY_PROVIDERS_VIEW);
    }
}

