/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.QTrustedDevice;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TrustedDeviceServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.devices.ActivateTrustedDeviceDTO;
import org.cyclos.model.access.devices.ActivateTrustedDeviceData;
import org.cyclos.model.access.devices.RequestActivationResult;
import org.cyclos.model.access.devices.RequestDeviceActivationParams;
import org.cyclos.model.access.devices.TrustedDeviceActivationParams;
import org.cyclos.model.access.devices.TrustedDeviceActivationWithoutCodeParams;
import org.cyclos.model.access.devices.TrustedDeviceDTO;
import org.cyclos.model.access.devices.TrustedDeviceData;
import org.cyclos.model.access.devices.TrustedDeviceVO;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.SendOtpData;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.access.TrustedDeviceService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TrustedDeviceServiceSecurity
extends BaseServiceSecurity
implements TrustedDeviceService {
    @Autowired
    private TrustedDeviceServiceLocal trustedDeviceService;
    private QTrustedDevice $ = QTrustedDevice.trustedDevice;

    public ActivateTrustedDeviceDTO activate(TrustedDeviceActivationParams trustedDeviceActivationParams) throws FrameworkException {
        this.checkLoggedIn();
        return this.trustedDeviceService.activate(trustedDeviceActivationParams);
    }

    public ActivateTrustedDeviceData activateIfPossible(TrustedDeviceActivationWithoutCodeParams trustedDeviceActivationWithoutCodeParams) throws FrameworkException {
        this.checkLoggedIn();
        return this.trustedDeviceService.activateIfPossible(trustedDeviceActivationWithoutCodeParams);
    }

    public SendOtpData getActivationData() throws FrameworkException {
        this.checkLoggedIn();
        return this.trustedDeviceService.getActivationData();
    }

    public CredentialInputDTO getConfirmationPasswordInputForRemove(@NotNull Long l) throws FrameworkException {
        this.checkManage(l);
        return this.trustedDeviceService.getConfirmationPasswordInputForRemove(l);
    }

    public TrustedDeviceData getData(long l) throws FrameworkException {
        this.checkView(l);
        TrustedDevice trustedDevice = this.find(TrustedDevice.class, l);
        TrustedDeviceData trustedDeviceData = this.trustedDeviceService.getData(l);
        trustedDeviceData.setCanManage(trustedDeviceData.isCanManage() && (this.getSessionData().getLoggedBasicUser().equals((Object)trustedDevice.getUser()) || this.hasPermission(Permission.USER_TRUSTED_DEVICES_MANAGE)));
        return trustedDeviceData;
    }

    public List<TrustedDeviceVO> list(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser;
        BasicUser basicUser2 = basicUser = userLocatorVO == null ? this.getSessionData().getLoggedBasicUser() : this.getUser((IUser)userLocatorVO);
        if (!this.canView(basicUser)) {
            throw new PermissionDeniedException();
        }
        return this.trustedDeviceService.list(new UserLocatorVO(basicUser.getId()));
    }

    public void remove(Long l, String string) throws FrameworkException {
        this.checkManage(l);
        this.trustedDeviceService.remove(l, string);
    }

    public RequestActivationResult requestActivationCode(@NotNull RequestDeviceActivationParams requestDeviceActivationParams) throws FrameworkException {
        this.checkLoggedIn();
        TrustedDevice trustedDevice = this.getDevice(requestDeviceActivationParams.getDeviceId());
        if (trustedDevice != null && !trustedDevice.getUser().equals((Object)this.getLoggedBasicUser())) {
            throw new PermissionDeniedException();
        }
        MobilePhone mobilePhone = (MobilePhone)this.conversionHandler.convert(MobilePhone.class, (Object)requestDeviceActivationParams.getMobilePhone());
        if (mobilePhone != null && !mobilePhone.getUser().equals((Object)this.getLoggedBasicUser())) {
            throw new PermissionDeniedException();
        }
        return this.trustedDeviceService.requestActivationCode(requestDeviceActivationParams);
    }

    public void save(TrustedDeviceDTO trustedDeviceDTO) throws FrameworkException {
        this.checkManage(trustedDeviceDTO.getId());
        this.trustedDeviceService.save(trustedDeviceDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<TrustedDevice>(TrustedDevice.class){

            public boolean isVisible(SessionData sessionData, TrustedDevice trustedDevice) {
                return TrustedDeviceServiceSecurity.this.canView(trustedDevice);
            }
        };
    }

    private boolean canManage(TrustedDevice trustedDevice) {
        return this.hasPermission(trustedDevice.getUser(), true);
    }

    private boolean canView(BasicUser basicUser) {
        return this.hasPermission(basicUser, false);
    }

    private boolean canView(TrustedDevice trustedDevice) {
        return this.canView(trustedDevice.getUser());
    }

    private void checkManage(long l) {
        TrustedDevice trustedDevice = this.getDevice(l);
        if (!this.canManage(trustedDevice)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkView(long l) {
        TrustedDevice trustedDevice = this.getDevice(l);
        if (!this.canView(trustedDevice)) {
            throw new PermissionDeniedException();
        }
    }

    private TrustedDevice getDevice(Long l) {
        if (l == null) {
            return null;
        }
        return (TrustedDevice)((DBQuery)this.from(new EntityPath[]{this.$}).where((Predicate)this.$.id.eq((Object)l))).requiredUniqueResult((Expression)this.$);
    }

    private boolean hasPermission(BasicUser basicUser, boolean bl) {
        if (basicUser.equals((Object)this.getLoggedBasicUser())) {
            return true;
        }
        if (basicUser instanceof Operator) {
            return this.permission(basicUser).my(new Permission[]{Permission.MY_OPERATORS_MANAGE_OPERATORS}).user(new Permission[]{bl ? Permission.USER_OPERATORS_MANAGE : Permission.USER_OPERATORS_VIEW}).granted();
        }
        return this.permission(basicUser).my(new Permission[0]).user(new Permission[]{bl ? Permission.USER_TRUSTED_DEVICES_MANAGE : Permission.USER_TRUSTED_DEVICES_VIEW}).granted();
    }
}

