/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.cyclos.entities.access.Password;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InvalidSecurityAnswerException;
import org.cyclos.model.access.LoggedOutException;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.passwords.ChangeForgottenPasswordDTO;
import org.cyclos.model.access.passwords.ChangeForgottenPasswordData;
import org.cyclos.model.access.passwords.ChangeGeneratedPasswordDTO;
import org.cyclos.model.access.passwords.ChangePasswordDTO;
import org.cyclos.model.access.passwords.ChangePasswordData;
import org.cyclos.model.access.passwords.ForgotPasswordRequestDTO;
import org.cyclos.model.access.passwords.GetChangeForgottenPasswordDataParams;
import org.cyclos.model.access.passwords.OtpResult;
import org.cyclos.model.access.passwords.PasswordAction;
import org.cyclos.model.access.passwords.PasswordActionDTO;
import org.cyclos.model.access.passwords.PasswordData;
import org.cyclos.model.access.passwords.ResetAndSendPasswordDTO;
import org.cyclos.model.access.passwords.SetSecurityQuestionDTO;
import org.cyclos.model.access.passwords.SetSecurityQuestionData;
import org.cyclos.model.access.passwords.UserPasswordsData;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.system.configurations.ForgotPasswordMode;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.access.PinServiceSecurity;
import org.cyclos.security.access.TotpServiceSecurity;
import org.cyclos.services.access.PasswordService;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class PasswordServiceSecurity
extends BaseServiceSecurity
implements PasswordService {
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private PinServiceSecurity pinServiceSecurity;
    @Autowired
    private TotpServiceSecurity totpServiceSecurity;

    public String activate(PasswordTypeVO passwordTypeVO) throws FrameworkException, IllegalActionException {
        this.checkLoggedIn();
        return this.passwordService.activate(passwordTypeVO);
    }

    public void allowActivation(PasswordActionDTO passwordActionDTO) throws FrameworkException, IllegalActionException {
        this.checkAction(passwordActionDTO, PasswordAction.ALLOW_ACTIVATION);
        this.passwordService.allowActivation(passwordActionDTO);
    }

    public void change(ChangePasswordDTO changePasswordDTO) throws FrameworkException, IllegalActionException, PasswordException, ValidationException {
        this.checkAction((PasswordActionDTO)changePasswordDTO, PasswordAction.CHANGE);
        this.passwordService.change(changePasswordDTO);
    }

    public void changeForgottenPassword(ChangeForgottenPasswordDTO changeForgottenPasswordDTO) throws FrameworkException, InvalidSecurityAnswerException {
        if (!this.isGuest()) {
            throw new LoggedOutException();
        }
        this.passwordService.changeForgottenPassword(changeForgottenPasswordDTO);
    }

    public void disable(PasswordActionDTO passwordActionDTO) throws FrameworkException, IllegalActionException {
        this.checkAction(passwordActionDTO, PasswordAction.DISABLE);
        this.passwordService.disable(passwordActionDTO);
    }

    public void enable(PasswordActionDTO passwordActionDTO) throws FrameworkException, IllegalActionException {
        this.checkAction(passwordActionDTO, PasswordAction.ENABLE);
        this.passwordService.enable(passwordActionDTO);
    }

    public OtpResult forgotPasswordRequest(ForgotPasswordRequestDTO forgotPasswordRequestDTO) throws FrameworkException {
        ForgotPasswordMode forgotPasswordMode;
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isGuest() && !sessionData.hasPermission(Permission.CONNECTED_USERS_LOGIN)) {
            throw new PermissionDeniedException();
        }
        if (sessionData.isGuest() && !(forgotPasswordMode = (ForgotPasswordMode)ObjectHelper.defaultValue((Object)this.getConfiguration().getForgotPasswordMode(), (Object)ForgotPasswordMode.DISABLED)).showForgotPassword()) {
            throw new IllegalActionException();
        }
        return this.passwordService.forgotPasswordRequest(forgotPasswordRequestDTO);
    }

    public String generateNew(ChangeGeneratedPasswordDTO changeGeneratedPasswordDTO) throws FrameworkException, IllegalActionException {
        this.checkAction(this.getLoggedBasicUser(), changeGeneratedPasswordDTO.getType(), PasswordAction.CHANGE);
        return this.passwordService.generateNew(changeGeneratedPasswordDTO);
    }

    public ChangeForgottenPasswordData getChangeForgottenPasswordData(GetChangeForgottenPasswordDataParams getChangeForgottenPasswordDataParams) throws FrameworkException {
        if (!this.isGuest()) {
            throw new LoggedOutException();
        }
        return this.passwordService.getChangeForgottenPasswordData(getChangeForgottenPasswordDataParams);
    }

    public ChangePasswordData getChangePasswordData(boolean bl) throws FrameworkException {
        this.checkLoggedIn();
        ChangePasswordData changePasswordData = this.passwordService.getChangePasswordData(bl);
        BasicUser basicUser = this.find(BasicUser.class, changePasswordData.getChangePassword().getUser().getId());
        this.checkManagePasswordsOf(basicUser);
        return changePasswordData;
    }

    public UserPasswordsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        this.checkManagePasswordsOf(basicUser);
        UserPasswordsData userPasswordsData = this.passwordService.getData(userLocatorVO);
        this.pinServiceSecurity.apply(basicUser, userPasswordsData.getPins());
        if (this.totpServiceSecurity.isVisible(basicUser)) {
            this.totpServiceSecurity.apply(basicUser, userPasswordsData.getTotpSecret());
        } else {
            userPasswordsData.setTotpSecret(null);
        }
        return userPasswordsData;
    }

    public PasswordData getPasswordData(UserLocatorVO userLocatorVO, PasswordTypeVO passwordTypeVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        this.checkManagePasswordsOf(basicUser);
        return this.passwordService.getPasswordData(userLocatorVO, passwordTypeVO);
    }

    public SetSecurityQuestionData getSetSecurityQuestionData() throws FrameworkException {
        this.checkLoggedIn();
        return this.passwordService.getSetSecurityQuestionData();
    }

    public List<String> requestNewOTP(SendMedium sendMedium, String string, List<Long> list) throws FrameworkException {
        Supplier<List> supplier = () -> {
            this.checkRequestNewOTP(sendMedium, CredentialUsage.CONFIRMATION);
            return this.passwordService.requestNewOTP(sendMedium, string, list);
        };
        return StringHelper.isBlank((Object)string) || this.getSessionData().getChannelName().equals(string) ? supplier.get() : (List)this.invokerHandler.runAs(SessionDataFactory.inChannel((String)string), supplier::get);
    }

    public List<String> requestNewOTPForLoginConfirmation(SendMedium sendMedium, List<Long> list) throws FrameworkException {
        this.checkRequestNewOTP(sendMedium, CredentialUsage.LOGIN_CONFIRMATION);
        return this.passwordService.requestNewOTPForLoginConfirmation(sendMedium, list);
    }

    public void reset(PasswordActionDTO passwordActionDTO) throws FrameworkException, IllegalActionException {
        this.checkAction(passwordActionDTO, PasswordAction.RESET);
        this.passwordService.reset(passwordActionDTO);
    }

    public void resetAndSend(ResetAndSendPasswordDTO resetAndSendPasswordDTO) throws FrameworkException, IllegalActionException {
        this.checkAction((PasswordActionDTO)resetAndSendPasswordDTO, PasswordAction.RESET_AND_SEND);
        this.passwordService.resetAndSend(resetAndSendPasswordDTO);
    }

    public void resetSecurityQuestion(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        this.checkManagePasswordsOf(basicUser);
        this.passwordService.resetSecurityQuestion(userLocatorVO);
    }

    public void setSecurityQuestion(SetSecurityQuestionDTO setSecurityQuestionDTO) throws FrameworkException {
        if (!this.passwordService.isPendingSecurityQuestion()) {
            throw new IllegalActionException();
        }
        this.passwordService.setSecurityQuestion(setSecurityQuestionDTO);
    }

    public void unblock(PasswordActionDTO passwordActionDTO) throws FrameworkException, IllegalActionException {
        this.checkAction(passwordActionDTO, PasswordAction.UNBLOCK);
        this.passwordService.unblock(passwordActionDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<Password>(Password.class){

            public boolean isVisible(SessionData sessionData, Password password) {
                return PasswordServiceSecurity.this.canManagePasswords(password.getUser());
            }
        };
    }

    private boolean canManagePasswords(BasicUser basicUser) {
        if (basicUser instanceof Operator && !basicUser.equals((Object)this.getLoggedBasicUser())) {
            return this.permission((BasicUser)basicUser.getUser()).my(new Permission[]{Permission.MY_OPERATORS_MANAGE_OPERATORS}).user(new Permission[]{Permission.USER_OPERATORS_MANAGE}).granted();
        }
        return this.permission(basicUser).my(new Permission[]{Permission.MY_PASSWORDS_MANAGE}).user(new Permission[]{Permission.USER_PASSWORDS_MANAGE}).granted();
    }

    private Pair<BasicUser, PasswordType> checkAction(BasicUser basicUser, PasswordTypeVO passwordTypeVO, PasswordAction passwordAction) {
        PasswordType passwordType = (PasswordType)this.conversionHandler.convert(PasswordType.class, (Object)passwordTypeVO);
        if (basicUser == null || passwordType == null) {
            return null;
        }
        this.checkManagePasswordsOf(basicUser);
        PasswordData passwordData = this.passwordService.getPasswordData(basicUser, passwordType);
        if (passwordData == null || !passwordData.getActions().contains(passwordAction)) {
            throw new IllegalActionException();
        }
        return Pair.create((Object)basicUser, (Object)passwordType);
    }

    private Pair<BasicUser, PasswordType> checkAction(PasswordActionDTO passwordActionDTO, PasswordAction passwordAction) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)passwordActionDTO.getUser());
        return this.checkAction(basicUser, (PasswordTypeVO)passwordActionDTO.getType(), passwordAction);
    }

    private void checkManagePasswordsOf(BasicUser basicUser) {
        if (!this.canManagePasswords(basicUser)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkRequestNewOTP(SendMedium sendMedium, CredentialUsage credentialUsage) throws FrameworkException {
        List list = this.passwordHandler.accessor(credentialUsage).getOtpSendMediums();
        PermissionHelper.checkContains((Collection)list, (Object)sendMedium);
    }
}

