/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import org.cyclos.entities.access.BaseOidcClient;
import org.cyclos.entities.access.DynamicOidcClient;
import org.cyclos.impl.access.OidcClientServiceLocal;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.oidcclients.BaseOidcClientDTO;
import org.cyclos.model.access.oidcclients.OidcClientData;
import org.cyclos.model.access.oidcclients.OidcClientQuery;
import org.cyclos.model.access.oidcclients.OidcClientSearchData;
import org.cyclos.model.access.oidcclients.OidcClientVO;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleConfigurationEntityCRUDServiceSecurity;
import org.cyclos.services.access.OidcClientService;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class OidcClientServiceSecurity
extends SimpleConfigurationEntityCRUDServiceSecurity<BaseOidcClientDTO, BaseOidcClient, OidcClientData, Void>
implements OidcClientService {
    @Autowired
    private OidcClientServiceLocal oidcClientService;

    public OidcClientServiceSecurity() {
        super(BaseOidcClient.class, Permission.OIDC_CLIENTS_VIEW, Permission.OIDC_CLIENTS_MANAGE);
    }

    @Override
    public boolean canPerformOperation(BaseOidcClient baseOidcClient, CRUDOperation cRUDOperation) {
        if (baseOidcClient instanceof DynamicOidcClient && ObjectHelper.isOneOf((Object)cRUDOperation, (Object[])new Object[]{CRUDOperation.CREATE, CRUDOperation.UPDATE})) {
            return false;
        }
        return super.canPerformOperation(baseOidcClient, cRUDOperation);
    }

    public OidcClientSearchData getSearchData() throws FrameworkException {
        this.checkViewPermission();
        OidcClientSearchData oidcClientSearchData = this.oidcClientService.getSearchData();
        oidcClientSearchData.setCanManage(this.hasManagePermission());
        return oidcClientSearchData;
    }

    public Page<OidcClientVO> search(OidcClientQuery oidcClientQuery) throws FrameworkException {
        this.checkViewPermission();
        return this.oidcClientService.search(oidcClientQuery);
    }

    protected OidcClientServiceLocal getImplementation() {
        return this.oidcClientService;
    }
}

