/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.OidcAuthorizationServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.oidcauthorizations.OidcAuthorizationDetailedVO;
import org.cyclos.model.access.oidcauthorizations.OidcAuthorizationQuery;
import org.cyclos.model.access.oidcauthorizations.OidcAuthorizationSearchData;
import org.cyclos.model.access.oidcauthorizations.OidcAuthorizationVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.access.OidcAuthorizationService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class OidcAuthorizationServiceSecurity
extends BaseServiceSecurity
implements OidcAuthorizationService {
    @Autowired
    private OidcAuthorizationServiceLocal oidcAuthorizationService;

    public OidcAuthorizationSearchData getSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (basicUser == null) {
            this.checkPermission(Permission.USER_OIDC_AUTHORIZATIONS_VIEW);
        } else {
            this.permission(basicUser).my(new Permission[]{Permission.MY_OIDC_AUTHORIZATIONS_ENABLE}).user(new Permission[]{Permission.USER_OIDC_AUTHORIZATIONS_VIEW}).check();
        }
        return this.oidcAuthorizationService.getSearchData(userLocatorVO);
    }

    public OidcAuthorizationDetailedVO load(@NotNull Long l) throws FrameworkException {
        OidcAuthorization oidcAuthorization = this.check(l, false);
        OidcAuthorizationDetailedVO oidcAuthorizationDetailedVO = this.oidcAuthorizationService.load(l);
        oidcAuthorizationDetailedVO.setCanRevoke(this.permission(oidcAuthorization.getBasicUser()).my(new Permission[]{Permission.MY_OIDC_AUTHORIZATIONS_ENABLE}).user(new Permission[]{Permission.USER_OIDC_AUTHORIZATIONS_MANAGE}).granted());
        return oidcAuthorizationDetailedVO;
    }

    public void revoke(Long l) throws FrameworkException {
        this.check(l, true);
        this.oidcAuthorizationService.revoke(l);
    }

    public Page<OidcAuthorizationVO> search(OidcAuthorizationQuery oidcAuthorizationQuery) throws FrameworkException {
        this.checkQuery(oidcAuthorizationQuery);
        return this.oidcAuthorizationService.search(oidcAuthorizationQuery);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<OidcAuthorization>(OidcAuthorization.class){

            public boolean isVisible(SessionData sessionData, OidcAuthorization oidcAuthorization) {
                BasicUser basicUser = oidcAuthorization.getBasicUser();
                if (basicUser != null) {
                    if (sessionData.getLoggedBasicUser().equals((Object)basicUser) || sessionData.isOwnerOf(basicUser)) {
                        return true;
                    }
                    return sessionData.manages(basicUser) && sessionData.hasPermission(Permission.USER_OIDC_AUTHORIZATIONS_VIEW);
                }
                return false;
            }
        };
    }

    private OidcAuthorization check(Long l, boolean bl) {
        OidcAuthorization oidcAuthorization = this.find(OidcAuthorization.class, l);
        if (oidcAuthorization.getBasicUser() == null) {
            throw new PermissionDeniedException();
        }
        BasicUser basicUser = oidcAuthorization.getBasicUser();
        this.checkManagesUser(basicUser);
        this.permission(basicUser).my(new Permission[]{Permission.MY_OIDC_AUTHORIZATIONS_ENABLE}).user(new Permission[]{bl ? Permission.USER_OIDC_AUTHORIZATIONS_MANAGE : Permission.USER_OIDC_AUTHORIZATIONS_VIEW}).check();
        return oidcAuthorization;
    }

    private void checkQuery(OidcAuthorizationQuery oidcAuthorizationQuery) {
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)oidcAuthorizationQuery.getConsentBy());
        User user = (User)this.conversionHandler.convert(User.class, (Object)oidcAuthorizationQuery.getUser());
        if (basicUser == null) {
            if (sessionData.isUserManager()) {
                if (sessionData.isBroker()) {
                    oidcAuthorizationQuery.setBrokers(CollectionHelper.asSet((Object[])new UserVO[]{new UserVO(sessionData.getLoggedUser().getId())}));
                }
                this.groupsHandler.visibles().accessibles().basic().check((Collection)oidcAuthorizationQuery.getGroups());
            } else if (user == null) {
                basicUser = sessionData.getLoggedUser();
                oidcAuthorizationQuery.setConsentBy((BasicUserVO)new UserVO(sessionData.getLoggedBasicUser().getId()));
                oidcAuthorizationQuery.setGroups(null);
            }
        } else {
            this.checkManagesUser(basicUser);
            oidcAuthorizationQuery.setGroups(null);
        }
        if (basicUser == null && user == null) {
            this.checkPermission(Permission.USER_OIDC_AUTHORIZATIONS_VIEW);
        } else {
            if (basicUser != null) {
                this.permission(basicUser).my(new Permission[]{Permission.MY_OIDC_AUTHORIZATIONS_ENABLE}).user(new Permission[]{Permission.USER_OIDC_AUTHORIZATIONS_VIEW}).check();
            }
            if (user != null) {
                this.permission((BasicUser)user).my(new Permission[]{Permission.MY_OIDC_AUTHORIZATIONS_ENABLE}).user(new Permission[]{Permission.USER_OIDC_AUTHORIZATIONS_VIEW}).check();
            }
        }
        if (CollectionHelper.isNotEmpty((Iterable)oidcAuthorizationQuery.getBrokers())) {
            for (UserVO userVO : oidcAuthorizationQuery.getBrokers()) {
                this.checkRelatesToUser((IUser)userVO);
            }
        }
    }
}

