/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.LoginServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.LoginData;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.login.UserAuthVO;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.access.LoginService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class LoginServiceSecurity
extends BaseServiceSecurity
implements LoginService {
    @Autowired
    private LoginServiceLocal loginService;

    public void confirmLogin(String string) {
        this.checkLoggedIn();
        this.loginService.confirmLogin(string);
    }

    public UserAuthVO getAuthenticatedUser() throws FrameworkException {
        return this.loginService.getAuthenticatedUser();
    }

    public LoginData getLoginData(String string, Long l, PinLocatorVO pinLocatorVO) {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isGuest() && !sessionData.hasPermission(Permission.CONNECTED_USERS_LOGIN)) {
            throw new PermissionDeniedException();
        }
        return this.loginService.getLoginData(string, l, pinLocatorVO);
    }

    public CredentialInputDTO getLoginConfirmationCredentialInput() {
        this.checkLoggedIn();
        return this.loginService.getLoginConfirmationCredentialInput();
    }

    public String replaceSession() throws FrameworkException {
        this.checkLoggedIn();
        return this.loginService.replaceSession();
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

