/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import com.querydsl.core.types.Path;
import java.util.List;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.QProductAccessClient;
import org.cyclos.entities.users.QProductMyAccessClient;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.AccessClientServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.UserManagementProductAccessor;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.model.ActionWithConfirmationPassword;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.clients.AccessClientActionParams;
import org.cyclos.model.access.clients.AccessClientDTO;
import org.cyclos.model.access.clients.AccessClientData;
import org.cyclos.model.access.clients.AccessClientDataParams;
import org.cyclos.model.access.clients.AccessClientDetailedVO;
import org.cyclos.model.access.clients.AccessClientLocatorVO;
import org.cyclos.model.access.clients.AccessClientQuery;
import org.cyclos.model.access.clients.AccessClientTypeData;
import org.cyclos.model.access.clients.AccessClientVO;
import org.cyclos.model.access.clients.AccessClientsActivationData;
import org.cyclos.model.access.clients.AccessClientsListData;
import org.cyclos.model.access.clients.AccessClientsSearchData;
import org.cyclos.model.access.clients.ActivateAccessClientDTO;
import org.cyclos.model.access.clients.CreateAccessClientParams;
import org.cyclos.model.access.passwords.OtpResult;
import org.cyclos.model.access.passwords.SendOtpParams;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.access.AccessClientService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AccessClientServiceSecurity
extends CRUDServiceSecurity<AccessClientDTO, AccessClient, AccessClientData, AccessClientDataParams>
implements AccessClientService {
    private static final QProductAccessClient $ = QProductAccessClient.productAccessClient;
    private static final QProductMyAccessClient my = QProductMyAccessClient.productMyAccessClient;
    @Autowired
    private AccessClientServiceLocal accessClientService;

    public AccessClientServiceSecurity() {
        super(AccessClient.class);
    }

    public ActivateAccessClientDTO activate(String string, String string2) throws FrameworkException {
        this.checkLoggedIn();
        User user = this.getLoggedUser();
        AccessClient accessClient = this.accessClientService.findForActivation(user, string);
        if (!this.doHasAccess(user, accessClient.getType(), (Path<Boolean>)AccessClientServiceSecurity.my.enable)) {
            throw new PermissionDeniedException();
        }
        return this.accessClientService.activate(string, string2);
    }

    public void block(AccessClientActionParams accessClientActionParams) throws FrameworkException {
        this.checkAction(accessClientActionParams, (Path<Boolean>)AccessClientServiceSecurity.$.block);
        this.accessClientService.block(accessClientActionParams);
    }

    public ActivateAccessClientDTO createAndActivate(CreateAccessClientParams createAccessClientParams) {
        AccessClientPrincipalType accessClientPrincipalType = (AccessClientPrincipalType)this.conversionHandler.convert(AccessClientPrincipalType.class, (Object)createAccessClientParams.getType());
        if (!this.doHasAccess(this.getLoggedUser(), accessClientPrincipalType, (Path<Boolean>)AccessClientServiceSecurity.$.activate)) {
            throw new PermissionDeniedException();
        }
        return this.accessClientService.createAndActivate(createAccessClientParams);
    }

    @Override
    public boolean doHasViewAccess(AccessClient accessClient) {
        return this.doHasAccess(accessClient, (Path<Boolean>)AccessClientServiceSecurity.$.view);
    }

    public String getActivationCode(AccessClientActionParams accessClientActionParams) throws FrameworkException {
        this.checkAction(accessClientActionParams, (Path<Boolean>)AccessClientServiceSecurity.$.activate);
        return this.accessClientService.getActivationCode(accessClientActionParams);
    }

    public AccessClientsActivationData getActivationData(ChannelVO channelVO) throws FrameworkException {
        this.checkLoggedIn();
        AccessClientsActivationData accessClientsActivationData = this.accessClientService.getActivationData(channelVO);
        this.ensurePermisisons(accessClientsActivationData.getAccessClientsTypeData(), accessClientPrincipalType -> this.doHasAccess(this.getLoggedUser(), (AccessClientPrincipalType)accessClientPrincipalType, (Path<Boolean>)AccessClientServiceSecurity.$.manage));
        if (accessClientsActivationData.getAccessClientsTypeData().stream().noneMatch(AccessClientTypeData::isCanActivateNew)) {
            accessClientsActivationData.setSendOtpData(null);
        }
        return accessClientsActivationData;
    }

    public AccessClientsListData getListData(PrincipalTypeVO principalTypeVO, UserLocatorVO userLocatorVO) throws FrameworkException {
        AccessClientPrincipalType accessClientPrincipalType = (AccessClientPrincipalType)this.conversionHandler.convert(AccessClientPrincipalType.class, (Object)principalTypeVO);
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (!this.doHasAccess(user, accessClientPrincipalType, (Path<Boolean>)AccessClientServiceSecurity.$.view)) {
            throw new PermissionDeniedException();
        }
        AccessClientsListData accessClientsListData = this.accessClientService.getListData(principalTypeVO, new UserLocatorVO(user.getId()));
        boolean bl = this.doHasAccess(user, accessClientPrincipalType, (Path<Boolean>)AccessClientServiceSecurity.$.manage);
        accessClientsListData.setCanCreateNew(accessClientsListData.isCanCreateNew() && bl);
        accessClientsListData.setCanManage(accessClientsListData.isCanManage() && bl);
        return accessClientsListData;
    }

    public AccessClientsSearchData getSearchData() throws FrameworkException {
        this.checkSearch();
        return this.accessClientService.getSearchData();
    }

    public List<AccessClientTypeData> getTypeData(UserLocatorVO userLocatorVO, ChannelVO channelVO) throws FrameworkException {
        User user = this.checkManagesUser((IUser)userLocatorVO).getUser();
        List list = this.accessClientService.getTypeData(userLocatorVO, channelVO);
        this.ensurePermisisons(list, accessClientPrincipalType -> this.doHasAccess(user, (AccessClientPrincipalType)accessClientPrincipalType, (Path<Boolean>)AccessClientServiceSecurity.$.manage));
        return list;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, AccessClient accessClient) {
        return false;
    }

    public AccessClientVO locate(AccessClientLocatorVO accessClientLocatorVO) throws FrameworkException {
        return this.accessClientService.locate(accessClientLocatorVO);
    }

    public OtpResult requestActivationCode(@NotNull SendOtpParams sendOtpParams) throws FrameworkException {
        this.checkLoggedIn();
        MobilePhone mobilePhone = (MobilePhone)this.conversionHandler.convert(MobilePhone.class, (Object)sendOtpParams.getMobilePhone());
        if (sendOtpParams.getMedium() == SendMedium.SMS && mobilePhone != null && !mobilePhone.getUser().equals((Object)this.getLoggedBasicUser())) {
            throw new PermissionDeniedException();
        }
        return this.accessClientService.requestActivationCode(sendOtpParams);
    }

    public Page<AccessClientDetailedVO> search(AccessClientQuery accessClientQuery) throws FrameworkException {
        AccessClientPrincipalType accessClientPrincipalType = (AccessClientPrincipalType)this.conversionHandler.convert(AccessClientPrincipalType.class, (Object)accessClientQuery.getType());
        User user = (User)this.conversionHandler.convert(User.class, (Object)accessClientQuery.getUser());
        if (accessClientPrincipalType == null || user == null) {
            this.checkSearch();
        } else if (!this.doHasAccess(user, accessClientPrincipalType, (Path<Boolean>)AccessClientServiceSecurity.$.view)) {
            throw new PermissionDeniedException();
        }
        return this.accessClientService.search(accessClientQuery);
    }

    public void unassign(AccessClientActionParams accessClientActionParams) throws FrameworkException {
        this.checkAction(accessClientActionParams, (Path<Boolean>)AccessClientServiceSecurity.$.unassign);
        this.accessClientService.unassign(accessClientActionParams);
    }

    public boolean unassignCurrent(ActionWithConfirmationPassword actionWithConfirmationPassword) throws FrameworkException {
        return this.accessClientService.unassignCurrent(actionWithConfirmationPassword);
    }

    public void unblock(AccessClientActionParams accessClientActionParams) throws FrameworkException {
        this.checkAction(accessClientActionParams, (Path<Boolean>)AccessClientServiceSecurity.$.unblock);
        this.accessClientService.unblock(accessClientActionParams);
    }

    @Override
    protected void checkCreateNew(AccessClientDataParams accessClientDataParams) {
        AccessClientPrincipalType accessClientPrincipalType;
        User user = (User)this.conversionHandler.convert(User.class, (Object)accessClientDataParams.getUser());
        if (!this.doHasAccess(user, accessClientPrincipalType = (AccessClientPrincipalType)this.conversionHandler.convert(AccessClientPrincipalType.class, (Object)accessClientDataParams.getType()), (Path<Boolean>)AccessClientServiceSecurity.$.manage, true)) {
            throw new PermissionDeniedException();
        }
    }

    protected void checkSearch() {
        SessionData sessionData = this.getSessionData();
        UserManagementProductAccessor userManagementProductAccessor = sessionData.getProducts().userManagement();
        if (userManagementProductAccessor.getUserAccessClients().keysSet((Path)AccessClientServiceSecurity.$.view).isEmpty()) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected void customizeData(AccessClientData accessClientData) {
        AccessClient accessClient = (AccessClient)this.conversionHandler.convert(AccessClient.class, (Object)accessClientData.getDto());
        accessClientData.setCanBlock(this.doHasAccess(accessClient, (Path<Boolean>)AccessClientServiceSecurity.$.block) && accessClientData.isCanBlock());
        accessClientData.setCanUnblock(this.doHasAccess(accessClient, (Path<Boolean>)AccessClientServiceSecurity.$.unblock) && accessClientData.isCanUnblock());
        accessClientData.setCanGetActivationCode(this.doHasAccess(accessClient, (Path<Boolean>)AccessClientServiceSecurity.$.activate) && accessClientData.isCanGetActivationCode());
        accessClientData.setCanUnassign(this.doHasAccess(accessClient, (Path<Boolean>)AccessClientServiceSecurity.$.unassign) && accessClientData.isCanUnassign());
    }

    protected boolean doHasAccess(AccessClient accessClient, Path<Boolean> path) {
        return this.doHasAccess(accessClient, path, false);
    }

    protected boolean doHasAccess(AccessClient accessClient, Path<Boolean> path, boolean bl) {
        return this.doHasAccess(accessClient.getUser(), accessClient.getType(), path, bl);
    }

    protected boolean doHasAccess(User user, AccessClientPrincipalType accessClientPrincipalType, Path<Boolean> path) {
        return this.doHasAccess(user, accessClientPrincipalType, path, false);
    }

    protected boolean doHasAccess(User user, AccessClientPrincipalType accessClientPrincipalType, Path<Boolean> path, boolean bl) {
        BooleanPropertiesHolder booleanPropertiesHolder;
        SessionData sessionData = this.getSessionData();
        boolean bl2 = true;
        if (user.equals((Object)sessionData.getLoggedUser())) {
            booleanPropertiesHolder = sessionData.getProducts().product().getMyAccessClients();
        } else {
            if (!sessionData.manages((BasicUser)user)) {
                return false;
            }
            booleanPropertiesHolder = sessionData.getProducts().userManagement().getUserAccessClients();
            bl2 = bl;
        }
        if (bl2 && !this.productsHandler.getAccessor((BasicUser)user).product().getMyAccessClients().isSet((Object)accessClientPrincipalType, (Path)AccessClientServiceSecurity.my.enable)) {
            return false;
        }
        return booleanPropertiesHolder.isSet((Object)accessClientPrincipalType, path);
    }

    @Override
    protected boolean doHasManageAccess(AccessClient accessClient) {
        return this.doHasAccess(accessClient, (Path<Boolean>)AccessClientServiceSecurity.$.manage, accessClient.isTransient());
    }

    @Override
    protected CRUDServiceLocal<AccessClient, AccessClientDTO, AccessClientData, AccessClientDataParams> getImplementation() {
        return this.accessClientService;
    }

    private AccessClient checkAction(AccessClientActionParams accessClientActionParams, Path<Boolean> path) {
        AccessClient accessClient = this.accessClientService.locateAccessClient(accessClientActionParams.getAccessClient());
        if (!this.doHasAccess(accessClient, path)) {
            throw new PermissionDeniedException();
        }
        return accessClient;
    }

    private void ensurePermisisons(List<AccessClientTypeData> list, Function<AccessClientPrincipalType, Boolean> function) {
        for (AccessClientTypeData accessClientTypeData : list) {
            AccessClientPrincipalType accessClientPrincipalType = (AccessClientPrincipalType)this.conversionHandler.convert(AccessClientPrincipalType.class, (Object)accessClientTypeData.getType());
            Boolean bl = function.apply(accessClientPrincipalType);
            accessClientTypeData.setCanCreateNew(accessClientTypeData.isCanCreateNew() && bl != false);
            accessClientTypeData.setCanActivateNew(accessClientTypeData.isCanActivateNew() && bl != false);
            accessClientTypeData.setCanManage(accessClientTypeData.isCanManage() && bl != false);
        }
    }
}

