/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Predicate;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataSubjectId;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.DataAccessException;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityData;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.users.products.ViewManageOperation;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.system.EntityLogServiceSecurity;
import org.cyclos.services.CRUDWithConfirmationPasswordService;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CRUDServiceSecurity<DTO extends EntityDTO, E extends SimpleEntity, D extends EntityData<DTO>, DP>
extends BaseServiceSecurity
implements CRUDWithConfirmationPasswordService<DTO, D, DP> {
    protected final Class<E> entityClass;
    @Autowired
    private EntityLogServiceSecurity entityLogServiceSecurity;

    public CRUDServiceSecurity(Class<E> clazz) {
        this.entityClass = clazz;
    }

    public boolean canPerformOperation(E e, CRUDOperation cRUDOperation) {
        if (cRUDOperation == CRUDOperation.READ) {
            return this.hasViewAccess(e);
        }
        return this.hasManageAccess(e);
    }

    public boolean canViewData(E e) {
        return this.doHasViewAccess(e);
    }

    public final void checkManageAccess(E e) throws PermissionDeniedException {
        if (!this.hasManageAccess(e)) {
            throw new PermissionDeniedException();
        }
    }

    public final void checkOperation(E e, CRUDOperation cRUDOperation) {
        if (!this.canPerformOperation(e, cRUDOperation)) {
            throw new PermissionDeniedException();
        }
    }

    public final void checkViewAccess(E e) throws PermissionDeniedException {
        if (!this.hasViewAccess(e)) {
            throw new PermissionDeniedException();
        }
    }

    public abstract boolean doHasViewAccess(E var1);

    public <Entity extends E> Entity find(Long l) {
        return (Entity)this.find(this.entityClass, l);
    }

    public final CredentialInputDTO getConfirmationPasswordInputForRemove(Long l) throws FrameworkException {
        this.checkOperation(this.find(l), CRUDOperation.DELETE);
        return this.getImplementationWithConfirmationPassword().getConfirmationPasswordInputForRemove(l);
    }

    public final D getData(Long l) throws FrameworkException {
        Object Entity = this.find(l);
        if (!this.canViewData(Entity)) {
            throw new PermissionDeniedException();
        }
        EntityData entityData = this.getImplementation().getData(l);
        entityData.setEditable(this.canPerformOperation(Entity, CRUDOperation.UPDATE));
        entityData.setRemovable(this.canPerformOperation(Entity, CRUDOperation.DELETE));
        entityData.setCanViewHistoryLog(this.entityLogServiceSecurity.canViewEntityLog((SimpleEntity)Entity));
        this.customizeData(entityData);
        return (D)entityData;
    }

    public final D getDataForNew(DP DP) throws FrameworkException {
        this.checkCreateNew(DP);
        EntityData entityData = this.getImplementation().getDataForNew(DP);
        entityData.setEditable(true);
        entityData.setRemovable(false);
        Long l = entityData.getDto().getId();
        if (l != null) {
            Object Entity = this.find(l);
            entityData.setCanViewHistoryLog(this.entityLogServiceSecurity.canViewEntityLog((SimpleEntity)Entity));
        }
        this.customizeData(entityData);
        return (D)entityData;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public final boolean hasManageAccess(E e) {
        return this.hasAccess(e, ViewManageOperation.MANAGE, this::doHasManageAccess);
    }

    public final boolean hasViewAccess(E e) {
        return this.hasAccess(e, ViewManageOperation.VIEW, this::doHasViewAccess);
    }

    public abstract boolean isAccessible(SessionData var1, E var2);

    public final DTO load(Long l) throws EntityNotFoundException {
        this.checkOperation(this.find(l), CRUDOperation.READ);
        return (DTO)this.getImplementation().load(l);
    }

    public final void remove(Long l) throws EntityNotFoundException, DataAccessException, ValidationException {
        this.checkOperation(this.find(l), CRUDOperation.DELETE);
        this.getImplementation().remove(l);
    }

    public final void removeAll(Collection<Long> collection) throws EntityNotFoundException, DataAccessException, ValidationException {
        if (CollectionHelper.isNotEmpty(collection)) {
            for (Long l : collection) {
                this.checkOperation(this.find(l), CRUDOperation.DELETE);
            }
            this.getImplementation().removeAll(collection);
        }
    }

    public final void removeAllWithConfirmationPassword(Collection<Long> collection, String string) throws EntityNotFoundException, DataAccessException, ValidationException {
        if (CollectionHelper.isNotEmpty(collection)) {
            for (Long l : collection) {
                this.checkOperation(this.find(l), CRUDOperation.DELETE);
            }
            this.getImplementationWithConfirmationPassword().removeAllWithConfirmationPassword(collection, string);
        }
    }

    public final void removeWithConfirmationPassword(Long l, String string) throws FrameworkException {
        this.checkOperation(this.find(l), CRUDOperation.DELETE);
        this.getImplementationWithConfirmationPassword().removeWithConfirmationPassword(l, string);
    }

    public final Long save(DTO DTO) throws ValidationException, DataAccessException {
        this.checkSave(DTO);
        return this.getImplementation().save(DTO);
    }

    public final Long saveWithConfirmationPassword(DTO DTO, String string) throws FrameworkException {
        this.checkSave(DTO);
        return this.getImplementationWithConfirmationPassword().saveWithConfirmationPassword(DTO, string);
    }

    protected abstract void checkCreateNew(DP var1);

    protected void checkSave(DTO DTO) {
        CRUDOperation cRUDOperation;
        Object object;
        if (DTO == null) {
            throw new EntityNotFoundException();
        }
        this.getImplementation().validate(DTO);
        if (DTO.isTransient()) {
            object = this.getImplementation().toEntity(DTO);
            if (object instanceof DefinesNetwork) {
                ((DefinesNetwork)object).setNetwork(this.getSessionData().getNetwork());
            }
            this.entityManagerHandler.clear();
            cRUDOperation = CRUDOperation.CREATE;
        } else {
            object = this.find(DTO.getId());
            cRUDOperation = CRUDOperation.UPDATE;
        }
        this.checkOperation(object, cRUDOperation);
        this.onBeforeSave(DTO, object);
    }

    protected void customizeData(D d) {
    }

    protected abstract boolean doHasManageAccess(E var1);

    protected abstract CRUDServiceLocal<E, DTO, D, DP> getImplementation();

    protected void onBeforeSave(DTO DTO, E e) {
    }

    protected final EntityCheck<E> resolveEntityCheck() {
        boolean bl;
        boolean bl2 = ConfigurationEntity.class.isAssignableFrom(this.entityClass);
        if (bl2 ^ (bl = this instanceof ConfigurationEntityCRUDServiceSecurity)) {
            throw new IllegalStateException();
        }
        if (bl2) {
            return null;
        }
        return new BaseEntityCheck<E>(this.entityClass){

            public boolean isVisible(SessionData sessionData, E e) {
                return CRUDServiceSecurity.this.hasViewAccess(e) || CRUDServiceSecurity.this.isAccessible(sessionData, e);
            }
        };
    }

    private CRUDWithConfirmationPasswordService<DTO, D, DP> getImplementationWithConfirmationPassword() {
        CRUDWithConfirmationPasswordService cRUDWithConfirmationPasswordService = (CRUDWithConfirmationPasswordService)this.getImplementation();
        return cRUDWithConfirmationPasswordService;
    }

    private boolean hasAccess(E e, ViewManageOperation viewManageOperation, Predicate<E> predicate) {
        InvocationContext invocationContext = InvocationContext.get();
        SessionData sessionData = invocationContext.sessionData();
        if (sessionData.isSystem()) {
            return true;
        }
        if (e == null) {
            return false;
        }
        AccessKey accessKey = new AccessKey(sessionData.getSubjectId(), viewManageOperation, this.entityClass, e.getId());
        Boolean bl = (Boolean)invocationContext.getAttribute((Object)accessKey, () -> {
            boolean bl;
            if (e instanceof BaseEntity) {
                BaseEntity baseEntity = (BaseEntity)e;
                bl = viewManageOperation == ViewManageOperation.VIEW ? this.inSameNetworkOrGlobal((NetworkedEntity)baseEntity) : this.inSameNetwork((NetworkedEntity)baseEntity);
            } else {
                bl = true;
            }
            return bl &= predicate.test(e);
        });
        return Boolean.TRUE.equals(bl);
    }

    private static class AccessKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final SessionDataSubjectId subjectId;
        private final ViewManageOperation operation;
        private final Class<? extends SimpleEntity> entityClass;
        private final Long entityId;

        public AccessKey(SessionDataSubjectId sessionDataSubjectId, ViewManageOperation viewManageOperation, Class<? extends SimpleEntity> clazz, Long l) {
            this.subjectId = sessionDataSubjectId;
            this.operation = viewManageOperation;
            this.entityClass = clazz;
            this.entityId = l;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AccessKey accessKey = (AccessKey)object;
            if (this.entityClass == null ? accessKey.entityClass != null : !this.entityClass.equals(accessKey.entityClass)) {
                return false;
            }
            if (this.entityId == null ? accessKey.entityId != null : !this.entityId.equals(accessKey.entityId)) {
                return false;
            }
            if (this.operation != accessKey.operation) {
                return false;
            }
            return !(this.subjectId == null ? accessKey.subjectId != null : !this.subjectId.equals((Object)accessKey.subjectId));
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.entityClass == null ? 0 : this.entityClass.hashCode());
            n = 31 * n + (this.entityId == null ? 0 : this.entityId.hashCode());
            n = 31 * n + (this.operation == null ? 0 : this.operation.hashCode());
            n = 31 * n + (this.subjectId == null ? 0 : this.subjectId.hashCode());
            return n;
        }

        public String toString() {
            return String.valueOf(this.operation) + " by " + String.valueOf(this.subjectId) + " on " + this.entityClass.getSimpleName() + "#" + this.entityId;
        }
    }
}

