/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.impl.utils.validation.validations.RangeOptionalType;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.model.utils.IntegerRangeDTO;

public class RangeValidation
extends BasePropertyValidation {
    private RangeOptionalType type;

    public RangeValidation(RangeOptionalType rangeOptionalType) {
        super(ValidationErrors.range(rangeOptionalType));
        this.type = rangeOptionalType;
    }

    @Override
    protected boolean isValid(Object object, Object object2, Object object3) {
        if (object3 == null) {
            return true;
        }
        Number number = null;
        Number number2 = null;
        if (object3 instanceof IntegerRangeDTO) {
            number = ((IntegerRangeDTO)object3).getMin();
            number2 = ((IntegerRangeDTO)object3).getMax();
        } else if (object3 instanceof DecimalRangeDTO) {
            number = ((DecimalRangeDTO)object3).getMin();
            number2 = ((DecimalRangeDTO)object3).getMax();
        }
        if (this.type == RangeOptionalType.BOTH_REQUIRED && (number == null || number2 == null)) {
            return false;
        }
        if (this.type == RangeOptionalType.ONE_REQUIRED && number == null && number2 == null) {
            return false;
        }
        if (number == null || number2 == null) {
            return true;
        }
        return number.compareTo(number2) <= 0;
    }
}

