/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import java.util.Collection;
import java.util.Map;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;

public class MaxElementsValidation
extends BasePropertyValidation {
    private int length;

    MaxElementsValidation(int n) {
        super(ValidationErrors.maxElements(n));
        this.length = n;
    }

    @Override
    protected boolean isValid(Object object, Object object2, Object object3) {
        if (this.length < 0) {
            return true;
        }
        int n = Integer.MAX_VALUE;
        if (object3 instanceof Collection) {
            n = ((Collection)object3).size();
        } else if (object3 instanceof Map) {
            n = ((Map)object3).size();
        } else if (object3 instanceof Object[]) {
            n = ((Object[])object3).length;
        }
        return n <= this.length;
    }
}

