/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.StringHelper;

public class MaskValidation
implements PropertyValidation {
    private final int minimumPlaceholders;

    public MaskValidation(int n) {
        this.minimumPlaceholders = n;
    }

    @Override
    public ValidationError validate(Object object, Object object2, Object object3) {
        int n;
        String string = (String)object3;
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        if (!MaskHelper.isValidMask((String)string)) {
            return ValidationErrors.invalid();
        }
        if (this.minimumPlaceholders > 0 && (n = MaskHelper.countPlaceholders((String)string)) < this.minimumPlaceholders) {
            return ValidationErrors.minMaskPlaceholders(this.minimumPlaceholders);
        }
        return null;
    }
}

