/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.system.CaptchaServiceLocal;
import org.cyclos.impl.utils.validation.GeneralValidation;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CaptchaResponseDTO;
import org.cyclos.utils.StringHelper;

public class CaptchaValidation
implements PropertyValidation,
GeneralValidation {
    private final CaptchaConfiguration configuration;

    public CaptchaValidation(CaptchaConfiguration captchaConfiguration) {
        this.configuration = captchaConfiguration;
    }

    @Override
    public ValidationError validate(Object object) {
        return this.doValidate((CaptchaResponseDTO)object, true);
    }

    @Override
    public ValidationError validate(Object object, Object object2, Object object3) {
        return this.doValidate((CaptchaResponseDTO)object3, false);
    }

    private ValidationError doValidate(CaptchaResponseDTO captchaResponseDTO, boolean bl) {
        String string;
        String string2;
        String string3 = string2 = captchaResponseDTO == null ? null : StringHelper.trimToNull((Object)captchaResponseDTO.getChallenge());
        if (this.configuration.getProvider().hasChallenge() && string2 == null) {
            return ValidationErrors.required();
        }
        String string4 = string = captchaResponseDTO == null ? null : StringHelper.trimToNull((Object)captchaResponseDTO.getResponse());
        if (string == null) {
            return ValidationErrors.required();
        }
        boolean bl2 = InvocationContext.bean(CaptchaServiceLocal.class).verify(this.configuration, captchaResponseDTO);
        if (bl2) {
            return null;
        }
        if (bl) {
            TranslationHandler translationHandler = InvocationContext.bean(TranslationHandler.class);
            String string5 = translationHandler.message(AccessKeys.Passwords.CAPTCHA, new Object[0]);
            return ValidationErrors.invalid(string5);
        }
        return ValidationErrors.invalid();
    }
}

