/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.utils.MessageKey;

public abstract class BaseEntityValidation<E extends SimpleEntity>
implements EntityValidation<E> {
    protected final ValidationError error;

    public BaseEntityValidation() {
        this(null);
    }

    public BaseEntityValidation(MessageKey messageKey, Object ... objectArray) {
        this(new ValidationError(messageKey, objectArray));
    }

    public BaseEntityValidation(ValidationError validationError) {
        this.error = validationError == null ? ValidationErrors.invalid() : validationError;
    }

    @Override
    public final ValidationError validate(Object object, Object object2, E e) {
        if (this.isValid(object, object2, e)) {
            return null;
        }
        return this.error;
    }

    protected EntityManagerHandler getEntityManagerHandler() {
        return InvocationContext.bean(EntityManagerHandler.class);
    }

    protected abstract boolean isValid(Object var1, Object var2, E var3);
}

