/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Table;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.model.IEntity;
import org.springframework.core.annotation.AnnotationUtils;

public final class NotificationProcessingEntityType<E extends SimpleEntity> {
    public static final NotificationProcessingEntityType<Transaction> TRANSACTION = new NotificationProcessingEntityType<Transaction>("TRANSACTION", Transaction.class);
    public static final NotificationProcessingEntityType<Transfer> TRANSFER = new NotificationProcessingEntityType<Transfer>("TRANSFER", Transfer.class);
    public static final Map<String, NotificationProcessingEntityType<? extends SimpleEntity>> VALUES = new HashMap<String, NotificationProcessingEntityType<? extends SimpleEntity>>();
    private String name;
    private String tableName;
    private Class<E> entityClass;

    public static NotificationProcessingEntityType<? extends SimpleEntity> valueOf(String string) {
        if (string == null) {
            throw new NullPointerException("Name is null!");
        }
        NotificationProcessingEntityType<? extends SimpleEntity> notificationProcessingEntityType = VALUES.get(string);
        if (notificationProcessingEntityType == null) {
            throw new IllegalArgumentException("Unknown notification processing entity type: " + string);
        }
        return notificationProcessingEntityType;
    }

    public static Iterable<NotificationProcessingEntityType<? extends IEntity>> values() {
        return () -> Iterators.unmodifiableIterator(VALUES.values().iterator());
    }

    private NotificationProcessingEntityType(String string, Class<E> clazz) {
        this.name = string;
        this.entityClass = clazz;
        Table table = (Table)AnnotationUtils.findAnnotation(clazz, Table.class);
        if (table == null) {
            throw new IllegalStateException("Missing annotation from entity class: " + String.valueOf(clazz));
        }
        this.tableName = table.name();
    }

    public Class<E> entityClass() {
        return this.entityClass;
    }

    public String name() {
        return this.name;
    }

    public String tableName() {
        return this.tableName;
    }

    public String toString() {
        return "NotificationProcessingEntityType [name=" + this.name + "]";
    }

    static {
        VALUES.put(TRANSACTION.name(), TRANSACTION);
        VALUES.put(TRANSFER.name(), TRANSFER);
    }
}

