/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.messaging.IncomingMessage;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.ThemeServiceLocal;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.notifications.MailContent;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.themes.ThemeDefinition;
import org.cyclos.utils.ColorHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.MessageProducer;

@FunctionalInterface
public interface MailContentProducer {
    public static MailContentBuilder builder(MessageProducer messageProducer) {
        return new MailContentBuilder(messageProducer);
    }

    public MailContent mailContent();

    public static class MailContentBuilder
    implements MailContentProducer {
        private MessageProducer messageProducer;
        private MessageKey subjectKey;
        private Object[] subjectArgs;
        private MessageKey bodyKey;
        private Object[] bodyArgs;
        private IncomingMessage replyTo;

        private MailContentBuilder(MessageProducer messageProducer) {
            this.messageProducer = messageProducer;
        }

        public MailContentBuilder body(MessageKey messageKey, Object ... objectArray) {
            this.bodyKey = messageKey;
            this.bodyArgs = objectArray;
            return this;
        }

        @Override
        public MailContent mailContent() {
            String string = this.messageProducer.message(MessageFormat.PLAIN, this.subjectKey, this.subjectArgs);
            Object object = this.messageProducer.message(MessageFormat.HTML, this.bodyKey, this.bodyArgs);
            if (this.replyTo != null) {
                InvocationContext invocationContext = InvocationContext.ensure();
                ThemeServiceLocal themeServiceLocal = (ThemeServiceLocal)invocationContext.applicationContext().getBean(ThemeServiceLocal.class);
                Theme theme = invocationContext.sessionData().getConfiguration().getAppTheme();
                int[] nArray = ColorHelper.parse((String)themeServiceLocal.getDefinition(theme, ThemeDefinition.APP_ACCENT));
                String string2 = ColorHelper.formatRGBasHex((int[])nArray);
                String string3 = ColorHelper.formatRGBasHex((int[])ColorHelper.colorYiq((int[])nArray));
                int[] nArray2 = ColorHelper.fromRGBtoHSV((int[])nArray);
                nArray2[2] = (int)((double)nArray2[2] * 0.8);
                String string4 = ColorHelper.formatRGBasHex((int[])ColorHelper.fromHSVtoRGB((int[])nArray2));
                LinkGeneratorHandler linkGeneratorHandler = (LinkGeneratorHandler)invocationContext.applicationContext().getBean(LinkGeneratorHandler.class);
                object = (String)object + "<br><br><a href='" + linkGeneratorHandler.replyMessage(this.replyTo) + "' style='display: inline-block;text-decoration: none !important;background-color: " + string2 + ";color: " + string3 + ";border: 1px solid " + string4 + ";border-radius: 4px;padding: 10px 24px;'>" + this.messageProducer.message(ContentManagementKeys.Emails.FORWARD_INTERNAL_MESSAGE_REPLY_TO, new Object[0]) + "</a>";
            }
            return new MailContent(string, (String)object);
        }

        public MailContentBuilder replyTo(IncomingMessage incomingMessage) {
            this.replyTo = incomingMessage;
            return this;
        }

        public MailContentBuilder subject(MessageKey messageKey, Object ... objectArray) {
            this.subjectKey = messageKey;
            this.subjectArgs = objectArray;
            return this;
        }
    }
}

