/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.formatting;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.access.NFCToken;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountLocator;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.users.Address;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.LandLinePhone;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.QuickAccess;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.utils.CurrencyAmountRange;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.formatting.DataTranslationProxy;
import org.cyclos.impl.utils.formatting.Formattable;
import org.cyclos.impl.utils.formatting.FormattedDate;
import org.cyclos.impl.utils.formatting.ShortFormat;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.model.IEntity;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.currencies.ICurrency;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.languages.TimeFormat;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.utils.AbstractFormatter;
import org.cyclos.model.utils.DateWrapper;
import org.cyclos.model.utils.ICurrencyAmountRange;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.AddressHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.cyclos.utils.coercion.CoercionException;
import org.springframework.beans.factory.annotation.Autowired;

public class FormatterImpl
extends AbstractFormatter {
    private static final int NUMBER_GROUP_SIZE = 3;
    private final ConfigurationAccessor configuration;
    @Autowired
    private TranslationHandler translationHandler;
    @Autowired
    private DataTranslationHandler dataTranslationHandler;
    @Autowired
    private AccountHandler accountHandler;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private ConversionHandler conversionHandler;
    @Autowired
    private EntityManagerHandler entityManagerHandler;
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    private LocalizationServiceLocal localizationService;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    private DateFormat dateFormat;
    private DateFormat dateTimeFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private NumberFormat variableNumberFormat;
    private NumberFormat[] numberFormats;

    private static DecimalFormatSymbols getDecimalSymbols(org.cyclos.model.system.languages.NumberFormat numberFormat) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        decimalFormatSymbols.setDecimalSeparator(numberFormat.getDecimalSeparator());
        decimalFormatSymbols.setGroupingSeparator(numberFormat.getGroupingSeparator());
        return decimalFormatSymbols;
    }

    private static String getNumberPattern(int n) {
        Object object = "#,##0";
        if (n == 0) {
            return object;
        }
        object = (String)object + ".";
        if (n == -1) {
            object = (String)object + StringHelper.repeat((String)"#", (int)BigDecimalHelper.MAX_SCALE);
        } else {
            for (int i = 0; i < n; ++i) {
                object = (String)object + "0";
            }
        }
        return object;
    }

    public FormatterImpl(ConfigurationAccessor configurationAccessor) {
        this.configuration = configurationAccessor;
    }

    public String format(Account account) {
        if (account == null) {
            return "";
        }
        String string = this.accountHandler.getAccountNumber((IAccount)account);
        String string2 = this.dataTranslationHandler.getName((NamedEntity)account.getType());
        return StringHelper.isBlank((Object)string) ? string2 : string2 + " - " + string;
    }

    public String format(AccountLocator accountLocator) {
        if (accountLocator == null) {
            return "";
        }
        if (accountLocator.getOwner() instanceof SystemAccountOwner) {
            return this.dataTranslationHandler.getName((NamedEntity)accountLocator.getType());
        }
        return this.format((AccountOwner)accountLocator.getOwner());
    }

    public String format(Address address) {
        if (address == null) {
            return "";
        }
        String string = AddressHelper.format((IAddress)address);
        if (StringHelper.isBlank((Object)string) && StringHelper.isNotBlank((Object)address.getCountry())) {
            return this.localizationService.getCountryName(address.getCountry());
        }
        return string;
    }

    public String format(BasicUser basicUser) {
        String string;
        if (basicUser == null) {
            return "";
        }
        String string2 = string = InvocationContext.getSessionData().manages(basicUser) ? basicUser.getDisplayForManagers() : basicUser.getDisplayForOthers();
        if (StringHelper.isBlank((Object)string)) {
            string = this.translationHandler.message(GeneralKeys.Ui.USER, new Object[0]);
        }
        return string;
    }

    public String format(BigDecimal bigDecimal, int n) {
        if (bigDecimal == null) {
            return "";
        }
        double d = bigDecimal.doubleValue();
        return this.fixSignIfZero(this.getNumberFormatForScale(n).format(d));
    }

    public String format(CustomFieldValue<?, ?, ?, ?> customFieldValue) {
        if (customFieldValue == null) {
            return "";
        }
        CustomField customField = customFieldValue.getField();
        Object object = this.customFieldValueHandler.getValue(customField, customFieldValue, false);
        switch (customField.getType()) {
            case DATE: {
                return this.formatAsDate((Date)object);
            }
            case DECIMAL: {
                int n = (Integer)ObjectHelper.defaultValue((Object)customField.getDecimalDigits(), (Object)2);
                return this.format((BigDecimal)object, n);
            }
        }
        return this.format(object);
    }

    public String format(Date date) {
        if (date == null) {
            return "";
        }
        return this.getDateTimeFormat().format(date);
    }

    public String format(DatePeriod datePeriod) {
        if (datePeriod == null) {
            return "";
        }
        return this.formatPeriod(this.formatAsDate(datePeriod.getBegin()), this.formatAsDate(datePeriod.getEnd()));
    }

    public String format(DecimalRange decimalRange) {
        if (decimalRange == null) {
            return "";
        }
        return this.formatRange(this.format(decimalRange.getMin()), this.format(decimalRange.getMax()));
    }

    public String format(FormattedDate formattedDate) {
        Date date = formattedDate.getDate();
        if (date != null) {
            switch (formattedDate.getFormat()) {
                case DATE: {
                    return this.formatAsDate(date);
                }
                case DATE_DIFF: {
                    return this.formatAsDiff(date);
                }
                case DATE_TIME: {
                    return this.format(date);
                }
            }
        }
        return "";
    }

    public String format(ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue) {
        if (iCustomFieldValue instanceof CustomFieldValue) {
            CustomFieldValue customFieldValue = (CustomFieldValue)iCustomFieldValue;
            return this.format(customFieldValue);
        }
        return super.format(iCustomFieldValue);
    }

    public String format(IDate iDate) {
        if (iDate == null) {
            return "";
        }
        DateTime dateTime = this.getConversionHandler().convert(DateTime.class, iDate);
        return this.formatAsDate(dateTime) + " " + this.formatAsTime(dateTime);
    }

    public String format(INamedEntity iNamedEntity) {
        NamedEntity namedEntity;
        DataTranslationType dataTranslationType;
        if (iNamedEntity instanceof NamedEntity && (dataTranslationType = (namedEntity = (NamedEntity)iNamedEntity).getDataTranslationType()) != null) {
            return this.dataTranslationHandler.getName(namedEntity);
        }
        return super.format(iNamedEntity);
    }

    public String format(IntegerRange integerRange) {
        if (integerRange == null) {
            return "";
        }
        return this.formatRange(this.format(integerRange.getMin()), this.format(integerRange.getMax()));
    }

    public String format(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Formattable) {
            return ((Formattable)object).format(this);
        }
        if (object instanceof ProcessableForProxying) {
            object = DataTranslationProxy.proxy((ProcessableForProxying)object, this.getDataTranslationHandler(), this.getConfiguration().getLanguage());
        }
        if (object instanceof Phone) {
            return this.format((Phone)object);
        }
        if (object instanceof Address) {
            return this.format((Address)object);
        }
        if (object instanceof BasicUser) {
            return this.format((BasicUser)object);
        }
        if (object instanceof ShortFormat) {
            return this.format((ShortFormat)object);
        }
        if (object instanceof Account) {
            return this.format((Account)object);
        }
        if (object instanceof Token) {
            return this.format((Token)object);
        }
        if (object instanceof CustomFieldValue) {
            return this.format((CustomFieldValue)object);
        }
        if (object instanceof Date) {
            return this.format((Date)object);
        }
        if (object instanceof FormattedDate) {
            return this.format((FormattedDate)object);
        }
        if (object instanceof DateWrapper) {
            return this.format(((DateWrapper)object).getDate());
        }
        if (object instanceof DatePeriod) {
            return this.format((DatePeriod)object);
        }
        if (object instanceof IntegerRange) {
            return this.format((IntegerRange)object);
        }
        if (object instanceof DecimalRange) {
            return this.format((DecimalRange)object);
        }
        if (object instanceof CurrencyAmountRange) {
            return this.format((ICurrencyAmountRange)((CurrencyAmountRange)object));
        }
        if (object instanceof Record) {
            return this.format((Record)object);
        }
        if (object instanceof Trans) {
            return this.format((Trans)object);
        }
        if (object instanceof AccountLocator) {
            return this.format((AccountLocator)object);
        }
        if (object instanceof QuickAccess) {
            return this.format((QuickAccess)object);
        }
        return super.format(object);
    }

    public String format(Phone phone) {
        return this.format(phone, true);
    }

    public String format(Phone phone, boolean bl) {
        PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.toDescriptor(phone);
        if (phoneNumberDescriptor == null) {
            return "";
        }
        Object object = this.phoneNumberHandler.format(phoneNumberDescriptor, this.configuration);
        if (bl) {
            String string = null;
            if (phone.getNature() == PhoneNature.LANDLINE) {
                string = StringHelper.trimToNull((Object)((LandLinePhone)phone).getExtension());
            }
            if (string != null) {
                object = (String)object + " " + this.message(GeneralKeys.Ui.PHONE_EXTENSION_PREFIX, new Object[0]) + " " + string;
            }
        }
        return object;
    }

    public String format(QuickAccess quickAccess) {
        if (quickAccess == null) {
            return "";
        }
        ConfigurationEntity configurationEntity = quickAccess.getEntity();
        if (configurationEntity == null) {
            return this.format((HasMessageKey)quickAccess.getType());
        }
        return this.format(new TranslationMessageSpecification(GeneralKeys.Ui.LABEL_VALUE, new Object[]{quickAccess.getType(), configurationEntity}));
    }

    public String format(Record record) {
        if (record == null || record.getType() == null) {
            return "";
        }
        String string2 = (String)ObjectHelper.defaultValue((Object)record.getType().getDisplayTemplate(), (Object)"{type} ({id})");
        return StringHelper.replaceVariables((String)string2, string -> {
            switch (string) {
                case "id": {
                    return this.formatId((IEntity)record);
                }
                case "type": {
                    return this.dataTranslationHandler.getName((NamedEntity)record.getType());
                }
                case "user": {
                    if (record instanceof UserRecord) {
                        return this.format((BasicUser)((UserRecord)record).getUser());
                    }
                    return null;
                }
                case "creationDate": {
                    return this.formatAsDate(record.getCreationDate());
                }
                case "createdBy": {
                    return this.format((BasicUser)record.getCreatedBy());
                }
            }
            return this.customFieldVariable((String)string, record.getCustomValues());
        });
    }

    public String format(ShortFormat shortFormat) {
        Object object;
        Object object2 = object = shortFormat == null ? null : shortFormat.getValue();
        if (object == null) {
            return "";
        }
        if (object instanceof Date) {
            return this.formatShort((Date)object);
        }
        return this.format(object);
    }

    public String format(Token token) {
        TokenPrincipalType tokenPrincipalType = token.getType();
        String string = tokenPrincipalType.getTokenMask();
        if (token instanceof NFCToken) {
            NFCToken nFCToken = (NFCToken)token;
            return (String)ObjectHelper.defaultValue((Object)nFCToken.getLabel(), (Object)"NFC");
        }
        return MaskHelper.applyMask((String)string, (String)token.getValue());
    }

    public String format(Trans trans) {
        Currency currency;
        if (trans == null) {
            return "";
        }
        TransferType transferType = trans.getType();
        String string2 = transferType.getDisplayTemplate();
        if (StringHelper.isBlank((Object)string2) && StringHelper.isBlank((Object)(string2 = (currency = trans.getCurrency()).getDisplayTemplate()))) {
            if (StringHelper.isNotBlank((Object)trans.getTransactionNumber())) {
                return trans.getTransactionNumber();
            }
            return this.formatId((IEntity)trans);
        }
        return StringHelper.replaceVariables((String)string2, string -> {
            switch (string) {
                case "id": {
                    return this.formatId((IEntity)trans);
                }
                case "type": {
                    return this.dataTranslationHandler.getName((NamedEntity)trans.getType());
                }
                case "from": {
                    return this.format(trans.getFrom());
                }
                case "fromOwner": {
                    return this.format((AccountOwner)trans.getFromOwner());
                }
                case "to": {
                    return this.format(trans.getTo());
                }
                case "toOwner": {
                    return this.format(trans.getToOwner());
                }
                case "date": {
                    return this.formatAsDate(trans.getDate());
                }
                case "amount": {
                    return this.format((ICurrency)trans.getCurrency(), trans.getAmount());
                }
                case "transactionNumber": {
                    return trans.getTransactionNumber();
                }
                case "channel": {
                    return this.dataTranslationHandler.getName((NamedEntity)trans.getChannel());
                }
            }
            return this.customFieldVariable((String)string, trans.getCustomValues());
        });
    }

    public String formatAsDate(Date date) {
        if (date == null) {
            return "";
        }
        return this.getDateFormat().format(date);
    }

    public String formatAsDate(IDate iDate) {
        if (iDate == null) {
            return "";
        }
        if (iDate instanceof DateTime) {
            return this.formatAsDate((DateTime)iDate);
        }
        if (iDate instanceof DateWrapper) {
            return this.formatAsDate(((DateWrapper)iDate).getDate());
        }
        throw new IllegalArgumentException("Can't format as date. Unsupported IDate implementation: " + iDate.getClass().getName());
    }

    public String formatAsDiff(Date date) {
        if (date == null) {
            return "";
        }
        Double d = DateHelper.daysBetween((Date)DateHelper.now(), (Date)date);
        if (d.intValue() < 0) {
            return this.formatAsDate(date);
        }
        if (d.intValue() == 0) {
            return this.format(date);
        }
        String string = this.message(d.intValue() == 1 ? GeneralKeys.Ui.TIME_FIELD_SINGULAR_DAYS : GeneralKeys.Ui.TIME_FIELD_PLURAL_DAYS, new Object[0]);
        return this.formatAsDate(date) + " (" + d.intValue() + " " + string.toLowerCase() + ")";
    }

    public String formatAsTime(Date date) {
        if (date == null) {
            return "";
        }
        return this.getTimeFormat().format(date);
    }

    public String formatAsTime(IDate iDate) {
        if (iDate == null) {
            return "";
        }
        if (iDate instanceof DateTime) {
            return this.formatAsTime((DateTime)iDate);
        }
        if (iDate instanceof DateWrapper) {
            return this.formatAsTime(((DateWrapper)iDate).getDate());
        }
        throw new IllegalArgumentException("Can't format as time. Unsupported IDate implementation: " + iDate.getClass().getName());
    }

    public String formatAsTimestamp(Date date) {
        if (date == null) {
            return "";
        }
        return this.getTimestampFormat().format(date);
    }

    public String formatAsTimestamp(IDate iDate) {
        if (iDate == null) {
            return "";
        }
        if (iDate instanceof DateTime) {
            return this.formatAsTimestamp((DateTime)iDate);
        }
        if (iDate instanceof DateWrapper) {
            return this.formatAsTimestamp(((DateWrapper)iDate).getDate());
        }
        throw new IllegalArgumentException("Can't format as timestamp. Unsupported IDate implementation: " + iDate.getClass().getName());
    }

    public String formatId(IEntity iEntity) {
        Long l;
        Long l2 = l = iEntity == null ? null : iEntity.getId();
        if (l == null) {
            return "";
        }
        l = this.applicationHandler.getIdMask().apply(l);
        return l.toString();
    }

    public String formatShort(Date date) {
        if (DateHelper.isLessThanOneDayGap((Date)DateHelper.now(), (Date)date)) {
            return this.formatAsTime(date);
        }
        return this.format(date);
    }

    public Calendar getCalendar() {
        return Calendar.getInstance(this.configuration.getTimeZone());
    }

    public ConfigurationAccessor getConfiguration() {
        return this.configuration;
    }

    public ConversionHandler getConversionHandler() {
        return this.conversionHandler;
    }

    public CyclosProperties getCyclosProperties() {
        return this.cyclosProperties;
    }

    public DataTranslationHandler getDataTranslationHandler() {
        return this.dataTranslationHandler;
    }

    public String getDatePattern() {
        return this.configuration.getDateFormat().getPattern();
    }

    public EntityManagerHandler getEntityManagerHandler() {
        return this.entityManagerHandler;
    }

    public String getTimePattern() {
        return this.configuration.getTimeFormat().getPattern();
    }

    public TranslationHandler getTranslationHandler() {
        return this.translationHandler;
    }

    public Date parseDate(String string) throws CoercionException {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        try {
            return this.getDateFormat().parse(string);
        }
        catch (ParseException parseException) {
            throw new CoercionException(string);
        }
    }

    public BigDecimal parseDecimal(String string, int n) {
        String string2;
        org.cyclos.model.system.languages.NumberFormat numberFormat = this.configuration.getNumberFormat();
        if ((string = StringHelper.trimToNull((Object)string)) == null) {
            return null;
        }
        String[] stringArray = StringUtils.split((String)string, (char)numberFormat.getDecimalSeparator());
        if (stringArray.length > 2) {
            throw new CoercionException(string);
        }
        String string3 = stringArray[0];
        Object[] objectArray = StringUtils.split((String)string3, (char)numberFormat.getGroupingSeparator());
        for (int i = 0; i < objectArray.length; ++i) {
            String string4 = objectArray[i];
            if (StringHelper.isNumeric((String)string4) && (i <= 0 || string4.length() == 3)) continue;
            throw new CoercionException(string);
        }
        String string5 = string2 = stringArray.length == 1 ? null : stringArray[1];
        if (string2 != null && !StringHelper.isNumeric((String)string2)) {
            throw new CoercionException(string);
        }
        return new BigDecimal(StringHelper.join((Object[])objectArray, (String)"") + (String)(string2 == null ? "" : "." + string2)).setScale(n, RoundingMode.HALF_UP);
    }

    public Date parseTime(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        try {
            return this.getTimeFormat().parse(string);
        }
        catch (ParseException parseException) {
            throw new CoercionException(string);
        }
    }

    public Date parseTimestamp(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        try {
            return this.getDateTimeFormat().parse(string);
        }
        catch (ParseException parseException) {
            throw new CoercionException(string);
        }
    }

    protected String message(MessageFormat messageFormat, MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(messageFormat, this.configuration.getLanguage(), messageKey, objectArray);
    }

    private DecimalFormat createNumberFormat(int n) {
        DecimalFormatSymbols decimalFormatSymbols = FormatterImpl.getDecimalSymbols(this.configuration.getNumberFormat());
        return new DecimalFormat(FormatterImpl.getNumberPattern(n), decimalFormatSymbols);
    }

    private String customFieldVariable(String string, Collection<? extends CustomFieldValue<?, ?, ?, ?>> collection) {
        return CollectionHelper.orEmpty(collection).stream().filter(customFieldValue -> customFieldValue.getField().getInternalName().equals(string)).map(customFieldValue -> {
            Object object = this.customFieldValueHandler.getValue(customFieldValue.getField(), customFieldValue, false);
            CustomFieldType customFieldType = customFieldValue.getField().getType();
            if (customFieldType == CustomFieldType.DATE) {
                return this.formatAsDate((Date)object);
            }
            String string = this.format(object);
            if (customFieldType == CustomFieldType.RICH_TEXT) {
                string = StringHelper.removeMarkupTags((String)string);
            }
            return StringUtils.substringBefore((String)string, (String)"\n");
        }).findFirst().orElse("");
    }

    private String formatAsDate(DateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        return this.configuration.getDateFormat().format(dateTime);
    }

    private String formatAsTime(DateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        return this.configuration.getTimeFormat().format(dateTime);
    }

    private String formatAsTimestamp(DateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        return TimeFormat.format((DateTime)dateTime, (String)TIMESTAMP_PATTERN);
    }

    private DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(this.configuration.getDateFormat().getPattern());
            this.dateFormat.setTimeZone(this.configuration.getTimeZone());
            this.dateFormat.setLenient(false);
        }
        return this.dateFormat;
    }

    private DateFormat getDateTimeFormat() {
        if (this.dateTimeFormat == null) {
            this.dateTimeFormat = new SimpleDateFormat(this.configuration.getDateFormat().getPattern() + " " + this.configuration.getTimeFormat().getPattern());
            this.dateTimeFormat.setTimeZone(this.configuration.getTimeZone());
            this.dateTimeFormat.setLenient(false);
        }
        return this.dateTimeFormat;
    }

    private NumberFormat getNumberFormatForScale(int n) {
        if (n < 0) {
            if (this.variableNumberFormat == null) {
                this.variableNumberFormat = this.createNumberFormat(-1);
            }
            return this.variableNumberFormat;
        }
        n = Math.min(n, BigDecimalHelper.MAX_SCALE);
        if (this.numberFormats == null) {
            this.numberFormats = new DecimalFormat[BigDecimalHelper.MAX_SCALE + 1];
        }
        if (this.numberFormats[n] == null) {
            this.numberFormats[n] = this.createNumberFormat(n);
        }
        return this.numberFormats[n];
    }

    private DateFormat getTimeFormat() {
        if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat(this.configuration.getTimeFormat().getPattern());
            this.timeFormat.setTimeZone(this.configuration.getTimeZone());
            this.timeFormat.setLenient(false);
        }
        return this.timeFormat;
    }

    private DateFormat getTimestampFormat() {
        if (this.timestampFormat == null) {
            this.timestampFormat = new SimpleDateFormat(this.configuration.getDateFormat().getPattern() + " " + TIMESTAMP_PATTERN);
            this.timestampFormat.setTimeZone(this.configuration.getTimeZone());
            this.timestampFormat.setLenient(false);
        }
        return this.dateTimeFormat;
    }
}

