/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.conversion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityVO;
import org.cyclos.server.utils.ClassHelper;

public abstract class VOFiller<VO extends EntityVO> {
    private final Class<VO> voType;
    private Map<Long, VO> vos = new HashMap<Long, VO>();
    private Set<Long> filled = new HashSet<Long>();

    public VOFiller(Class<VO> clazz) {
        this.voType = clazz;
    }

    public VO add(Long l) {
        if (l == null) {
            return null;
        }
        return (VO)this.vos.computeIfAbsent(l, l2 -> {
            EntityVO entityVO = (EntityVO)ClassHelper.instantiate(this.voType);
            entityVO.setId(l);
            return entityVO;
        });
    }

    public <T extends VO> T add(Long l, Class<T> clazz) {
        if (l == null) {
            return null;
        }
        return (T)this.vos.computeIfAbsent(l, l2 -> {
            EntityVO entityVO = (EntityVO)ClassHelper.instantiate((Class)clazz);
            entityVO.setId(l);
            return entityVO;
        });
    }

    public void fill() {
        HashSet<Long> hashSet = new HashSet<Long>(this.vos.keySet());
        hashSet.removeAll(this.filled);
        if (hashSet.isEmpty()) {
            return;
        }
        this.filled.addAll(hashSet);
        this.fetch(hashSet).forEach(entityVO -> {
            EntityVO entityVO2 = (EntityVO)this.vos.get(entityVO.getId());
            if (entityVO2 != null) {
                entityVO.copyPropertiesTo((Bean)entityVO2);
            }
        });
    }

    protected abstract List<VO> fetch(Set<Long> var1);
}

