/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cluster;

import java.util.concurrent.TimeUnit;

public abstract class StorageType<K, V> {
    private final String name;
    private final long ttl;
    private final TimeUnit ttlUnit;

    public StorageType(String string, long l, TimeUnit timeUnit) {
        this.name = string;
        if (l <= 0L) {
            throw new IllegalArgumentException("TTL must be positive");
        }
        this.ttl = l;
        this.ttlUnit = timeUnit;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StorageType storageType = (StorageType)object;
        return !(this.name == null ? storageType.name != null : !this.name.equals(storageType.name));
    }

    public String getName() {
        return this.name;
    }

    public long getTtl() {
        return this.ttl;
    }

    public TimeUnit getTtlUnit() {
        return this.ttlUnit;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public String toString() {
        return this.getName();
    }
}

