/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.springframework.context.ApplicationContext;

public class EntityAccessorCacheValue
extends AccessorCacheValue {
    private static final long serialVersionUID = 1L;
    private final Class<? extends SimpleEntity> entityClass;
    private final Long id;

    public EntityAccessorCacheValue(Class<? extends SimpleEntity> clazz, Long l) {
        this.entityClass = clazz;
        this.id = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EntityAccessorCacheValue entityAccessorCacheValue = (EntityAccessorCacheValue)object;
        if (this.entityClass == null ? entityAccessorCacheValue.entityClass != null : !this.entityClass.getName().equals(entityAccessorCacheValue.entityClass.getName())) {
            return false;
        }
        return !(this.id == null ? entityAccessorCacheValue.id != null : !this.id.equals(entityAccessorCacheValue.id));
    }

    public Class<? extends SimpleEntity> getEntityClass() {
        return this.entityClass;
    }

    public Long getId() {
        return this.id;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.entityClass == null ? 0 : this.entityClass.getName().hashCode());
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        return n;
    }

    public String toString() {
        return "EntityAccessorCacheValue [entityClass=" + String.valueOf(this.entityClass) + ", id=" + this.id + "]";
    }

    @Override
    public Object unwrap(ApplicationContext applicationContext) {
        return ((RawEntityManagerHandler)applicationContext.getBean(RawEntityManagerHandler.class)).find(this.entityClass, this.id);
    }
}

