/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import java.io.Serializable;
import org.cyclos.model.access.channels.BuiltInChannel;

public class ChannelCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BuiltInChannel builtInChannel;
    private final String internalName;
    private final Long networkId;

    public ChannelCacheKey(BuiltInChannel builtInChannel) {
        this.builtInChannel = builtInChannel;
        this.internalName = builtInChannel.getInternalName();
        this.networkId = null;
    }

    public ChannelCacheKey(String string, Long l) {
        this.builtInChannel = BuiltInChannel.getByInternalName((String)string);
        this.internalName = string;
        this.networkId = this.builtInChannel == null ? l : null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChannelCacheKey channelCacheKey = (ChannelCacheKey)object;
        if (this.builtInChannel != channelCacheKey.builtInChannel) {
            return false;
        }
        if (this.internalName == null ? channelCacheKey.internalName != null : !this.internalName.equals(channelCacheKey.internalName)) {
            return false;
        }
        return !(this.networkId == null ? channelCacheKey.networkId != null : !this.networkId.equals(channelCacheKey.networkId));
    }

    public BuiltInChannel getBuiltInChannel() {
        return this.builtInChannel;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.builtInChannel == null ? 0 : this.builtInChannel.hashCode());
        n = 31 * n + (this.internalName == null ? 0 : this.internalName.hashCode());
        n = 31 * n + (this.networkId == null ? 0 : this.networkId.hashCode());
        return n;
    }

    public String toString() {
        return this.internalName + "@" + (String)(this.networkId == null ? "<global>" : "network " + this.networkId);
    }
}

