/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import com.nimbusds.jose.jwk.JWKSet;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.cyclos.impl.access.PrincipalTypeCacheKey;
import org.cyclos.impl.access.RequestDataCacheValue;
import org.cyclos.impl.banking.TransferTypeCacheKey;
import org.cyclos.impl.contentmanagement.ThemeImageCacheKey;
import org.cyclos.impl.marketplace.AdCategoryCacheKey;
import org.cyclos.impl.sql.TableCacheKey;
import org.cyclos.impl.sql.TableCacheValue;
import org.cyclos.impl.system.ChannelConfigurationCacheKey;
import org.cyclos.impl.system.CompiledScriptCacheKey;
import org.cyclos.impl.system.CompiledScriptCacheValue;
import org.cyclos.impl.system.ConfigurationAccessorCacheKey;
import org.cyclos.impl.system.ConfigurationImageCacheKey;
import org.cyclos.impl.system.ExportFormatCacheKey;
import org.cyclos.impl.system.ExtensionPointCacheKey;
import org.cyclos.impl.system.ServiceInterceptorCacheKey;
import org.cyclos.impl.users.GroupsCacheKey;
import org.cyclos.impl.users.ProductsAccessorCacheKey;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.CollectionAccessorCacheValue;
import org.cyclos.impl.utils.cache.MapAccessorCacheValue;
import org.cyclos.impl.utils.notifications.AdminsToNotifyCacheKey;
import org.cyclos.model.contentmanagement.translations.CustomizedTranslation;
import org.springframework.mail.javamail.JavaMailSender;

public abstract class CacheType<K extends Serializable, V>
implements Serializable,
Comparable<CacheType<K, V>> {
    public static final CacheType<ConfigurationAccessorCacheKey, AccessorCacheValue> CONFIGURATION_ACCESSOR;
    public static final CacheType<ConfigurationImageCacheKey, MapAccessorCacheValue> CONFIGURATION_IMAGES;
    public static final CacheType<ExportFormatCacheKey, AccessorCacheValue> EXPORT_FORMATS;
    public static final CacheType<PrincipalTypeCacheKey, AccessorCacheValue> PRINCIPAL_TYPES;
    public static final CacheType<ChannelConfigurationCacheKey, AccessorCacheValue> CHANNEL_CONFIGURATION;
    public static final CacheType<ProductsAccessorCacheKey, AccessorCacheValue> PRODUCTS_ACCESSOR;
    public static final CacheType<GroupsCacheKey, CollectionAccessorCacheValue> GROUPS;
    public static final CacheType<String, RequestDataCacheValue> REQUEST_DATA;
    public static final CacheType<String, Serializable> LICENSE;
    public static final CacheType<ExtensionPointCacheKey, AccessorCacheValue> EXTENSION_POINTS;
    public static final CacheType<Long, HashMap<String, CustomizedTranslation>> CUSTOMIZED_TRANSLATIONS;
    public static final CacheType<TransferTypeCacheKey, AccessorCacheValue> TRANSFER_TYPES;
    public static final CacheType<Long, HashMap<String, Long>> CUSTOM_WS;
    public static final CacheType<ServiceInterceptorCacheKey, AccessorCacheValue> SERVICE_INTERCEPTORS;
    public static final CacheType<ThemeImageCacheKey, MapAccessorCacheValue> THEME_IMAGES;
    public static final CacheType<String, JWKSet> PUBLIC_JWKS;
    public static final CacheType<AdCategoryCacheKey, AccessorCacheValue> AD_CATEGORIES;
    public static final CacheType<AdminsToNotifyCacheKey, ArrayList<Long>> ADMINS_TO_NOTIFY;
    public static final CacheType<Long, JavaMailSender> MAIL_SENDERS;
    public static final CacheType<CompiledScriptCacheKey, CompiledScriptCacheValue> COMPILED_SCRIPTS;
    private static final Map<String, CacheType<?, ?>> NAME_MAP;
    private static AtomicInteger nextOrder;
    private static final String TABLE_PREFIX = "table.";
    private static final String CUSTOM_PREFIX = "custom.";
    private final String name;
    private final CacheRootType rootType;
    private final int order;

    public static Collection<CacheType<?, ?>> all() {
        return NAME_MAP.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheType<Serializable, Object> custom(String string) {
        String string2 = CUSTOM_PREFIX + string.toLowerCase();
        CacheType<Serializable, Object> cacheType = NAME_MAP.get(string2);
        if (cacheType == null) {
            Map<String, CacheType<?, ?>> map = NAME_MAP;
            synchronized (map) {
                cacheType = NAME_MAP.get(string2);
                if (cacheType == null) {
                    cacheType = new CacheType<Serializable, Object>(string2, CacheRootType.CUSTOM){};
                    NAME_MAP.put(string2, cacheType);
                }
            }
        }
        return cacheType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheType<TableCacheKey, TableCacheValue> forTable(String string) {
        String string2 = TABLE_PREFIX + string.toLowerCase();
        CacheType<TableCacheKey, TableCacheValue> cacheType = NAME_MAP.get(string2);
        if (cacheType == null) {
            Map<String, CacheType<?, ?>> map = NAME_MAP;
            synchronized (map) {
                cacheType = NAME_MAP.get(string2);
                if (cacheType == null) {
                    cacheType = new CacheType<TableCacheKey, TableCacheValue>(string2, CacheRootType.TABLE){};
                    NAME_MAP.put(string2, cacheType);
                }
            }
        }
        return cacheType;
    }

    public static CacheType<?, ?> getByName(String string) {
        CacheType<Object, Object> cacheType = NAME_MAP.get(string);
        if (cacheType == null) {
            if (string.startsWith(TABLE_PREFIX)) {
                cacheType = CacheType.forTable(string.substring(TABLE_PREFIX.length()));
            } else {
                throw new IllegalArgumentException("No cache type named " + string);
            }
        }
        return cacheType;
    }

    private static int getNextOrder(CacheRootType cacheRootType) {
        return cacheRootType == CacheRootType.TABLE ? Math.negateExact(nextOrder.getAndIncrement()) : nextOrder.getAndIncrement();
    }

    private CacheType(String string) {
        this(string, CacheRootType.REGULAR);
    }

    private CacheType(String string, CacheRootType cacheRootType) {
        this.name = string;
        this.rootType = cacheRootType;
        this.order = CacheType.getNextOrder(cacheRootType);
        NAME_MAP.put(string, this);
    }

    @Override
    public int compareTo(CacheType cacheType) {
        return this.order - cacheType.order;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CacheType cacheType = (CacheType)object;
        return !(this.name == null ? cacheType.name != null : !this.name.equals(cacheType.name));
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean isCustom() {
        return this.rootType == CacheRootType.CUSTOM;
    }

    public boolean isTable() {
        return this.rootType == CacheRootType.TABLE;
    }

    public String toString() {
        return this.name;
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.name);
    }

    static {
        NAME_MAP = new HashMap();
        nextOrder = new AtomicInteger();
        CONFIGURATION_ACCESSOR = new CacheType<ConfigurationAccessorCacheKey, AccessorCacheValue>("configurationAccessor"){};
        CONFIGURATION_IMAGES = new CacheType<ConfigurationImageCacheKey, MapAccessorCacheValue>("configurationImages"){};
        EXPORT_FORMATS = new CacheType<ExportFormatCacheKey, AccessorCacheValue>("exportFormats"){};
        PRINCIPAL_TYPES = new CacheType<PrincipalTypeCacheKey, AccessorCacheValue>("principalTypes"){};
        CHANNEL_CONFIGURATION = new CacheType<ChannelConfigurationCacheKey, AccessorCacheValue>("configurationChannel"){};
        PRODUCTS_ACCESSOR = new CacheType<ProductsAccessorCacheKey, AccessorCacheValue>("productsAccessor"){};
        GROUPS = new CacheType<GroupsCacheKey, CollectionAccessorCacheValue>("groups"){};
        REQUEST_DATA = new CacheType<String, RequestDataCacheValue>("requestData"){};
        LICENSE = new CacheType<String, Serializable>("license"){};
        EXTENSION_POINTS = new CacheType<ExtensionPointCacheKey, AccessorCacheValue>("extensionPoints"){};
        CUSTOMIZED_TRANSLATIONS = new CacheType("customizedTranslations"){};
        TRANSFER_TYPES = new CacheType("transferTypes"){};
        CUSTOM_WS = new CacheType("customWebServices"){};
        SERVICE_INTERCEPTORS = new CacheType("serviceInterceptors"){};
        THEME_IMAGES = new CacheType("themeImages"){};
        PUBLIC_JWKS = new CacheType("publicJwks"){};
        AD_CATEGORIES = new CacheType("adCategories"){};
        ADMINS_TO_NOTIFY = new CacheType("adminsToNotify"){};
        MAIL_SENDERS = new CacheType<Long, JavaMailSender>("mailSenders"){};
        COMPILED_SCRIPTS = new CacheType<CompiledScriptCacheKey, CompiledScriptCacheValue>("compiledScripts"){};
    }

    public static enum CacheRootType {
        REGULAR,
        TABLE,
        CUSTOM;

    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;

        private SerializedForm(String string) {
            this.name = string;
        }

        Object readResolve() throws ObjectStreamException {
            try {
                CacheType<?, ?> cacheType = CacheType.getByName(this.name);
                if (cacheType == null) {
                    throw new IllegalArgumentException("Not found");
                }
                return cacheType;
            }
            catch (Exception exception) {
                throw new InvalidObjectException("No such cache type: " + this.name);
            }
        }
    }
}

