/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embeddable;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.WrappedObject;
import org.cyclos.impl.utils.cache.BeanAccessorCacheValue;
import org.cyclos.impl.utils.cache.BooleanPropertiesHolderCacheValue;
import org.cyclos.impl.utils.cache.CollectionAccessorCacheValue;
import org.cyclos.impl.utils.cache.EmbeddableAccessorCacheValue;
import org.cyclos.impl.utils.cache.EntityAccessorCacheValue;
import org.cyclos.impl.utils.cache.MapAccessorCacheValue;
import org.cyclos.impl.utils.cache.ScalarAccessorCacheValue;
import org.cyclos.model.Bean;

public abstract class AccessorCacheValue
implements Serializable,
WrappedObject {
    private static final long serialVersionUID = 1L;

    public static CollectionAccessorCacheValue create(Collection<?> collection) {
        return (CollectionAccessorCacheValue)AccessorCacheValue.create(collection);
    }

    public static MapAccessorCacheValue create(Map<?, ?> map) {
        return (MapAccessorCacheValue)AccessorCacheValue.create(map);
    }

    public static AccessorCacheValue create(Object object) {
        if (object == null) {
            return ScalarAccessorCacheValue.forNull();
        }
        if (object instanceof AccessorCacheValue) {
            return (AccessorCacheValue)object;
        }
        if (object instanceof SimpleEntity) {
            SimpleEntity simpleEntity = (SimpleEntity)object;
            if (simpleEntity.isPersistent()) {
                return new EntityAccessorCacheValue(simpleEntity.getClass(), simpleEntity.getId());
            }
            return new ScalarAccessorCacheValue(object);
        }
        if (object instanceof Bean) {
            return new BeanAccessorCacheValue((Bean)object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            HashMap<AccessorCacheValue, AccessorCacheValue> hashMap = new HashMap<AccessorCacheValue, AccessorCacheValue>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                hashMap.put(AccessorCacheValue.create(entry.getKey()), AccessorCacheValue.create(entry.getValue()));
            }
            return new MapAccessorCacheValue(hashMap);
        }
        if (object instanceof Set) {
            return AccessorCacheValue.createCollection((Collection)object, new HashSet<AccessorCacheValue>());
        }
        if (object instanceof Collection) {
            return AccessorCacheValue.createCollection((Collection)object, new ArrayList<AccessorCacheValue>());
        }
        if (object instanceof BooleanPropertiesHolder) {
            BooleanPropertiesHolder booleanPropertiesHolder = (BooleanPropertiesHolder)object;
            return new BooleanPropertiesHolderCacheValue(booleanPropertiesHolder);
        }
        if (object.getClass().isAnnotationPresent(Embeddable.class)) {
            return new EmbeddableAccessorCacheValue(object);
        }
        return new ScalarAccessorCacheValue(object);
    }

    private static CollectionAccessorCacheValue createCollection(Collection<?> collection, Collection<AccessorCacheValue> collection2) {
        for (Object obj : collection) {
            collection2.add(AccessorCacheValue.create(obj));
        }
        return new CollectionAccessorCacheValue(collection2);
    }
}

