/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.model.utils.PushNotificationEventType;
import org.cyclos.utils.CollectionHelper;

public class PushNotificationSubscriptionMatcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<PushNotificationEventType<?>> eventTypes;
    private final Long userId;
    private final Set<Long> accountIds;
    private final String sessionToken;
    private final String ticketNumber;
    private final String deviceConfirmationId;
    private final String identityProviderRequestId;

    public PushNotificationSubscriptionMatcher(Set<PushNotificationEventType<?>> set, Long l, Set<Long> set2, String string, String string2, String string3, String string4) {
        this.eventTypes = set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
        this.userId = l;
        this.accountIds = ImmutableSet.copyOf((Collection)CollectionHelper.orEmpty(set2));
        this.sessionToken = string;
        this.ticketNumber = string2;
        this.deviceConfirmationId = string3;
        this.identityProviderRequestId = string4;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PushNotificationSubscriptionMatcher pushNotificationSubscriptionMatcher = (PushNotificationSubscriptionMatcher)object;
        return Objects.equals(this.deviceConfirmationId, pushNotificationSubscriptionMatcher.deviceConfirmationId) && Objects.equals(this.eventTypes, pushNotificationSubscriptionMatcher.eventTypes) && Objects.equals(this.identityProviderRequestId, pushNotificationSubscriptionMatcher.identityProviderRequestId) && Objects.equals(this.sessionToken, pushNotificationSubscriptionMatcher.sessionToken) && Objects.equals(this.ticketNumber, pushNotificationSubscriptionMatcher.ticketNumber) && Objects.equals(this.userId, pushNotificationSubscriptionMatcher.userId) && Objects.equals(this.accountIds, pushNotificationSubscriptionMatcher.accountIds);
    }

    public String getDeviceConfirmationId() {
        return this.deviceConfirmationId;
    }

    public Set<PushNotificationEventType<?>> getEventTypes() {
        return this.eventTypes;
    }

    public String getIdentityProviderRequestId() {
        return this.identityProviderRequestId;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getTicketNumber() {
        return this.ticketNumber;
    }

    public Long getUserId() {
        return this.userId;
    }

    public int hashCode() {
        return Objects.hash(this.deviceConfirmationId, this.eventTypes, this.identityProviderRequestId, this.sessionToken, this.ticketNumber, this.userId);
    }

    public boolean matches(PushNotificationEventContext<?> pushNotificationEventContext) {
        if (!this.eventTypes.contains(pushNotificationEventContext.getType()) || this.userId != null && pushNotificationEventContext.getUserId() != null && !this.userId.equals(pushNotificationEventContext.getUserId())) {
            return false;
        }
        if (!this.accountIds.isEmpty() && pushNotificationEventContext.getAccountId() != null && !this.accountIds.contains(pushNotificationEventContext.getAccountId())) {
            return false;
        }
        if (this.sessionToken != null && pushNotificationEventContext.getSessionToken() != null && !this.sessionToken.equals(pushNotificationEventContext.getSessionToken())) {
            return false;
        }
        if (this.ticketNumber != null && pushNotificationEventContext.getTicketNumber() != null && !this.ticketNumber.equals(pushNotificationEventContext.getTicketNumber())) {
            return false;
        }
        if (this.deviceConfirmationId != null && pushNotificationEventContext.getDeviceConfirmationId() != null && !this.deviceConfirmationId.equals(pushNotificationEventContext.getDeviceConfirmationId())) {
            return false;
        }
        return this.identityProviderRequestId == null || pushNotificationEventContext.getIdentityProviderRequestId() == null || this.identityProviderRequestId.equals(pushNotificationEventContext.getIdentityProviderRequestId());
    }

    public String toString() {
        return "[eventTypes=" + String.valueOf(this.eventTypes) + ", userId=" + this.userId + ", sessionToken=" + this.sessionToken + ", ticketNumber=" + this.ticketNumber + ", deviceConfirmationId=" + this.deviceConfirmationId + ", identityProviderRequestId=" + this.identityProviderRequestId + "]";
    }
}

