/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import javax.annotation.Nullable;
import org.cyclos.entities.users.Phone;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.model.users.phones.PhoneNature;

public interface PhoneNumberHandler {
    public static final String ATTR_COUNTRY = "country";
    public static final String ATTR_MOBILE = "mobile";
    public static final String ATTR_LAND_LINE = "landLine";
    public static final String ATTR_NUMBER = "number";

    default public boolean equals(PhoneNumberDescriptor phoneNumberDescriptor, PhoneNumberDescriptor phoneNumberDescriptor2) {
        return phoneNumberDescriptor != null && phoneNumberDescriptor2 != null && phoneNumberDescriptor.toE164().equals(phoneNumberDescriptor2.toE164());
    }

    default public String format(PhoneNumberDescriptor phoneNumberDescriptor, ConfigurationAccessor configurationAccessor) {
        if (phoneNumberDescriptor == null) {
            return "";
        }
        if (configurationAccessor.isAlwaysShowInternationalPhoneNumber()) {
            return phoneNumberDescriptor.toInternationalFormat();
        }
        boolean bl = phoneNumberDescriptor.getCountryCode() == this.getCountryCode(configurationAccessor.getCountry());
        return bl ? phoneNumberDescriptor.toNationalFormat() : phoneNumberDescriptor.toInternationalFormat();
    }

    public int getCountryCode(String var1);

    public String getExampleNumber(PhoneNature var1, ConfigurationAccessor var2);

    default public boolean isValid(String string, ConfigurationAccessor configurationAccessor, PhoneNature phoneNature) {
        PhoneNumberDescriptor phoneNumberDescriptor = this.parse(string, configurationAccessor);
        if (phoneNumberDescriptor == null) {
            return false;
        }
        if (phoneNature == PhoneNature.LANDLINE) {
            return phoneNumberDescriptor.isLandLine();
        }
        if (phoneNature == PhoneNature.MOBILE) {
            return phoneNumberDescriptor.isMobile();
        }
        return true;
    }

    @Nullable
    public PhoneNumberDescriptor parse(@Nullable String var1, ConfigurationAccessor var2);

    @Nullable
    public PhoneNumberDescriptor toDescriptor(@Nullable Phone var1);

    default public String tryNormalize(@Nullable String string, ConfigurationAccessor configurationAccessor) {
        PhoneNumberDescriptor phoneNumberDescriptor = this.parse(string, configurationAccessor);
        return phoneNumberDescriptor == null ? string : phoneNumberDescriptor.toE164();
    }
}

