/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.cyclos.entities.users.RoleContainer;
import org.cyclos.model.IEntity;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.Role;
import org.cyclos.utils.CollectionHelper;

public class PermissionHelper {
    public static Set<Role> allRoles(RoleContainer roleContainer) {
        EnumSet<Role> enumSet = EnumSet.noneOf(Role.class);
        for (Role role : Role.values()) {
            if (!PermissionHelper.hasRole(roleContainer, role)) continue;
            enumSet.add(role);
        }
        return enumSet;
    }

    public static <E, A extends E> Set<E> applyAllowed(Collection<E> collection, Collection<A> collection2) throws PermissionDeniedException {
        PermissionHelper.checkNotEmpty(collection2);
        if (CollectionHelper.isEmpty(collection)) {
            return new HashSet<A>(collection2);
        }
        HashSet<E> hashSet = new HashSet<E>(collection);
        hashSet.retainAll(collection2);
        if (hashSet.isEmpty()) {
            throw new PermissionDeniedException();
        }
        return hashSet;
    }

    public static <T> void checkContains(Collection<? super T> collection, T t) {
        if (collection == null || !collection.contains(t)) {
            throw new PermissionDeniedException();
        }
    }

    public static void checkContainsId(Collection<? extends IEntity> collection, Long l) {
        boolean bl = false;
        if (CollectionHelper.isNotEmpty(collection)) {
            for (IEntity iEntity : collection) {
                if (iEntity == null || !iEntity.getId().equals(l)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            throw new PermissionDeniedException();
        }
    }

    public static void checkEmpty(Collection<?> collection) {
        if (CollectionHelper.isNotEmpty(collection)) {
            throw new PermissionDeniedException();
        }
    }

    public static void checkEquals(Object object, Object object2) {
        if (!Objects.equals(object, object2)) {
            throw new PermissionDeniedException();
        }
    }

    public static void checkNotEmpty(Collection<?> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            throw new PermissionDeniedException();
        }
    }

    public static void checkNotNull(Object object) {
        if (object == null) {
            throw new PermissionDeniedException();
        }
    }

    public static <T> Collection<T> checkSelection(Collection<T> collection, Collection<T> collection2) {
        return PermissionHelper.checkSelection(collection, collection2, false);
    }

    public static <T> Collection<T> checkSelection(Collection<T> collection, Collection<T> collection2, boolean bl) {
        if (CollectionHelper.isEmpty(collection)) {
            if (!bl || CollectionHelper.isNotEmpty(collection2)) {
                throw new PermissionDeniedException();
            }
            return null;
        }
        if (CollectionHelper.isEmpty(collection2)) {
            return collection;
        }
        if (!collection.containsAll(collection2)) {
            throw new PermissionDeniedException();
        }
        return collection2;
    }

    public static boolean hasRole(RoleContainer roleContainer, Role role) {
        switch (role) {
            case ADMIN: {
                return roleContainer.isAdmin();
            }
            case BROKER: {
                return roleContainer.isBroker();
            }
            case GLOBAL_ADMIN: {
                return roleContainer.isGlobalAdmin();
            }
            case MEMBER: {
                return roleContainer.isMember();
            }
            case NETWORK_ADMIN: {
                return roleContainer.isNetworkAdmin();
            }
            case OPERATOR: {
                return roleContainer.isOperator();
            }
            case ALIAS_OPERATOR: {
                return roleContainer.isAliasOperator();
            }
            case RESTRICTED_OPERATOR: {
                return roleContainer.isRestrictedOperator();
            }
        }
        return false;
    }
}

