/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.Collection;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.users.products.MyProductPasswordActionDTO;
import org.cyclos.model.users.products.ProductDTO;
import org.cyclos.model.users.products.ProductPasswordActionDTO;
import org.cyclos.model.users.products.UserManagementProductDTO;
import org.cyclos.model.users.products.UserProductPasswordActionDTO;
import org.cyclos.utils.CollectionHelper;

public class PasswordActionHelper {
    public static void setAtRegistration(ProductDTO productDTO, PasswordType passwordType) {
        if (CollectionHelper.isNotEmpty((Iterable)productDTO.getPasswordActions())) {
            for (MyProductPasswordActionDTO myProductPasswordActionDTO : productDTO.getPasswordActions()) {
                if (!passwordType.getId().equals(myProductPasswordActionDTO.getPasswordType().getId())) continue;
                myProductPasswordActionDTO.setAtRegistration(true);
                break;
            }
        }
    }

    public static void setMyPasswordActions(ProductDTO productDTO, PasswordType passwordType) {
        if (CollectionHelper.isNotEmpty((Iterable)productDTO.getPasswordActions())) {
            for (MyProductPasswordActionDTO myProductPasswordActionDTO : productDTO.getPasswordActions()) {
                if (myProductPasswordActionDTO.getPasswordType().getPasswordMode() == PasswordMode.OTP) {
                    myProductPasswordActionDTO.setEnable(true);
                } else {
                    myProductPasswordActionDTO.setChange(true);
                }
                if (!myProductPasswordActionDTO.getPasswordType().getId().equals(passwordType.getId())) continue;
                myProductPasswordActionDTO.setAtRegistration(true);
            }
        }
    }

    public static void setPasswordAction(ProductPasswordActionDTO productPasswordActionDTO, boolean bl) {
        productPasswordActionDTO.setEnable(bl);
        productPasswordActionDTO.setChange(bl);
        productPasswordActionDTO.setUnblock(bl);
        if (productPasswordActionDTO instanceof UserProductPasswordActionDTO) {
            ((UserProductPasswordActionDTO)productPasswordActionDTO).setReset(bl);
        }
    }

    public static void setPasswordActions(Collection<? extends ProductPasswordActionDTO> collection, boolean bl) {
        if (CollectionHelper.isNotEmpty(collection)) {
            for (ProductPasswordActionDTO productPasswordActionDTO : collection) {
                PasswordActionHelper.setPasswordAction(productPasswordActionDTO, bl);
            }
        }
    }

    public static void setUserPasswordActions(UserManagementProductDTO userManagementProductDTO) {
        PasswordActionHelper.setPasswordActions(userManagementProductDTO.getUserPasswordActions(), true);
    }
}

