/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;

public class UserValidationFields {
    private Collection<ProfileField> profileFields = Collections.emptySet();
    private Set<PhoneNature> phoneNatures = Collections.emptySet();
    private boolean password;
    private boolean securityQuestion;
    private boolean captcha;
    private boolean agreements;

    public UserValidationFields() {
        this(true);
    }

    public UserValidationFields(boolean bl) {
        if (bl) {
            this.profileFields = null;
            this.phoneNatures = null;
            this.password = true;
            this.securityQuestion = true;
            this.captcha = true;
            this.agreements = true;
        }
    }

    public void addPhoneNature(PhoneNature phoneNature) {
        if (this.phoneNatures == null) {
            this.phoneNatures = EnumSet.of(phoneNature);
        } else {
            this.phoneNatures.add(phoneNature);
        }
    }

    public void addProfileField(ProfileField profileField) {
        if (this.profileFields == null) {
            this.profileFields = new HashSet<ProfileField>();
        }
        this.profileFields.add(profileField);
    }

    public boolean has(ProfileField profileField) {
        return this.profileFields == null || this.profileFields.contains(profileField);
    }

    public boolean hasPhone(PhoneNature phoneNature) {
        return this.has((ProfileField)BasicProfileField.PHONE) && (this.phoneNatures == null || this.phoneNatures.contains(phoneNature));
    }

    public boolean isAgreements() {
        return this.agreements;
    }

    public boolean isCaptcha() {
        return this.captcha;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setAgreements(boolean bl) {
        this.agreements = bl;
    }

    public void setCaptcha(boolean bl) {
        this.captcha = bl;
    }

    public void setPassword(boolean bl) {
        this.password = bl;
    }

    public void setPhoneNatures(Set<PhoneNature> set) {
        this.phoneNatures = set;
    }

    public void setProfileFields(Collection<ProfileField> collection) {
        this.profileFields = collection;
    }

    public void setSecurityQuestion(boolean bl) {
        this.securityQuestion = bl;
    }
}

