/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclos.entities.access.QTokenPrincipalType;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QCurrency;
import org.cyclos.entities.banking.QUserAccountType;
import org.cyclos.entities.banking.QVoucherConfiguration;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.QAdCustomField;
import org.cyclos.entities.messaging.MessageCategory;
import org.cyclos.entities.messaging.QMessageCategory;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.UserWizard;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.QContactInfoField;
import org.cyclos.entities.users.QMemberProduct;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.SystemMemberOrBrokerProductAccessor;
import org.cyclos.impl.users.productresolvers.MemberCustomOperationsResolver;
import org.cyclos.impl.users.productresolvers.MemberCustomWizardsResolver;
import org.cyclos.impl.users.productresolvers.MyTokenTypesResolver;
import org.cyclos.impl.users.productresolvers.ProductMyAdFieldPropertyResolver;
import org.cyclos.impl.users.productresolvers.VouchersResolver;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.products.AccountProfileVisibility;
import org.cyclos.model.users.products.AccountVisibility;
import org.cyclos.model.users.products.BrokerVisibility;
import org.cyclos.model.users.products.MyMessagesForwardOperation;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.products.UserProfileActivity;
import org.cyclos.model.users.users.GroupFilterDefault;
import org.cyclos.model.utils.TimeField;
import org.springframework.context.ApplicationContext;

public class SystemMemberProductAccessor
extends SystemMemberOrBrokerProductAccessor
implements MemberProductAccessor {
    private UserAccountType accountType;

    public SystemMemberProductAccessor(ApplicationContext applicationContext, Network network, UserAccountType userAccountType) {
        super(applicationContext, network);
        this.accountType = userAccountType;
    }

    @Override
    public AccountAccessibility getAccountAccessibility() {
        return AccountAccessibility.ALWAYS;
    }

    @Override
    public List<AccountFee> getAccountFees() {
        return Collections.emptyList();
    }

    @Override
    public AccountVisibility getAccountVisibility() {
        return AccountVisibility.ALWAYS_VISIBLE;
    }

    @Override
    public List<TokenPrincipalType> getActivateUserTokenTypes() {
        return this.selectFrom(QTokenPrincipalType.tokenPrincipalType).fetch();
    }

    @Override
    public List<TransferType> getChargebackPaymentTypes() {
        List<TransferType> list = this.listTransferTypes(TransferTypeDirection.SYSTEM_TO_USER, TransferTypeDirection.USER_TO_USER, TransferTypeDirection.USER_TO_SELF);
        if (this.accountType != null) {
            list.removeIf(transferType -> !this.accountType.equals((Object)transferType.getTo()));
        }
        return list;
    }

    @Override
    public List<ContactInfoField> getContactInfoFields() {
        return this.selectFrom(QContactInfoField.contactInfoField).fetch();
    }

    @Override
    public BooleanPropertiesHolder<CustomOperation> getCustomOperations() {
        List<CustomOperation> list = this.listCustomOperations(CustomOperationScope.USER, CustomOperationScope.ADVERTISEMENT, CustomOperationScope.RECORD);
        return this.toBooleanPropertiesHolder(list.stream(), MemberCustomOperationsResolver.class);
    }

    @Override
    public TimeInterval getDefaultAdPublicationTime() {
        return TimeInterval.ONE_MONTH;
    }

    @Override
    public BigDecimal getDefaultCreditLimit() {
        return BigDecimal.ZERO;
    }

    @Override
    public List<BasicGroup> getDefaultFilterGroups() {
        return Collections.emptyList();
    }

    @Override
    public BigDecimal getDefaultPaymentAmountLimit() {
        return null;
    }

    @Override
    public BigDecimal getDefaultPaymentAmountPerDayLimit() {
        return null;
    }

    @Override
    public BigDecimal getDefaultPaymentAmountPerMonthLimit() {
        return null;
    }

    @Override
    public BigDecimal getDefaultPaymentAmountPerWeekLimit() {
        return null;
    }

    @Override
    public BigDecimal getDefaultPaymentAmountPerYearLimit() {
        return null;
    }

    @Override
    public BigDecimal getDefaultUpperCreditLimit() {
        return null;
    }

    @Override
    public MyMessagesForwardOperation getFwdMessageToEmail() {
        return MyMessagesForwardOperation.ENABLED;
    }

    @Override
    public List<GroupFilterDefault> getGroupFilterDefault() {
        return Collections.emptyList();
    }

    @Override
    public List<BasicGroup> getGroupsForUserSearch() {
        return Collections.emptyList();
    }

    @Override
    public List<BasicGroup> getGroupsForViewProfile() {
        return Collections.emptyList();
    }

    @Override
    public BigDecimal getIndividualCreditLimit() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getInitialCredit() {
        return BigDecimal.ZERO;
    }

    @Override
    public GeneratedTransferType getInitialCreditType() {
        return null;
    }

    @Override
    public List<PaymentTransferType> getMakePosPaymentTypes() {
        return this.listPaymentTypes((AccountType)this.accountType, null, null, BuiltInChannel.POS, TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public int getMaxAdDescriptionSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxAddressesPerAd() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxAdImages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public TimeInterval getMaxAdPublicationTime() {
        return new TimeInterval(Integer.valueOf(Integer.MAX_VALUE), TimeField.DAYS);
    }

    @Override
    public int getMaxAds() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCategoriesPerAd() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxContactInfos() {
        return Integer.MAX_VALUE;
    }

    @Override
    public List<MemberProduct> getMemberProducts() {
        return this.selectFrom(QMemberProduct.memberProduct).fetch();
    }

    @Override
    public BooleanPropertiesHolder<AdCustomField> getMyAdFields() {
        return this.toBooleanPropertiesHolder(QAdCustomField.adCustomField, ProductMyAdFieldPropertyResolver.class);
    }

    @Override
    public List<PaymentTransferType> getMyApproveTicketPaymentTypes() {
        return this.listPaymentTypes((AccountType)this.accountType, (AccountType)null, TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public List<PaymentTransferType> getMyCreateTicketPaymentTypes() {
        return this.listPaymentTypes((AccountType)null, (AccountType)this.accountType, TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public List<PaymentTransferType> getMyExternalPaymentTypes() {
        return this.listPaymentTypes((AccountType)this.accountType, (AccountType)null, TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public List<PaymentTransferType> getMyPaymentRequestsSendToSystem() {
        return this.listPaymentTypes((AccountType)null, (AccountType)this.accountType, TransferTypeDirection.SYSTEM_TO_USER);
    }

    @Override
    public List<PaymentTransferType> getMyPaymentRequestsSendToUser() {
        return this.listPaymentTypes((AccountType)null, (AccountType)this.accountType, TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public List<PaymentTransferType> getMyPaymentRequestTypes() {
        return this.listPaymentTypes((AccountType)this.accountType, (AccountType)null, TransferTypeDirection.USER_TO_USER, TransferTypeDirection.USER_TO_SYSTEM);
    }

    @Override
    public List<PaymentTransferType> getMyPaymentTypes() {
        return this.listPaymentTypes((AccountType)this.accountType, (AccountType)null, TransferTypeDirection.USER_TO_USER, TransferTypeDirection.USER_TO_SYSTEM, TransferTypeDirection.USER_TO_SELF);
    }

    @Override
    public BooleanPropertiesHolder<TokenPrincipalType> getMyTokenTypes() {
        return this.toBooleanPropertiesHolder(QTokenPrincipalType.tokenPrincipalType, MyTokenTypesResolver.class);
    }

    @Override
    public List<TransferFilter> getMyTransferFilters() {
        return this.listTransferFilter(AccountTypeNature.USER);
    }

    @Override
    public List<PaymentTransferType> getReceivePaymentRequestTypes() {
        return this.listPaymentTypes((AccountType)this.accountType, (AccountType)null, TransferTypeDirection.USER_TO_SYSTEM, TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public List<PaymentTransferType> getReceivePosPaymentTypes() {
        return this.listPaymentTypes((AccountType)null, (AccountType)this.accountType, null, BuiltInChannel.POS, TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public List<UserGroupAccessibility> getSearchUsersOnGroups() {
        return Collections.singletonList(UserGroupAccessibility.ALL);
    }

    @Override
    public List<PaymentTransferType> getSelfPayments() {
        return this.listPaymentTypes((AccountType)this.accountType, TransferTypeDirection.USER_TO_SELF);
    }

    @Override
    public List<MessageCategory> getSendMessagesToAdmin() {
        return this.selectFrom(QMessageCategory.messageCategory).fetch();
    }

    @Override
    public AccountProfileVisibility getShowAccountInProfile() {
        return AccountProfileVisibility.ALL;
    }

    @Override
    public List<UserProfileActivity> getShowActivitiesInProfile() {
        return Arrays.asList(UserProfileActivity.values());
    }

    @Override
    public BrokerVisibility getShowBrokers() {
        return BrokerVisibility.ALL;
    }

    @Override
    public List<PaymentTransferType> getSystemPayments() {
        return this.listPaymentTypes((AccountType)this.accountType, (AccountType)null, TransferTypeDirection.USER_TO_SYSTEM);
    }

    @Override
    public List<UserAccountType> getUserAccounts() {
        if (this.accountType != null) {
            return Collections.singletonList(this.accountType);
        }
        return this.selectFrom(QUserAccountType.userAccountType).fetch();
    }

    @Override
    public List<PaymentTransferType> getUserPayments() {
        return this.listPaymentTypes((AccountType)this.accountType, (AccountType)null, TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public List<Currency> getViewAdsInOtherCurrencies() {
        QCurrency qCurrency = QCurrency.currency;
        return this.selectFrom(qCurrency).fetch();
    }

    @Override
    public List<UserGroupAccessibility> getViewProfileOnGroups() {
        return Collections.singletonList(UserGroupAccessibility.ALL);
    }

    @Override
    public BooleanPropertiesHolder<VoucherConfiguration> getVouchers() {
        return this.toBooleanPropertiesHolder(QVoucherConfiguration.voucherConfiguration, VouchersResolver.class);
    }

    @Override
    public BooleanPropertiesHolder<UserWizard> getWizards() {
        return this.toBooleanPropertiesHolder(this.listUserWizards().stream(), MemberCustomWizardsResolver.class);
    }

    @Override
    public boolean isAdsRequireAuthorization() {
        return false;
    }

    @Override
    public boolean isShowAdExpirationDate() {
        return true;
    }

    @Override
    public boolean isShowAdPublicationDate() {
        return true;
    }

    @Override
    public boolean isViewMyAccounts() {
        return !this.getUserAccounts().isEmpty();
    }

    @Override
    public boolean isWebShopAdsRequireAuthorization() {
        return false;
    }
}

