/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.OperatorGroupPaymentType;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.BrokerProductAccessor;
import org.cyclos.impl.users.EmptyAdminProductAccessor;
import org.cyclos.impl.users.EmptyBrokerProductAccessor;
import org.cyclos.impl.users.MemberOrBrokerProductAccessor;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.RestrictedOperatorBrokerProductAccessor;
import org.cyclos.impl.users.RestrictedOperatorMemberOrBrokerProductAccessor;
import org.cyclos.impl.users.RestrictedOperatorMemberProductAccessor;
import org.cyclos.impl.users.RestrictedOperatorProductAccessor;
import org.cyclos.impl.users.UserManagementProductAccessor;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionUserAccess;
import org.cyclos.model.access.Role;
import org.cyclos.model.users.users.OperatorGroupAccountAccess;

public class RestrictedOperatorProductsAccessor
implements ProductsAccessor {
    private final OperatorGroup group;
    private final ProductsAccessor delegate;
    private ProductAccessor productAccessor;
    private MemberProductAccessor memberAccessor;
    private BrokerProductAccessor brokerAccessor;
    private MemberOrBrokerProductAccessor memberOrBrokerAccessor;
    private Map<UserAccountType, MemberProductAccessor> memberAccessorsPerAccount;
    private Set<Permission> permissions;

    public RestrictedOperatorProductsAccessor(OperatorGroup operatorGroup, ProductsAccessor productsAccessor) {
        this.group = operatorGroup;
        this.delegate = productsAccessor;
        this.initializePermissions();
    }

    @Override
    public AdminProductAccessor admin() {
        return EmptyAdminProductAccessor.getInstance();
    }

    @Override
    public BrokerProductAccessor broker() {
        if (this.group.isBrokering()) {
            if (this.brokerAccessor == null) {
                this.brokerAccessor = new RestrictedOperatorBrokerProductAccessor(this.group, this.delegate.broker(), this.permissions);
            }
            return this.brokerAccessor;
        }
        return EmptyBrokerProductAccessor.getInstance();
    }

    @Override
    public Collection<? extends Product> getProducts() {
        return this.delegate.getProducts();
    }

    @Override
    public MemberProductAccessor member() {
        if (this.memberAccessor == null) {
            this.memberAccessor = new RestrictedOperatorMemberProductAccessor(this.group, this.delegate.member(), this.permissions);
        }
        return this.memberAccessor;
    }

    @Override
    public MemberProductAccessor member(UserAccountType userAccountType) {
        MemberProductAccessor memberProductAccessor;
        if (this.memberAccessorsPerAccount == null) {
            this.memberAccessorsPerAccount = new HashMap<UserAccountType, MemberProductAccessor>();
        }
        if ((memberProductAccessor = this.memberAccessorsPerAccount.get(userAccountType)) == null) {
            memberProductAccessor = new RestrictedOperatorMemberProductAccessor(this.group, this.delegate.member(userAccountType), this.permissions);
        }
        return memberProductAccessor;
    }

    @Override
    public MemberOrBrokerProductAccessor memberOrBroker() {
        if (this.group.isBrokering()) {
            if (this.memberOrBrokerAccessor == null) {
                this.memberOrBrokerAccessor = new RestrictedOperatorMemberOrBrokerProductAccessor<MemberOrBrokerProductAccessor>(this.group, this.delegate.memberOrBroker(), this.permissions);
            }
            return this.memberOrBrokerAccessor;
        }
        return this.member();
    }

    @Override
    public ProductAccessor product() {
        if (this.productAccessor == null) {
            this.productAccessor = new RestrictedOperatorProductAccessor<ProductAccessor>(this.group, this.delegate.product(), this.permissions);
        }
        return this.productAccessor;
    }

    @Override
    public UserManagementProductAccessor userManagement() {
        return this.broker();
    }

    private void initializePermissions() {
        Object object2;
        this.permissions = EnumSet.of(Permission.MY_PASSWORDS_MANAGE, new Permission[]{Permission.USER_VISIBILITY_SEARCH, Permission.USER_VISIBILITY_PROFILE, Permission.MY_OIDC_AUTHORIZATIONS_ENABLE, Permission.MY_IDENTITY_PROVIDERS_ENABLE, Permission.MY_QUICK_ACCESS_SETTINGS_ENABLE});
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<PaymentTransferType> hashSet2 = new HashSet<PaymentTransferType>();
        List<UserAccountType> list = this.delegate.member().getUserAccounts();
        for (Object object2 : this.group.getAccountTypes()) {
            UserAccountType userAccountType = object2.getAccountType();
            if (object2.getAccess() == OperatorGroupAccountAccess.NONE || !list.contains(userAccountType)) continue;
            hashSet.add(userAccountType);
        }
        boolean bl = false;
        object2 = this.delegate.member().getMyPaymentTypes();
        for (OperatorGroupPaymentType operatorGroupPaymentType : this.group.getPaymentTypes()) {
            PaymentTransferType paymentTransferType = operatorGroupPaymentType.getPaymentType();
            boolean bl2 = bl = bl || operatorGroupPaymentType.isRequiresAuthorization() || operatorGroupPaymentType.isAuthorize();
            if (!operatorGroupPaymentType.isEnabled() || !object2.contains(paymentTransferType)) continue;
            hashSet2.add(paymentTransferType);
            switch (paymentTransferType.getDirection()) {
                case USER_TO_SYSTEM: {
                    this.permissions.add(Permission.MY_PAYMENTS_PAY_TO_SYSTEM);
                    break;
                }
                case USER_TO_USER: {
                    this.permissions.add(Permission.MY_PAYMENTS_PAY_TO_USER);
                    this.permissions.add(Permission.USER_OPERATORS_PAY);
                    break;
                }
                case USER_TO_SELF: {
                    this.permissions.add(Permission.MY_PAYMENTS_PAY_TO_SELF);
                    break;
                }
                default: {
                    throw new IllegalActionException("Invalid payment type for operator group");
                }
            }
            if (!paymentTransferType.isRequiresAuthorization()) continue;
            this.permissions.add(Permission.MY_AUTHORIZED_PAYMENTS_VIEW);
        }
        if (!hashSet.isEmpty()) {
            this.permissions.add(Permission.MY_ACCOUNT_VISIBILITY_ENABLE);
            this.permissions.add(Permission.MY_SCHEDULED_PAYMENTS_VIEW);
            if (bl) {
                this.permissions.add(Permission.MY_AUTHORIZED_PAYMENTS_VIEW);
            }
        }
        if (!hashSet.isEmpty() && this.group.isReceivePayments()) {
            this.permissions.add(Permission.MY_PAYMENTS_RECEIVE);
            this.permissions.add(Permission.USER_OPERATORS_PAY);
            this.permissions.add(Permission.MY_PAYMENT_TICKETS_APPROVE);
            this.permissions.add(Permission.MY_PAYMENT_TICKETS_CREATE);
            this.permissions.add(Permission.MY_PAYMENT_TICKETS_VIEW);
            this.permissions.add(Permission.MY_PAYMENT_TICKETS_CANCEL);
        }
        if (!hashSet.isEmpty() && this.group.isRequestPayments()) {
            this.permissions.add(Permission.MY_PAYMENT_REQUESTS_VIEW);
            this.permissions.add(Permission.MY_PAYMENT_REQUESTS_ACCEPT);
            this.permissions.add(Permission.MY_PAYMENT_REQUESTS_CANCEL);
            this.permissions.add(Permission.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM);
            this.permissions.add(Permission.MY_PAYMENT_REQUESTS_SEND_TO_USER);
        }
        if (!hashSet.isEmpty() && this.group.isChargebackPayments()) {
            this.permissions.add(Permission.MY_PAYMENTS_CHARGEBACK);
        }
        if (!hashSet.isEmpty() && this.group.isVoucherTransactions()) {
            this.permissions.add(Permission.MY_VOUCHERS_VIEW_TRANSACTIONS);
            this.permissions.add(Permission.MY_VOUCHERS_REDEEM);
            this.permissions.add(Permission.MY_VOUCHERS_TOP_UP);
        }
        if (this.group.isManageAdvertisements()) {
            this.permissions.add(Permission.MY_ADS_ENABLE);
            this.permissions.add(Permission.MY_ADS_MANAGE);
            this.permissions.add(Permission.MY_WEB_SHOP_ENABLE);
            this.permissions.add(Permission.MY_WEB_SHOP_MANAGE);
        }
        if (this.group.isViewAdvertisements()) {
            this.permissions.add(Permission.USER_ADS_VIEW);
            this.permissions.add(Permission.USER_WEB_SHOP_VIEW);
        }
        if (this.group.isNotifications()) {
            this.permissions.add(Permission.MY_NOTIFICATIONS_ENABLE);
            this.permissions.add(Permission.MY_NOTIFICATION_SETTINGS_ENABLE);
        }
        if (this.group.isMessages()) {
            this.permissions.add(Permission.MY_MESSAGES_VIEW);
            this.permissions.add(Permission.MY_MESSAGES_SEND_TO_SYSTEM);
            this.permissions.add(Permission.MY_MESSAGES_SEND_TO_USER);
        }
        if (this.group.isBrokering()) {
            for (Permission permission : Permission.values()) {
                boolean bl3;
                boolean bl4 = bl3 = permission.getUserAccess() == PermissionUserAccess.NONE || permission.getUserAccess().isManagement();
                if (!permission.getRoles().contains(Role.BROKER) || !bl3) continue;
                this.permissions.add(permission);
            }
            this.permissions.add(Permission.USER_ADS_VIEW);
            this.permissions.add(Permission.USER_WEB_SHOP_VIEW);
            this.permissions.add(Permission.USERS_REGISTER);
        }
    }
}

