/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.cyclos.utils.CollectionHelper;

public class ProductsAccessorCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Long networkId;
    private final Set<Long> productIds;
    private final String methodName;
    private final Object argument;

    public ProductsAccessorCacheKey(Long l, Set<Long> set, String string, Object object) {
        this.networkId = l;
        this.productIds = CollectionHelper.orEmpty(set);
        this.methodName = string;
        this.argument = object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProductsAccessorCacheKey productsAccessorCacheKey = (ProductsAccessorCacheKey)object;
        return Objects.equals(this.methodName, productsAccessorCacheKey.methodName) && Objects.equals(this.networkId, productsAccessorCacheKey.networkId) && Objects.equals(this.productIds, productsAccessorCacheKey.productIds) && Objects.equals(this.argument, productsAccessorCacheKey.argument);
    }

    public Object getArgument() {
        return this.argument;
    }

    public String getmethodName() {
        return this.methodName;
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    public Set<Long> getProductIds() {
        return this.productIds;
    }

    public int hashCode() {
        return Objects.hash(this.methodName, this.networkId, this.productIds, this.argument);
    }

    public boolean matchesNetwork(Long l) {
        return l == null || l.equals(this.networkId);
    }

    public boolean matchesNetworkAndMethod(Long l, Collection<String> collection) {
        return this.matchesNetwork(l) && CollectionHelper.isNotEmpty(collection) && collection.contains(this.methodName);
    }

    public boolean matchesNetworkAndMethod(Long l, String string) {
        return this.matchesNetwork(l) && Objects.equals(this.methodName, string);
    }

    public boolean matchesNetworkMethodAndArgument(Long l, String string, Serializable serializable) {
        return this.matchesNetworkAndMethod(l, string) && Objects.equals(this.argument, serializable);
    }

    public boolean matchesProduct(Long l) {
        return this.productIds.contains(l);
    }

    public String toString() {
        String string = String.valueOf(this.productIds) + "." + this.methodName + "@" + String.valueOf(this.networkId == null ? "global" : this.networkId);
        if (this.argument != null) {
            string = string + ", arg: " + String.valueOf(this.argument);
        }
        return string;
    }
}

